import type { Metadata } from "next";
import { connection } from "next/server";
import { Inter } from "next/font/google";
import "./globals.css";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default async function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  // Opt-out of static generation for every page so the CSP nonce can be applied
  await connection()

  return (
    <html lang="en">
      <body className={inter.className}>{children}</body>
    </html>
  );
}
