const path = require("path");
const webpack = require("webpack");

module.exports = {
    mode: "development",
    entry: "./client/index.js",
    output: {
        path: path.resolve(__dirname, "dist"),
        filename: "bundle.js",
    },
    resolve: {
        fallback: {
            buffer: require.resolve("buffer/"),
            stream: require.resolve("stream-browserify"),
            crypto: require.resolve("crypto-browserify"),
            vm: require.resolve("vm-browserify"),
            process: require.resolve("process/browser.js"),
        },
    },
    plugins: [
        new webpack.ProvidePlugin({
            process: "process/browser.js",
            Buffer: ["buffer", "Buffer"],
        }),
    ],
    devServer: {
        static: {
            directory: path.resolve(__dirname, "dist"),
        },
        port: 3000,
        open: true,
        hot: true,
        compress: true,
        historyApiFallback: true,
    },
    module: {
        rules: [
            {
                test: /\.css$/i,
                include: path.resolve(__dirname, "client"),
                use: ["style-loader", "css-loader", "postcss-loader"],
            },
        ],
    },
};
