// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: Transparency.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///  Copyright © 2024 Apple, Inc. All rights reserved.

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// Protobuf protocol protocol version.
/// Later versions must have larger ordinal numbers.  Device clients require number in enum name to match ordinal number.
enum TxPB_ProtocolVersion: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknownVersion // = 0

  /// V1 used in early builds, deprecated
  case v1 // = 1

  /// V2 introduced in 1530 (iOS 15.2). Adds account key, converts map leaves to TLS presentation language, changes some VRFs to SHA256 hashes
  case v2 // = 2

  /// V3 (was 2_1) introduced in 1540 (iOS 15.3). Same as V2 but clients can handle opt-in SMTs in query responses
  case v3 // = 3

  /// Future version used for testing
  case future // = 999999999
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownVersion
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownVersion
    case 1: self = .v1
    case 2: self = .v2
    case 3: self = .v3
    case 999999999: self = .future
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownVersion: return 0
    case .v1: return 1
    case .v2: return 2
    case .v3: return 3
    case .future: return 999999999
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_ProtocolVersion] = [
    .unknownVersion,
    .v1,
    .v2,
    .v3,
    .future,
  ]

}

/// Application is the smallest grouping that can not be divided across multiple sets of PACL,
/// PAM, and PAT. It defines a map-index namespace and is associated with a personality.
enum TxPB_Application: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknownApplication // = 0
  case idsMessaging // = 1
  case privateCloudCompute // = 5
  case privateCloudComputeInternal // = 6
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownApplication
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownApplication
    case 1: self = .idsMessaging
    case 5: self = .privateCloudCompute
    case 6: self = .privateCloudComputeInternal
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownApplication: return 0
    case .idsMessaging: return 1
    case .privateCloudCompute: return 5
    case .privateCloudComputeInternal: return 6
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_Application] = [
    .unknownApplication,
    .idsMessaging,
    .privateCloudCompute,
    .privateCloudComputeInternal,
  ]

}

/// API response status.
enum TxPB_Status: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknownStatus // = 0
  case ok // = 1

  /// 2 - can reuse
  case mutationPending // = 3
  case alreadyExists // = 4
  case internalError // = 5
  case invalidRequest // = 6

  /// V2: removed TOO_MANY_VRF_REQUESTS = 8; because queries no longer need to request VRF witnesses for deviceId and clientData
  case notFound // = 7
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownStatus
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownStatus
    case 1: self = .ok
    case 3: self = .mutationPending
    case 4: self = .alreadyExists
    case 5: self = .internalError
    case 6: self = .invalidRequest
    case 7: self = .notFound
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownStatus: return 0
    case .ok: return 1
    case .mutationPending: return 3
    case .alreadyExists: return 4
    case .internalError: return 5
    case .invalidRequest: return 6
    case .notFound: return 7
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_Status] = [
    .unknownStatus,
    .ok,
    .mutationPending,
    .alreadyExists,
    .internalError,
    .invalidRequest,
    .notFound,
  ]

}

enum TxPB_VRFType: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknownVrf // = 0

  /// 1, 2 - can reuse
  case ecvrfEd25519Sha512Elligator2 // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownVrf
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownVrf
    case 3: self = .ecvrfEd25519Sha512Elligator2
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownVrf: return 0
    case .ecvrfEd25519Sha512Elligator2: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_VRFType] = [
    .unknownVrf,
    .ecvrfEd25519Sha512Elligator2,
  ]

}

enum TxPB_LogType: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknownLog // = 0
  case perApplicationChangeLog // = 1
  case perApplicationTree // = 2
  case topLevelTree // = 3
  case ctLog // = 4
  case atLog // = 5
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownLog
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownLog
    case 1: self = .perApplicationChangeLog
    case 2: self = .perApplicationTree
    case 3: self = .topLevelTree
    case 4: self = .ctLog
    case 5: self = .atLog
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownLog: return 0
    case .perApplicationChangeLog: return 1
    case .perApplicationTree: return 2
    case .topLevelTree: return 3
    case .ctLog: return 4
    case .atLog: return 5
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_LogType] = [
    .unknownLog,
    .perApplicationChangeLog,
    .perApplicationTree,
    .topLevelTree,
    .ctLog,
    .atLog,
  ]

}

enum TxPB_MapType: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknownMap // = 0
  case perAppObjectMap // = 1
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownMap
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownMap
    case 1: self = .perAppObjectMap
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownMap: return 0
    case .perAppObjectMap: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_MapType] = [
    .unknownMap,
    .perAppObjectMap,
  ]

}

enum TxPB_NodeType: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int

  /// Dependent on personality. for IDS this is a ChangeLogNode
  case paclNode // = 0

  /// PerApplicationTreeNode
  case patNode // = 1

  /// Only valid for node index 0. PerApplicationTreeConfigNode
  case patConfigNode // = 2

  /// TopLevelTreeNode
  case tltNode // = 3

  /// Only valid for node index 0. TopLevelTreeConfigNode
  case tltConfigNode // = 4

  /// Valid for PAT or TLT. LogClosedNode
  case logClosedNode // = 5

  /// Certificate transparency log node.
  case ctNode // = 6

  /// Private Cloud Compute log node. Can be an attestation node or certificate node (ChangeLogNodeV2 with an ATLeafData struct).
  case atlNode // = 7
  case UNRECOGNIZED(Int)

  init() {
    self = .paclNode
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .paclNode
    case 1: self = .patNode
    case 2: self = .patConfigNode
    case 3: self = .tltNode
    case 4: self = .tltConfigNode
    case 5: self = .logClosedNode
    case 6: self = .ctNode
    case 7: self = .atlNode
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .paclNode: return 0
    case .patNode: return 1
    case .patConfigNode: return 2
    case .tltNode: return 3
    case .tltConfigNode: return 4
    case .logClosedNode: return 5
    case .ctNode: return 6
    case .atlNode: return 7
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_NodeType] = [
    .paclNode,
    .patNode,
    .patConfigNode,
    .tltNode,
    .tltConfigNode,
    .logClosedNode,
    .ctNode,
    .atlNode,
  ]

}

struct TxPB_VRFWitness: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var type: TxPB_VRFType = .unknownVrf

  var output: Data = Data()

  var proof: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_VRFPublicKey: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var vrfKey: Data = Data()

  var type: TxPB_VRFType = .unknownVrf

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_Signature: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var signature: Data = Data()

  /// This is a hash of the DER encoded public key used to verify the signature.
  /// It is used to identify the correct key from multiple signing keys.
  var signingKeySpkihash: Data = Data()

  var algorithm: TxPB_Signature.SignatureAlgorithm = .unknown

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  enum SignatureAlgorithm: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unknown // = 0
    case ecdsaSha256 // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .unknown
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unknown
      case 1: self = .ecdsaSha256
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unknown: return 0
      case .ecdsaSha256: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [TxPB_Signature.SignatureAlgorithm] = [
      .unknown,
      .ecdsaSha256,
    ]

  }

  init() {}
}

struct TxPB_SignedObject: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// parse as a LogHead, MapHead, Mutation, or whatever is appropriate given context
  var object: Data = Data()

  var signature: TxPB_Signature {
    get {return _signature ?? TxPB_Signature()}
    set {_signature = newValue}
  }
  /// Returns true if `signature` has been explicitly set.
  var hasSignature: Bool {return self._signature != nil}
  /// Clears the value of `signature`. Subsequent reads from it will return its default value.
  mutating func clearSignature() {self._signature = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _signature: TxPB_Signature? = nil
}

struct TxPB_LogHead: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Used to identify the new tree when the tree has been reset
  var logBeginningMs: UInt64 = 0

  var logSize: UInt64 = 0

  var logHeadHash: Data = Data()

  var revision: UInt64 = 0

  var logType: TxPB_LogType = .unknownLog

  /// omitted for TLT
  var application: TxPB_Application = .unknownApplication

  var treeID: UInt64 = 0

  var timestampMs: UInt64 = 0

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

/// The value and inclusion proof of a log leaf.
struct TxPB_LogEntry: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var logType: TxPB_LogType = .unknownLog

  var slh: TxPB_SignedObject {
    get {return _slh ?? TxPB_SignedObject()}
    set {_slh = newValue}
  }
  /// Returns true if `slh` has been explicitly set.
  var hasSlh: Bool {return self._slh != nil}
  /// Clears the value of `slh`. Subsequent reads from it will return its default value.
  mutating func clearSlh() {self._slh = nil}

  /// ordered with leaf at position 0, root-1 at end
  var hashesOfPeersInPathToRoot: [Data] = []

  /// Parse based on nodeType
  var nodeBytes: Data = Data()

  /// in range [0, slh.logSize)
  var nodePosition: UInt64 = 0

  var nodeType: TxPB_NodeType = .paclNode

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _slh: TxPB_SignedObject? = nil
}

struct TxPB_MapHead: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var logBeginningMs: UInt64 = 0

  var mapHeadHash: Data = Data()

  var application: TxPB_Application = .unknownApplication

  var changeLogHead: TxPB_LogHead {
    get {return _changeLogHead ?? TxPB_LogHead()}
    set {_changeLogHead = newValue}
  }
  /// Returns true if `changeLogHead` has been explicitly set.
  var hasChangeLogHead: Bool {return self._changeLogHead != nil}
  /// Clears the value of `changeLogHead`. Subsequent reads from it will return its default value.
  mutating func clearChangeLogHead() {self._changeLogHead = nil}

  var revision: UInt64 = 0

  var mapType: TxPB_MapType = .unknownMap

  var treeID: UInt64 = 0

  var timestampMs: UInt64 = 0

  /// if true, indicates this map may not yet contain a full set of data
  var populating: Bool = false

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _changeLogHead: TxPB_LogHead? = nil
}

/// Value and inclusion proof of a map leaf.
struct TxPB_MapEntry: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var smh: TxPB_SignedObject {
    get {return _smh ?? TxPB_SignedObject()}
    set {_smh = newValue}
  }
  /// Returns true if `smh` has been explicitly set.
  var hasSmh: Bool {return self._smh != nil}
  /// Clears the value of `smh`. Subsequent reads from it will return its default value.
  mutating func clearSmh() {self._smh = nil}

  /// When computing the hash chain, prepend each non-leaf hash with 0x01
  /// Empty peers may be omitted since they can be calculated by the client
  var hashesOfPeersInPathToRoot: [Data] = []

  /// When computing the hash chain, Prepend the hash of these bytes with 0x00
  var mapLeaf: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _smh: TxPB_SignedObject? = nil
}

struct TxPB_InclusionProof: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// V2: removed uriVRFOutput = 1
  var mapEntry: TxPB_MapEntry {
    get {return _storage._mapEntry ?? TxPB_MapEntry()}
    set {_uniqueStorage()._mapEntry = newValue}
  }
  /// Returns true if `mapEntry` has been explicitly set.
  var hasMapEntry: Bool {return _storage._mapEntry != nil}
  /// Clears the value of `mapEntry`. Subsequent reads from it will return its default value.
  mutating func clearMapEntry() {_uniqueStorage()._mapEntry = nil}

  /// Added for V2, equals SHA256(uriVrfOutput)
  var index: Data {
    get {return _storage._index}
    set {_uniqueStorage()._index = newValue}
  }

  /// optional
  var perApplicationTreeEntry: TxPB_LogEntry {
    get {return _storage._perApplicationTreeEntry ?? TxPB_LogEntry()}
    set {_uniqueStorage()._perApplicationTreeEntry = newValue}
  }
  /// Returns true if `perApplicationTreeEntry` has been explicitly set.
  var hasPerApplicationTreeEntry: Bool {return _storage._perApplicationTreeEntry != nil}
  /// Clears the value of `perApplicationTreeEntry`. Subsequent reads from it will return its default value.
  mutating func clearPerApplicationTreeEntry() {_uniqueStorage()._perApplicationTreeEntry = nil}

  /// optional
  var topLevelTreeEntry: TxPB_LogEntry {
    get {return _storage._topLevelTreeEntry ?? TxPB_LogEntry()}
    set {_uniqueStorage()._topLevelTreeEntry = newValue}
  }
  /// Returns true if `topLevelTreeEntry` has been explicitly set.
  var hasTopLevelTreeEntry: Bool {return _storage._topLevelTreeEntry != nil}
  /// Clears the value of `topLevelTreeEntry`. Subsequent reads from it will return its default value.
  mutating func clearTopLevelTreeEntry() {_uniqueStorage()._topLevelTreeEntry = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Inclusion proof of a PAT node
struct TxPB_PatInclusionProof: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var perApplicationTreeEntry: TxPB_LogEntry {
    get {return _storage._perApplicationTreeEntry ?? TxPB_LogEntry()}
    set {_uniqueStorage()._perApplicationTreeEntry = newValue}
  }
  /// Returns true if `perApplicationTreeEntry` has been explicitly set.
  var hasPerApplicationTreeEntry: Bool {return _storage._perApplicationTreeEntry != nil}
  /// Clears the value of `perApplicationTreeEntry`. Subsequent reads from it will return its default value.
  mutating func clearPerApplicationTreeEntry() {_uniqueStorage()._perApplicationTreeEntry = nil}

  var topLevelTreeEntry: TxPB_LogEntry {
    get {return _storage._topLevelTreeEntry ?? TxPB_LogEntry()}
    set {_uniqueStorage()._topLevelTreeEntry = newValue}
  }
  /// Returns true if `topLevelTreeEntry` has been explicitly set.
  var hasTopLevelTreeEntry: Bool {return _storage._topLevelTreeEntry != nil}
  /// Clears the value of `topLevelTreeEntry`. Subsequent reads from it will return its default value.
  mutating func clearTopLevelTreeEntry() {_uniqueStorage()._topLevelTreeEntry = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct TxPB_ChangeLogNodeV2: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Parse as appropriate for app, for IDS this is a TLS-encoded IdsMutation
  var mutation: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

/// node ID = SHA256( PAM tree ID || PAM revision )
struct TxPB_PerApplicationTreeNode: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// 1 - can reuse
  /// predecessorHead contains either MapHead or LogHead depending on the application
  var predecessorHead: TxPB_SignedObject {
    get {return _predecessorHead ?? TxPB_SignedObject()}
    set {_predecessorHead = newValue}
  }
  /// Returns true if `predecessorHead` has been explicitly set.
  var hasPredecessorHead: Bool {return self._predecessorHead != nil}
  /// Clears the value of `predecessorHead`. Subsequent reads from it will return its default value.
  mutating func clearPredecessorHead() {self._predecessorHead = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _predecessorHead: TxPB_SignedObject? = nil
}

struct TxPB_TopLevelTreeNode: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var patHead: TxPB_SignedObject {
    get {return _patHead ?? TxPB_SignedObject()}
    set {_patHead = newValue}
  }
  /// Returns true if `patHead` has been explicitly set.
  var hasPatHead: Bool {return self._patHead != nil}
  /// Clears the value of `patHead`. Subsequent reads from it will return its default value.
  mutating func clearPatHead() {self._patHead = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _patHead: TxPB_SignedObject? = nil
}

/// The first node (nodePosition 0) in a Per-Application Tree will have this value.
/// V1: node ID = SHA256(VRF Public Key)
/// V2: node ID = SHA256("Config node")
/// Private cloud compute PAT config nodes will not include the VRF public key
struct TxPB_PerApplicationTreeConfigNode: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var vrfPublicKey: TxPB_VRFPublicKey {
    get {return _vrfPublicKey ?? TxPB_VRFPublicKey()}
    set {_vrfPublicKey = newValue}
  }
  /// Returns true if `vrfPublicKey` has been explicitly set.
  var hasVrfPublicKey: Bool {return self._vrfPublicKey != nil}
  /// Clears the value of `vrfPublicKey`. Subsequent reads from it will return its default value.
  mutating func clearVrfPublicKey() {self._vrfPublicKey = nil}

  /// public key for signing roots of all trees for this app, encoded in DER SPKI
  var publicKeyBytes: Data = Data()

  /// first supported version for this tree, interpret not set as V1
  var earliestVersion: TxPB_ProtocolVersion = .unknownVersion

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _vrfPublicKey: TxPB_VRFPublicKey? = nil
}

/// The first node (nodePosition 0) in a Top-level Tree will have this value.
/// V1: node ID = SHA256(signing public key)
/// V2: node ID = SHA256("Config node")
struct TxPB_TopLevelTreeConfigNode: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// public key for signing roots of the top-level tree, encoded in DER SPKI
  var publicKeyBytes: Data = Data()

  /// first supported version for this tree, interpret not set as V1
  var earliestVersion: TxPB_ProtocolVersion = .unknownVersion

  var treeCounter: UInt32 = 0

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

/// Indicates that this PAT or TLT is shut down (for PAT, the PACL and PAM that feed it are also shut down).
/// Not necessarily the last PAT node. (PAT should contain no other nodes newer than this + MMD?)
/// node ID = SHA256("Closed node")
struct TxPB_LogClosedNode: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Any SMTs less than MMD before this may never merge
  var timestampMs: UInt64 = 0

  /// Earliest version that is supported by the new tree.
  var earliestVersionForNextTree: TxPB_ProtocolVersion = .unknownVersion

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

extension TxPB_ProtocolVersion: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_VERSION"),
    1: .same(proto: "V1"),
    2: .same(proto: "V2"),
    3: .same(proto: "V3"),
    999999999: .same(proto: "FUTURE"),
  ]
}

extension TxPB_Application: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_APPLICATION"),
    1: .same(proto: "IDS_MESSAGING"),
    5: .same(proto: "PRIVATE_CLOUD_COMPUTE"),
    6: .same(proto: "PRIVATE_CLOUD_COMPUTE_INTERNAL"),
  ]
}

extension TxPB_Status: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_STATUS"),
    1: .same(proto: "OK"),
    3: .same(proto: "MUTATION_PENDING"),
    4: .same(proto: "ALREADY_EXISTS"),
    5: .same(proto: "INTERNAL_ERROR"),
    6: .same(proto: "INVALID_REQUEST"),
    7: .same(proto: "NOT_FOUND"),
  ]
}

extension TxPB_VRFType: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_VRF"),
    3: .same(proto: "ECVRF_ED25519_SHA512_Elligator2"),
  ]
}

extension TxPB_LogType: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_LOG"),
    1: .same(proto: "PER_APPLICATION_CHANGE_LOG"),
    2: .same(proto: "PER_APPLICATION_TREE"),
    3: .same(proto: "TOP_LEVEL_TREE"),
    4: .same(proto: "CT_LOG"),
    5: .same(proto: "AT_LOG"),
  ]
}

extension TxPB_MapType: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_MAP"),
    1: .same(proto: "PER_APP_OBJECT_MAP"),
  ]
}

extension TxPB_NodeType: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "PACL_NODE"),
    1: .same(proto: "PAT_NODE"),
    2: .same(proto: "PAT_CONFIG_NODE"),
    3: .same(proto: "TLT_NODE"),
    4: .same(proto: "TLT_CONFIG_NODE"),
    5: .same(proto: "LOG_CLOSED_NODE"),
    6: .same(proto: "CT_NODE"),
    7: .same(proto: "ATL_NODE"),
  ]
}

extension TxPB_VRFWitness: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "VRFWitness"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "output"),
    3: .same(proto: "proof"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.output) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.proof) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.type != .unknownVrf {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    if !self.output.isEmpty {
      try visitor.visitSingularBytesField(value: self.output, fieldNumber: 2)
    }
    if !self.proof.isEmpty {
      try visitor.visitSingularBytesField(value: self.proof, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_VRFWitness, rhs: TxPB_VRFWitness) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.output != rhs.output {return false}
    if lhs.proof != rhs.proof {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_VRFPublicKey: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "VRFPublicKey"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "vrfKey"),
    2: .same(proto: "type"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.vrfKey) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.vrfKey.isEmpty {
      try visitor.visitSingularBytesField(value: self.vrfKey, fieldNumber: 1)
    }
    if self.type != .unknownVrf {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_VRFPublicKey, rhs: TxPB_VRFPublicKey) -> Bool {
    if lhs.vrfKey != rhs.vrfKey {return false}
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_Signature: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "Signature"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "signature"),
    2: .same(proto: "signingKeySPKIHash"),
    3: .same(proto: "algorithm"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.signature) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.signingKeySpkihash) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.algorithm) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.signature.isEmpty {
      try visitor.visitSingularBytesField(value: self.signature, fieldNumber: 1)
    }
    if !self.signingKeySpkihash.isEmpty {
      try visitor.visitSingularBytesField(value: self.signingKeySpkihash, fieldNumber: 2)
    }
    if self.algorithm != .unknown {
      try visitor.visitSingularEnumField(value: self.algorithm, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_Signature, rhs: TxPB_Signature) -> Bool {
    if lhs.signature != rhs.signature {return false}
    if lhs.signingKeySpkihash != rhs.signingKeySpkihash {return false}
    if lhs.algorithm != rhs.algorithm {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_Signature.SignatureAlgorithm: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN"),
    1: .same(proto: "ECDSA_SHA256"),
  ]
}

extension TxPB_SignedObject: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "SignedObject"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "object"),
    2: .same(proto: "signature"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.object) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._signature) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.object.isEmpty {
      try visitor.visitSingularBytesField(value: self.object, fieldNumber: 1)
    }
    try { if let v = self._signature {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_SignedObject, rhs: TxPB_SignedObject) -> Bool {
    if lhs.object != rhs.object {return false}
    if lhs._signature != rhs._signature {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogHead: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogHead"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "logBeginningMs"),
    2: .same(proto: "logSize"),
    3: .same(proto: "logHeadHash"),
    4: .same(proto: "revision"),
    5: .same(proto: "logType"),
    6: .same(proto: "application"),
    7: .same(proto: "treeId"),
    8: .same(proto: "timestampMs"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.logBeginningMs) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.logSize) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.logHeadHash) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.revision) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.logType) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 7: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 8: try { try decoder.decodeSingularUInt64Field(value: &self.timestampMs) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.logBeginningMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.logBeginningMs, fieldNumber: 1)
    }
    if self.logSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.logSize, fieldNumber: 2)
    }
    if !self.logHeadHash.isEmpty {
      try visitor.visitSingularBytesField(value: self.logHeadHash, fieldNumber: 3)
    }
    if self.revision != 0 {
      try visitor.visitSingularUInt64Field(value: self.revision, fieldNumber: 4)
    }
    if self.logType != .unknownLog {
      try visitor.visitSingularEnumField(value: self.logType, fieldNumber: 5)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 6)
    }
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 7)
    }
    if self.timestampMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.timestampMs, fieldNumber: 8)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogHead, rhs: TxPB_LogHead) -> Bool {
    if lhs.logBeginningMs != rhs.logBeginningMs {return false}
    if lhs.logSize != rhs.logSize {return false}
    if lhs.logHeadHash != rhs.logHeadHash {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.logType != rhs.logType {return false}
    if lhs.application != rhs.application {return false}
    if lhs.treeID != rhs.treeID {return false}
    if lhs.timestampMs != rhs.timestampMs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogEntry: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogEntry"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "logType"),
    2: .same(proto: "slh"),
    3: .same(proto: "hashesOfPeersInPathToRoot"),
    4: .same(proto: "nodeBytes"),
    5: .same(proto: "nodePosition"),
    6: .same(proto: "nodeType"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.logType) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._slh) }()
      case 3: try { try decoder.decodeRepeatedBytesField(value: &self.hashesOfPeersInPathToRoot) }()
      case 4: try { try decoder.decodeSingularBytesField(value: &self.nodeBytes) }()
      case 5: try { try decoder.decodeSingularUInt64Field(value: &self.nodePosition) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.nodeType) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.logType != .unknownLog {
      try visitor.visitSingularEnumField(value: self.logType, fieldNumber: 1)
    }
    try { if let v = self._slh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.hashesOfPeersInPathToRoot.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.hashesOfPeersInPathToRoot, fieldNumber: 3)
    }
    if !self.nodeBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.nodeBytes, fieldNumber: 4)
    }
    if self.nodePosition != 0 {
      try visitor.visitSingularUInt64Field(value: self.nodePosition, fieldNumber: 5)
    }
    if self.nodeType != .paclNode {
      try visitor.visitSingularEnumField(value: self.nodeType, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogEntry, rhs: TxPB_LogEntry) -> Bool {
    if lhs.logType != rhs.logType {return false}
    if lhs._slh != rhs._slh {return false}
    if lhs.hashesOfPeersInPathToRoot != rhs.hashesOfPeersInPathToRoot {return false}
    if lhs.nodeBytes != rhs.nodeBytes {return false}
    if lhs.nodePosition != rhs.nodePosition {return false}
    if lhs.nodeType != rhs.nodeType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_MapHead: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "MapHead"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "logBeginningMs"),
    2: .same(proto: "mapHeadHash"),
    3: .same(proto: "application"),
    4: .same(proto: "changeLogHead"),
    5: .same(proto: "revision"),
    6: .same(proto: "mapType"),
    7: .same(proto: "treeId"),
    8: .same(proto: "timestampMs"),
    9: .same(proto: "populating"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.logBeginningMs) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.mapHeadHash) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._changeLogHead) }()
      case 5: try { try decoder.decodeSingularUInt64Field(value: &self.revision) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.mapType) }()
      case 7: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 8: try { try decoder.decodeSingularUInt64Field(value: &self.timestampMs) }()
      case 9: try { try decoder.decodeSingularBoolField(value: &self.populating) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.logBeginningMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.logBeginningMs, fieldNumber: 1)
    }
    if !self.mapHeadHash.isEmpty {
      try visitor.visitSingularBytesField(value: self.mapHeadHash, fieldNumber: 2)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 3)
    }
    try { if let v = self._changeLogHead {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    if self.revision != 0 {
      try visitor.visitSingularUInt64Field(value: self.revision, fieldNumber: 5)
    }
    if self.mapType != .unknownMap {
      try visitor.visitSingularEnumField(value: self.mapType, fieldNumber: 6)
    }
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 7)
    }
    if self.timestampMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.timestampMs, fieldNumber: 8)
    }
    if self.populating != false {
      try visitor.visitSingularBoolField(value: self.populating, fieldNumber: 9)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_MapHead, rhs: TxPB_MapHead) -> Bool {
    if lhs.logBeginningMs != rhs.logBeginningMs {return false}
    if lhs.mapHeadHash != rhs.mapHeadHash {return false}
    if lhs.application != rhs.application {return false}
    if lhs._changeLogHead != rhs._changeLogHead {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.mapType != rhs.mapType {return false}
    if lhs.treeID != rhs.treeID {return false}
    if lhs.timestampMs != rhs.timestampMs {return false}
    if lhs.populating != rhs.populating {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_MapEntry: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "MapEntry"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "smh"),
    2: .same(proto: "hashesOfPeersInPathToRoot"),
    3: .same(proto: "mapLeaf"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._smh) }()
      case 2: try { try decoder.decodeRepeatedBytesField(value: &self.hashesOfPeersInPathToRoot) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.mapLeaf) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._smh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.hashesOfPeersInPathToRoot.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.hashesOfPeersInPathToRoot, fieldNumber: 2)
    }
    if !self.mapLeaf.isEmpty {
      try visitor.visitSingularBytesField(value: self.mapLeaf, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_MapEntry, rhs: TxPB_MapEntry) -> Bool {
    if lhs._smh != rhs._smh {return false}
    if lhs.hashesOfPeersInPathToRoot != rhs.hashesOfPeersInPathToRoot {return false}
    if lhs.mapLeaf != rhs.mapLeaf {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_InclusionProof: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "InclusionProof"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    2: .same(proto: "mapEntry"),
    3: .same(proto: "index"),
    4: .same(proto: "perApplicationTreeEntry"),
    5: .same(proto: "topLevelTreeEntry"),
  ]

  fileprivate class _StorageClass {
    var _mapEntry: TxPB_MapEntry? = nil
    var _index: Data = Data()
    var _perApplicationTreeEntry: TxPB_LogEntry? = nil
    var _topLevelTreeEntry: TxPB_LogEntry? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _mapEntry = source._mapEntry
      _index = source._index
      _perApplicationTreeEntry = source._perApplicationTreeEntry
      _topLevelTreeEntry = source._topLevelTreeEntry
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._mapEntry) }()
        case 3: try { try decoder.decodeSingularBytesField(value: &_storage._index) }()
        case 4: try { try decoder.decodeSingularMessageField(value: &_storage._perApplicationTreeEntry) }()
        case 5: try { try decoder.decodeSingularMessageField(value: &_storage._topLevelTreeEntry) }()
        default: break
        }
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._mapEntry {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      if !_storage._index.isEmpty {
        try visitor.visitSingularBytesField(value: _storage._index, fieldNumber: 3)
      }
      try { if let v = _storage._perApplicationTreeEntry {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      } }()
      try { if let v = _storage._topLevelTreeEntry {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_InclusionProof, rhs: TxPB_InclusionProof) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._mapEntry != rhs_storage._mapEntry {return false}
        if _storage._index != rhs_storage._index {return false}
        if _storage._perApplicationTreeEntry != rhs_storage._perApplicationTreeEntry {return false}
        if _storage._topLevelTreeEntry != rhs_storage._topLevelTreeEntry {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PatInclusionProof: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PatInclusionProof"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "perApplicationTreeEntry"),
    2: .same(proto: "topLevelTreeEntry"),
  ]

  fileprivate class _StorageClass {
    var _perApplicationTreeEntry: TxPB_LogEntry? = nil
    var _topLevelTreeEntry: TxPB_LogEntry? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _perApplicationTreeEntry = source._perApplicationTreeEntry
      _topLevelTreeEntry = source._topLevelTreeEntry
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._perApplicationTreeEntry) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._topLevelTreeEntry) }()
        default: break
        }
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._perApplicationTreeEntry {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._topLevelTreeEntry {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PatInclusionProof, rhs: TxPB_PatInclusionProof) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._perApplicationTreeEntry != rhs_storage._perApplicationTreeEntry {return false}
        if _storage._topLevelTreeEntry != rhs_storage._topLevelTreeEntry {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ChangeLogNodeV2: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ChangeLogNodeV2"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "mutation"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.mutation) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.mutation.isEmpty {
      try visitor.visitSingularBytesField(value: self.mutation, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ChangeLogNodeV2, rhs: TxPB_ChangeLogNodeV2) -> Bool {
    if lhs.mutation != rhs.mutation {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PerApplicationTreeNode: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PerApplicationTreeNode"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    2: .same(proto: "predecessorHead"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularMessageField(value: &self._predecessorHead) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._predecessorHead {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PerApplicationTreeNode, rhs: TxPB_PerApplicationTreeNode) -> Bool {
    if lhs._predecessorHead != rhs._predecessorHead {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_TopLevelTreeNode: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "TopLevelTreeNode"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "patHead"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._patHead) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._patHead {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_TopLevelTreeNode, rhs: TxPB_TopLevelTreeNode) -> Bool {
    if lhs._patHead != rhs._patHead {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PerApplicationTreeConfigNode: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PerApplicationTreeConfigNode"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "vrfPublicKey"),
    2: .same(proto: "publicKeyBytes"),
    3: .same(proto: "earliestVersion"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._vrfPublicKey) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.publicKeyBytes) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.earliestVersion) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._vrfPublicKey {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.publicKeyBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.publicKeyBytes, fieldNumber: 2)
    }
    if self.earliestVersion != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.earliestVersion, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PerApplicationTreeConfigNode, rhs: TxPB_PerApplicationTreeConfigNode) -> Bool {
    if lhs._vrfPublicKey != rhs._vrfPublicKey {return false}
    if lhs.publicKeyBytes != rhs.publicKeyBytes {return false}
    if lhs.earliestVersion != rhs.earliestVersion {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_TopLevelTreeConfigNode: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "TopLevelTreeConfigNode"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "publicKeyBytes"),
    3: .same(proto: "earliestVersion"),
    4: .same(proto: "treeCounter"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.publicKeyBytes) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.earliestVersion) }()
      case 4: try { try decoder.decodeSingularUInt32Field(value: &self.treeCounter) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.publicKeyBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.publicKeyBytes, fieldNumber: 1)
    }
    if self.earliestVersion != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.earliestVersion, fieldNumber: 3)
    }
    if self.treeCounter != 0 {
      try visitor.visitSingularUInt32Field(value: self.treeCounter, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_TopLevelTreeConfigNode, rhs: TxPB_TopLevelTreeConfigNode) -> Bool {
    if lhs.publicKeyBytes != rhs.publicKeyBytes {return false}
    if lhs.earliestVersion != rhs.earliestVersion {return false}
    if lhs.treeCounter != rhs.treeCounter {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogClosedNode: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogClosedNode"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "timestampMs"),
    3: .same(proto: "earliestVersionForNextTree"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.timestampMs) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.earliestVersionForNextTree) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.timestampMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.timestampMs, fieldNumber: 1)
    }
    if self.earliestVersionForNextTree != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.earliestVersionForNextTree, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogClosedNode, rhs: TxPB_LogClosedNode) -> Bool {
    if lhs.timestampMs != rhs.timestampMs {return false}
    if lhs.earliestVersionForNextTree != rhs.earliestVersionForNextTree {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
