// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: KtClientApi.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///  Copyright © 2024 Apple, Inc. All rights reserved.

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

struct TxPB_ConsistencyProofRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var requests: [TxPB_ConsistencyProofRequest.LogConsistencyRequest] = []

  var logType: TxPB_LogType = .unknownLog

  /// If logType is not TopLevelTree, provide an application
  var application: TxPB_Application = .unknownApplication

  /// Used for logging, not expected when uuid is passed in headers
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct LogConsistencyRequest: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// V2: moved logType = 1 and application = 2 out of LogConsistencyRequest
    var startRevision: UInt64 = 0

    /// Required, must be > startRevision
    var endRevision: UInt64 = 0

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

/// Note: the server may, at its discretion, return multiple LogConsistencyResponses for a single LogConsistencyRequest.
/// For example, if a client requests a proof from revision 51 to 130, the server may return a consistency
/// proof of [51,130], or multiple adjoining proofs, like [51, 100], [100, 120], [120, 130].
///
/// The server may omit proofs (such as when too many are requested), the client should record the
/// returned proofs and make a new request for the unfulfilled proofs.
struct TxPB_ConsistencyProofResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var status: TxPB_Status = .unknownStatus

  /// 2 - can reuse
  /// these will be sorted by logId, start revision, end revision
  var responses: [TxPB_ConsistencyProofResponse.LogConsistencyResponse] = []

  var logType: TxPB_LogType = .unknownLog

  /// If logType is not TopLevelTree, provide an application
  var application: TxPB_Application = .unknownApplication

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  /// Individual consistency proofs, which can be linked to prove larger ranges
  struct LogConsistencyResponse: @unchecked Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// V2: moved logType = 1 and application = 2 out of LogConsistencyResponse
    var startSlh: TxPB_SignedObject {
      get {return _startSlh ?? TxPB_SignedObject()}
      set {_startSlh = newValue}
    }
    /// Returns true if `startSlh` has been explicitly set.
    var hasStartSlh: Bool {return self._startSlh != nil}
    /// Clears the value of `startSlh`. Subsequent reads from it will return its default value.
    mutating func clearStartSlh() {self._startSlh = nil}

    var endSlh: TxPB_SignedObject {
      get {return _endSlh ?? TxPB_SignedObject()}
      set {_endSlh = newValue}
    }
    /// Returns true if `endSlh` has been explicitly set.
    var hasEndSlh: Bool {return self._endSlh != nil}
    /// Clears the value of `endSlh`. Subsequent reads from it will return its default value.
    mutating func clearEndSlh() {self._endSlh = nil}

    var proofHashes: [Data] = []

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _startSlh: TxPB_SignedObject? = nil
    fileprivate var _endSlh: TxPB_SignedObject? = nil
  }

  init() {}
}

struct TxPB_RevisionLogInclusionProofRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var application: TxPB_Application = .unknownApplication

  /// Type of log in which to lookup leaves, either PAT or TLT
  var logType: TxPB_LogType = .unknownLog

  /// If logType is PAT, revisions will be from PAM. If logType is TLT, revisions will be from PAT.
  var revision: [UInt64] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

/// The server may omit proofs (such as when too many are requested), the client should record the
/// returned proofs and make a new request for the unfulfilled proofs.
struct TxPB_RevisionLogInclusionProofResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// OK, INVALID_REQUEST, or INTERNAL_ERROR
  var status: TxPB_Status = .unknownStatus

  /// not guaranteed to have every requested proof
  /// all these proofs will be under the same log head, sorted by leaf index
  var logEntry: [TxPB_LogEntry] = []

  /// if logEntries contains PAT proofs, this will be proof of the PAT head in the TLT, may be absent
  var topLevelTreeEntry: TxPB_LogEntry {
    get {return _topLevelTreeEntry ?? TxPB_LogEntry()}
    set {_topLevelTreeEntry = newValue}
  }
  /// Returns true if `topLevelTreeEntry` has been explicitly set.
  var hasTopLevelTreeEntry: Bool {return self._topLevelTreeEntry != nil}
  /// Clears the value of `topLevelTreeEntry`. Subsequent reads from it will return its default value.
  mutating func clearTopLevelTreeEntry() {self._topLevelTreeEntry = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _topLevelTreeEntry: TxPB_LogEntry? = nil
}

/// When making requests over HTTP the body can be omitted.  Instead, the Application should
/// be specified in the "x-apple-application" header using the numeric value, and the version
/// specified in the "x-protocol-version" header using the enum value.
/// Version 2, iMessage would be indicated with:
/// x-apple-application: 1
/// x-protocol-version: V2
struct TxPB_PublicKeysRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var application: TxPB_Application = .unknownApplication

  /// Used for logging, not expected when uuid is passed in headers
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_PublicKeysResponse: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var status: TxPB_Status {
    get {return _storage._status}
    set {_uniqueStorage()._status = newValue}
  }

  /// DER-encoded SMT and STH signing certificate(s) for the application's trees.
  var appLeafs: [Data] {
    get {return _storage._appLeafs}
    set {_uniqueStorage()._appLeafs = newValue}
  }

  /// DER-encoded STH signing certificate(s) for the TLT.
  var tltLeafs: [Data] {
    get {return _storage._tltLeafs}
    set {_uniqueStorage()._tltLeafs = newValue}
  }

  /// DER-encoded intermediate certificate(s).
  var intermediates: [Data] {
    get {return _storage._intermediates}
    set {_uniqueStorage()._intermediates = newValue}
  }

  /// inclusion proof of the PerApplicationTreeConfigNode
  /// Contains VRF public key, public key for signing roots of all trees for this app, and minimum version supported by these trees
  /// For Private Cloud Compute PATs, the config node uses the same protocol messages but does not include the VRF public key
  var patConfigProof: TxPB_PatInclusionProof {
    get {return _storage._patConfigProof ?? TxPB_PatInclusionProof()}
    set {_uniqueStorage()._patConfigProof = newValue}
  }
  /// Returns true if `patConfigProof` has been explicitly set.
  var hasPatConfigProof: Bool {return _storage._patConfigProof != nil}
  /// Clears the value of `patConfigProof`. Subsequent reads from it will return its default value.
  mutating func clearPatConfigProof() {_uniqueStorage()._patConfigProof = nil}

  /// inclusion proof of the TopLevelTreeConfigNode
  /// Contains public key for signing roots of top-level tree and minimum version supported by the TLT
  var tltConfigProof: TxPB_LogEntry {
    get {return _storage._tltConfigProof ?? TxPB_LogEntry()}
    set {_uniqueStorage()._tltConfigProof = newValue}
  }
  /// Returns true if `tltConfigProof` has been explicitly set.
  var hasTltConfigProof: Bool {return _storage._tltConfigProof != nil}
  /// Clears the value of `tltConfigProof`. Subsequent reads from it will return its default value.
  mutating func clearTltConfigProof() {_uniqueStorage()._tltConfigProof = nil}

  /// Inclusion proof of PatClosedNode of the last PAT that supported this ProtocolVersion.
  /// Only present if this ProtocolVersion is no longer supported.
  /// The patConfigProof will be from the same tree, tltConfigProof will be for the TLT with
  /// this PAT's heads, and certificates will be for this set of trees
  var patClosedProof: TxPB_PatInclusionProof {
    get {return _storage._patClosedProof ?? TxPB_PatInclusionProof()}
    set {_uniqueStorage()._patClosedProof = newValue}
  }
  /// Returns true if `patClosedProof` has been explicitly set.
  var hasPatClosedProof: Bool {return _storage._patClosedProof != nil}
  /// Clears the value of `patClosedProof`. Subsequent reads from it will return its default value.
  mutating func clearPatClosedProof() {_uniqueStorage()._patClosedProof = nil}

  /// Optional URL to information about tree roll or obsoletion.
  /// Displayed by the client in the notification when the roll is detected.
  var treeRollInfoURL: String {
    get {return _storage._treeRollInfoURL}
    set {_uniqueStorage()._treeRollInfoURL = newValue}
  }

  /// Proof of a recent PAM head in the PAT, used to check populating state
  /// Optional unless the PAM is still populating
  /// Uses the same PAT root as patConfigProof
  var pamHeadInPatProof: TxPB_LogEntry {
    get {return _storage._pamHeadInPatProof ?? TxPB_LogEntry()}
    set {_uniqueStorage()._pamHeadInPatProof = newValue}
  }
  /// Returns true if `pamHeadInPatProof` has been explicitly set.
  var hasPamHeadInPatProof: Bool {return _storage._pamHeadInPatProof != nil}
  /// Clears the value of `pamHeadInPatProof`. Subsequent reads from it will return its default value.
  mutating func clearPamHeadInPatProof() {_uniqueStorage()._pamHeadInPatProof = nil}

  /// DER-encoded STH signing certificate(s) for old tree root signing certs. PCC only, optional.
  var oldAppRootCerts: [Data] {
    get {return _storage._oldAppRootCerts}
    set {_uniqueStorage()._oldAppRootCerts = newValue}
  }

  var oldTltRootCerts: [Data] {
    get {return _storage._oldTltRootCerts}
    set {_uniqueStorage()._oldTltRootCerts = newValue}
  }

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

extension TxPB_ConsistencyProofRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ConsistencyProofRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "requests"),
    3: .same(proto: "logType"),
    4: .same(proto: "application"),
    5: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.requests) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.logType) }()
      case 4: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if !self.requests.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.requests, fieldNumber: 2)
    }
    if self.logType != .unknownLog {
      try visitor.visitSingularEnumField(value: self.logType, fieldNumber: 3)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 4)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ConsistencyProofRequest, rhs: TxPB_ConsistencyProofRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.requests != rhs.requests {return false}
    if lhs.logType != rhs.logType {return false}
    if lhs.application != rhs.application {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ConsistencyProofRequest.LogConsistencyRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = TxPB_ConsistencyProofRequest.protoMessageName + ".LogConsistencyRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    3: .same(proto: "startRevision"),
    4: .same(proto: "endRevision"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.startRevision) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.endRevision) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.startRevision != 0 {
      try visitor.visitSingularUInt64Field(value: self.startRevision, fieldNumber: 3)
    }
    if self.endRevision != 0 {
      try visitor.visitSingularUInt64Field(value: self.endRevision, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ConsistencyProofRequest.LogConsistencyRequest, rhs: TxPB_ConsistencyProofRequest.LogConsistencyRequest) -> Bool {
    if lhs.startRevision != rhs.startRevision {return false}
    if lhs.endRevision != rhs.endRevision {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ConsistencyProofResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ConsistencyProofResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    3: .same(proto: "responses"),
    4: .same(proto: "logType"),
    5: .same(proto: "application"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.responses) }()
      case 4: try { try decoder.decodeSingularEnumField(value: &self.logType) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    if !self.responses.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.responses, fieldNumber: 3)
    }
    if self.logType != .unknownLog {
      try visitor.visitSingularEnumField(value: self.logType, fieldNumber: 4)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ConsistencyProofResponse, rhs: TxPB_ConsistencyProofResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.responses != rhs.responses {return false}
    if lhs.logType != rhs.logType {return false}
    if lhs.application != rhs.application {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ConsistencyProofResponse.LogConsistencyResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = TxPB_ConsistencyProofResponse.protoMessageName + ".LogConsistencyResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    3: .same(proto: "startSLH"),
    4: .same(proto: "endSLH"),
    5: .same(proto: "proofHashes"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 3: try { try decoder.decodeSingularMessageField(value: &self._startSlh) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._endSlh) }()
      case 5: try { try decoder.decodeRepeatedBytesField(value: &self.proofHashes) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._startSlh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._endSlh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    if !self.proofHashes.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.proofHashes, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ConsistencyProofResponse.LogConsistencyResponse, rhs: TxPB_ConsistencyProofResponse.LogConsistencyResponse) -> Bool {
    if lhs._startSlh != rhs._startSlh {return false}
    if lhs._endSlh != rhs._endSlh {return false}
    if lhs.proofHashes != rhs.proofHashes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_RevisionLogInclusionProofRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "RevisionLogInclusionProofRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "application"),
    3: .same(proto: "logType"),
    4: .same(proto: "revision"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.logType) }()
      case 4: try { try decoder.decodeRepeatedUInt64Field(value: &self.revision) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 2)
    }
    if self.logType != .unknownLog {
      try visitor.visitSingularEnumField(value: self.logType, fieldNumber: 3)
    }
    if !self.revision.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.revision, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_RevisionLogInclusionProofRequest, rhs: TxPB_RevisionLogInclusionProofRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.application != rhs.application {return false}
    if lhs.logType != rhs.logType {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_RevisionLogInclusionProofResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "RevisionLogInclusionProofResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    4: .same(proto: "logEntry"),
    5: .same(proto: "topLevelTreeEntry"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 4: try { try decoder.decodeRepeatedMessageField(value: &self.logEntry) }()
      case 5: try { try decoder.decodeSingularMessageField(value: &self._topLevelTreeEntry) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    if !self.logEntry.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.logEntry, fieldNumber: 4)
    }
    try { if let v = self._topLevelTreeEntry {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_RevisionLogInclusionProofResponse, rhs: TxPB_RevisionLogInclusionProofResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.logEntry != rhs.logEntry {return false}
    if lhs._topLevelTreeEntry != rhs._topLevelTreeEntry {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PublicKeysRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PublicKeysRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "application"),
    3: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 2)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PublicKeysRequest, rhs: TxPB_PublicKeysRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.application != rhs.application {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PublicKeysResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PublicKeysResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "appLeafs"),
    3: .same(proto: "tltLeafs"),
    4: .same(proto: "intermediates"),
    9: .same(proto: "patConfigProof"),
    10: .same(proto: "tltConfigProof"),
    11: .same(proto: "patClosedProof"),
    12: .same(proto: "treeRollInfoUrl"),
    13: .same(proto: "pamHeadInPatProof"),
    14: .same(proto: "oldAppRootCerts"),
    15: .same(proto: "oldTltRootCerts"),
  ]

  fileprivate class _StorageClass {
    var _status: TxPB_Status = .unknownStatus
    var _appLeafs: [Data] = []
    var _tltLeafs: [Data] = []
    var _intermediates: [Data] = []
    var _patConfigProof: TxPB_PatInclusionProof? = nil
    var _tltConfigProof: TxPB_LogEntry? = nil
    var _patClosedProof: TxPB_PatInclusionProof? = nil
    var _treeRollInfoURL: String = String()
    var _pamHeadInPatProof: TxPB_LogEntry? = nil
    var _oldAppRootCerts: [Data] = []
    var _oldTltRootCerts: [Data] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _status = source._status
      _appLeafs = source._appLeafs
      _tltLeafs = source._tltLeafs
      _intermediates = source._intermediates
      _patConfigProof = source._patConfigProof
      _tltConfigProof = source._tltConfigProof
      _patClosedProof = source._patClosedProof
      _treeRollInfoURL = source._treeRollInfoURL
      _pamHeadInPatProof = source._pamHeadInPatProof
      _oldAppRootCerts = source._oldAppRootCerts
      _oldTltRootCerts = source._oldTltRootCerts
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularEnumField(value: &_storage._status) }()
        case 2: try { try decoder.decodeRepeatedBytesField(value: &_storage._appLeafs) }()
        case 3: try { try decoder.decodeRepeatedBytesField(value: &_storage._tltLeafs) }()
        case 4: try { try decoder.decodeRepeatedBytesField(value: &_storage._intermediates) }()
        case 9: try { try decoder.decodeSingularMessageField(value: &_storage._patConfigProof) }()
        case 10: try { try decoder.decodeSingularMessageField(value: &_storage._tltConfigProof) }()
        case 11: try { try decoder.decodeSingularMessageField(value: &_storage._patClosedProof) }()
        case 12: try { try decoder.decodeSingularStringField(value: &_storage._treeRollInfoURL) }()
        case 13: try { try decoder.decodeSingularMessageField(value: &_storage._pamHeadInPatProof) }()
        case 14: try { try decoder.decodeRepeatedBytesField(value: &_storage._oldAppRootCerts) }()
        case 15: try { try decoder.decodeRepeatedBytesField(value: &_storage._oldTltRootCerts) }()
        default: break
        }
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._status != .unknownStatus {
        try visitor.visitSingularEnumField(value: _storage._status, fieldNumber: 1)
      }
      if !_storage._appLeafs.isEmpty {
        try visitor.visitRepeatedBytesField(value: _storage._appLeafs, fieldNumber: 2)
      }
      if !_storage._tltLeafs.isEmpty {
        try visitor.visitRepeatedBytesField(value: _storage._tltLeafs, fieldNumber: 3)
      }
      if !_storage._intermediates.isEmpty {
        try visitor.visitRepeatedBytesField(value: _storage._intermediates, fieldNumber: 4)
      }
      try { if let v = _storage._patConfigProof {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
      } }()
      try { if let v = _storage._tltConfigProof {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
      } }()
      try { if let v = _storage._patClosedProof {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
      } }()
      if !_storage._treeRollInfoURL.isEmpty {
        try visitor.visitSingularStringField(value: _storage._treeRollInfoURL, fieldNumber: 12)
      }
      try { if let v = _storage._pamHeadInPatProof {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 13)
      } }()
      if !_storage._oldAppRootCerts.isEmpty {
        try visitor.visitRepeatedBytesField(value: _storage._oldAppRootCerts, fieldNumber: 14)
      }
      if !_storage._oldTltRootCerts.isEmpty {
        try visitor.visitRepeatedBytesField(value: _storage._oldTltRootCerts, fieldNumber: 15)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PublicKeysResponse, rhs: TxPB_PublicKeysResponse) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._status != rhs_storage._status {return false}
        if _storage._appLeafs != rhs_storage._appLeafs {return false}
        if _storage._tltLeafs != rhs_storage._tltLeafs {return false}
        if _storage._intermediates != rhs_storage._intermediates {return false}
        if _storage._patConfigProof != rhs_storage._patConfigProof {return false}
        if _storage._tltConfigProof != rhs_storage._tltConfigProof {return false}
        if _storage._patClosedProof != rhs_storage._patClosedProof {return false}
        if _storage._treeRollInfoURL != rhs_storage._treeRollInfoURL {return false}
        if _storage._pamHeadInPatProof != rhs_storage._pamHeadInPatProof {return false}
        if _storage._oldAppRootCerts != rhs_storage._oldAppRootCerts {return false}
        if _storage._oldTltRootCerts != rhs_storage._oldTltRootCerts {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
