// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: AuditorApi.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///  Copyright © 2024 Apple, Inc. All rights reserved.

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

struct TxPB_ListTreesRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  /// Used for logging
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_ListTreesResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var status: TxPB_Status = .unknownStatus

  var trees: [TxPB_ListTreesResponse.Tree] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct Tree: @unchecked Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var treeID: UInt64 = 0

    var logBeginningMs: UInt64 = 0

    var type: TxPB_ListTreesResponse.Tree.OneOf_Type? = nil

    var logType: TxPB_LogType {
      get {
        if case .logType(let v)? = type {return v}
        return .unknownLog
      }
      set {type = .logType(newValue)}
    }

    var mapType: TxPB_MapType {
      get {
        if case .mapType(let v)? = type {return v}
        return .unknownMap
      }
      set {type = .mapType(newValue)}
    }

    /// will be null if LogType is Top-level Tree
    var application: TxPB_Application = .unknownApplication

    var state: TxPB_ListTreesResponse.Tree.State = .unknown

    /// only present for Logs
    var mergeGroups: UInt64 = 0

    /// public key for signing roots of all trees for this app, encoded in DER SPKI
    var publicKeyBytes: Data = Data()

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    enum OneOf_Type: Equatable, Sendable {
      case logType(TxPB_LogType)
      case mapType(TxPB_MapType)

    }

    enum State: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
      typealias RawValue = Int
      case unknown // = 0
      case staged // = 1
      case active // = 2
      case retired // = 3
      case UNRECOGNIZED(Int)

      init() {
        self = .unknown
      }

      init?(rawValue: Int) {
        switch rawValue {
        case 0: self = .unknown
        case 1: self = .staged
        case 2: self = .active
        case 3: self = .retired
        default: self = .UNRECOGNIZED(rawValue)
        }
      }

      var rawValue: Int {
        switch self {
        case .unknown: return 0
        case .staged: return 1
        case .active: return 2
        case .retired: return 3
        case .UNRECOGNIZED(let i): return i
        }
      }

      // The compiler won't synthesize support with the UNRECOGNIZED case.
      static let allCases: [TxPB_ListTreesResponse.Tree.State] = [
        .unknown,
        .staged,
        .active,
        .retired,
      ]

    }

    init() {}
  }

  init() {}
}

struct TxPB_LogLeavesRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var treeID: UInt64 = 0

  /// 3 -- can reuse
  var startIndex: UInt64 = 0

  /// Exclusive
  var endIndex: UInt64 = 0

  /// Used for logging
  var requestUuid: String = String()

  var startMergeGroup: UInt32 = 0

  var endMergeGroup: UInt32 = 0

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_LogLeavesResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Return NOT_FOUND if any leaves in requested range do not exist.
  /// Return INVALID_REQUEST if merge group range is invalid
  var status: TxPB_Status = .unknownStatus

  /// 2 - can reuse
  var leaves: [TxPB_LogLeavesResponse.Leaf] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct Leaf: @unchecked Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var nodeType: TxPB_NodeType = .paclNode

    /// parse as appropriate for nodeType
    var nodeBytes: Data = Data()

    /// 0-indexed
    var index: UInt64 = 0

    var mergeGroup: UInt32 = 0

    /// only for AT leaves
    var rawData: Data = Data()

    /// only for AT leaves
    var metadata: Data = Data()

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

struct TxPB_LogLeavesForRevisionRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  /// must be PER_APPLICATION_TREE or TOP_LEVEL_TREE
  var logType: TxPB_LogType = .unknownLog

  var application: TxPB_Application = .unknownApplication

  /// Set to -1 to request latest revision
  var revision: UInt64 = 0

  /// Used for logging
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_LogLeavesForRevisionResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Returns NOT_FOUND if revision does not exist.
  var status: TxPB_Status = .unknownStatus

  /// for requested revision. Inclusion proofs will use this root.
  var slh: TxPB_SignedObject {
    get {return _slh ?? TxPB_SignedObject()}
    set {_slh = newValue}
  }
  /// Returns true if `slh` has been explicitly set.
  var hasSlh: Bool {return self._slh != nil}
  /// Clears the value of `slh`. Subsequent reads from it will return its default value.
  mutating func clearSlh() {self._slh = nil}

  /// not guaranteed to be in order.
  var leaves: [TxPB_LogLeavesForRevisionResponse.Leaf] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct Leaf: @unchecked Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var nodeType: TxPB_NodeType = .paclNode

    /// parse as appropriate for nodeType
    var nodeBytes: Data = Data()

    /// in range [0, slh.logSize)
    var nodePosition: UInt64 = 0

    /// Path to slh above. Ordered with leaf at 0, root-1 at end
    var hashesOfPeersInPathToRoot: [Data] = []

    /// only for AT leaves
    var rawData: Data = Data()

    /// only for AT leaves
    var metadata: Data = Data()

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _slh: TxPB_SignedObject? = nil
}

struct TxPB_LogHeadRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var treeID: UInt64 = 0

  /// 3 -- can reuse
  var revision: Int64 = 0

  /// Used for logging
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_LogHeadResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var status: TxPB_Status = .unknownStatus

  var logHead: TxPB_SignedObject {
    get {return _logHead ?? TxPB_SignedObject()}
    set {_logHead = newValue}
  }
  /// Returns true if `logHead` has been explicitly set.
  var hasLogHead: Bool {return self._logHead != nil}
  /// Clears the value of `logHead`. Subsequent reads from it will return its default value.
  mutating func clearLogHead() {self._logHead = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _logHead: TxPB_SignedObject? = nil
}

struct TxPB_MapHeadRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var treeID: UInt64 = 0

  /// 3 -- can reuse
  var revision: Int64 = 0

  /// Used for logging
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_MapHeadResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var status: TxPB_Status = .unknownStatus

  var smh: TxPB_SignedObject {
    get {return _smh ?? TxPB_SignedObject()}
    set {_smh = newValue}
  }
  /// Returns true if `smh` has been explicitly set.
  var hasSmh: Bool {return self._smh != nil}
  /// Clears the value of `smh`. Subsequent reads from it will return its default value.
  mutating func clearSmh() {self._smh = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _smh: TxPB_SignedObject? = nil
}

struct TxPB_MapNodeRequest: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var treeID: UInt64 = 0

  /// 3 -- can reuse
  var path: Data = Data()

  /// Top-down: 0 is root level, 255 is leaf level
  var depth: UInt32 = 0

  /// Request for revision 'i' will return version of node with highest revision less than or equal to 'i'
  var revision: UInt64 = 0

  /// Used for logging
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_MapNodeResponse: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Return NOT_FOUND if requested node does not exist in map for specified revision
  var status: TxPB_Status = .unknownStatus

  var hash: Data = Data()

  /// only present if this is a leaf node
  var value: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_PaclInclusionProofRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var application: TxPB_Application = .unknownApplication

  var smts: [TxPB_SignedObject] = []

  /// Used for logging
  var requestUuid: String = String()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_PaclInclusionProofResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// OK, INVALID_REQUEST, or INTERNAL_ERROR
  var status: TxPB_Status = .unknownStatus

  /// not guaranteed to have every requested proof
  /// all these proofs will be under the same log head, sorted by leaf index
  /// nodes will all be ChangeLogNode
  
  var logEntry: [TxPB_LogEntry] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

extension TxPB_ListTreesRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ListTreesRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ListTreesRequest, rhs: TxPB_ListTreesRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ListTreesResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ListTreesResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "trees"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.trees) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    if !self.trees.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.trees, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ListTreesResponse, rhs: TxPB_ListTreesResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.trees != rhs.trees {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ListTreesResponse.Tree: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = TxPB_ListTreesResponse.protoMessageName + ".Tree"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "treeId"),
    2: .same(proto: "logBeginningMs"),
    3: .same(proto: "logType"),
    4: .same(proto: "mapType"),
    5: .same(proto: "application"),
    6: .same(proto: "state"),
    7: .same(proto: "mergeGroups"),
    8: .same(proto: "publicKeyBytes"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.logBeginningMs) }()
      case 3: try {
        var v: TxPB_LogType?
        try decoder.decodeSingularEnumField(value: &v)
        if let v = v {
          if self.type != nil {try decoder.handleConflictingOneOf()}
          self.type = .logType(v)
        }
      }()
      case 4: try {
        var v: TxPB_MapType?
        try decoder.decodeSingularEnumField(value: &v)
        if let v = v {
          if self.type != nil {try decoder.handleConflictingOneOf()}
          self.type = .mapType(v)
        }
      }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.state) }()
      case 7: try { try decoder.decodeSingularUInt64Field(value: &self.mergeGroups) }()
      case 8: try { try decoder.decodeSingularBytesField(value: &self.publicKeyBytes) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 1)
    }
    if self.logBeginningMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.logBeginningMs, fieldNumber: 2)
    }
    switch self.type {
    case .logType?: try {
      guard case .logType(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularEnumField(value: v, fieldNumber: 3)
    }()
    case .mapType?: try {
      guard case .mapType(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularEnumField(value: v, fieldNumber: 4)
    }()
    case nil: break
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 5)
    }
    if self.state != .unknown {
      try visitor.visitSingularEnumField(value: self.state, fieldNumber: 6)
    }
    if self.mergeGroups != 0 {
      try visitor.visitSingularUInt64Field(value: self.mergeGroups, fieldNumber: 7)
    }
    if !self.publicKeyBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.publicKeyBytes, fieldNumber: 8)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ListTreesResponse.Tree, rhs: TxPB_ListTreesResponse.Tree) -> Bool {
    if lhs.treeID != rhs.treeID {return false}
    if lhs.logBeginningMs != rhs.logBeginningMs {return false}
    if lhs.type != rhs.type {return false}
    if lhs.application != rhs.application {return false}
    if lhs.state != rhs.state {return false}
    if lhs.mergeGroups != rhs.mergeGroups {return false}
    if lhs.publicKeyBytes != rhs.publicKeyBytes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ListTreesResponse.Tree.State: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN"),
    1: .same(proto: "STAGED"),
    2: .same(proto: "ACTIVE"),
    3: .same(proto: "RETIRED"),
  ]
}

extension TxPB_LogLeavesRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogLeavesRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "treeId"),
    4: .same(proto: "startIndex"),
    5: .same(proto: "endIndex"),
    6: .same(proto: "requestUuid"),
    7: .same(proto: "startMergeGroup"),
    8: .same(proto: "endMergeGroup"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.startIndex) }()
      case 5: try { try decoder.decodeSingularUInt64Field(value: &self.endIndex) }()
      case 6: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      case 7: try { try decoder.decodeSingularUInt32Field(value: &self.startMergeGroup) }()
      case 8: try { try decoder.decodeSingularUInt32Field(value: &self.endMergeGroup) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 2)
    }
    if self.startIndex != 0 {
      try visitor.visitSingularUInt64Field(value: self.startIndex, fieldNumber: 4)
    }
    if self.endIndex != 0 {
      try visitor.visitSingularUInt64Field(value: self.endIndex, fieldNumber: 5)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 6)
    }
    if self.startMergeGroup != 0 {
      try visitor.visitSingularUInt32Field(value: self.startMergeGroup, fieldNumber: 7)
    }
    if self.endMergeGroup != 0 {
      try visitor.visitSingularUInt32Field(value: self.endMergeGroup, fieldNumber: 8)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogLeavesRequest, rhs: TxPB_LogLeavesRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.treeID != rhs.treeID {return false}
    if lhs.startIndex != rhs.startIndex {return false}
    if lhs.endIndex != rhs.endIndex {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.startMergeGroup != rhs.startMergeGroup {return false}
    if lhs.endMergeGroup != rhs.endMergeGroup {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogLeavesResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogLeavesResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    3: .same(proto: "leaves"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.leaves) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    if !self.leaves.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.leaves, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogLeavesResponse, rhs: TxPB_LogLeavesResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.leaves != rhs.leaves {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogLeavesResponse.Leaf: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = TxPB_LogLeavesResponse.protoMessageName + ".Leaf"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "nodeType"),
    2: .same(proto: "nodeBytes"),
    3: .same(proto: "index"),
    4: .same(proto: "mergeGroup"),
    5: .same(proto: "rawData"),
    6: .same(proto: "metadata"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.nodeType) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.nodeBytes) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.index) }()
      case 4: try { try decoder.decodeSingularUInt32Field(value: &self.mergeGroup) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.rawData) }()
      case 6: try { try decoder.decodeSingularBytesField(value: &self.metadata) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.nodeType != .paclNode {
      try visitor.visitSingularEnumField(value: self.nodeType, fieldNumber: 1)
    }
    if !self.nodeBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.nodeBytes, fieldNumber: 2)
    }
    if self.index != 0 {
      try visitor.visitSingularUInt64Field(value: self.index, fieldNumber: 3)
    }
    if self.mergeGroup != 0 {
      try visitor.visitSingularUInt32Field(value: self.mergeGroup, fieldNumber: 4)
    }
    if !self.rawData.isEmpty {
      try visitor.visitSingularBytesField(value: self.rawData, fieldNumber: 5)
    }
    if !self.metadata.isEmpty {
      try visitor.visitSingularBytesField(value: self.metadata, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogLeavesResponse.Leaf, rhs: TxPB_LogLeavesResponse.Leaf) -> Bool {
    if lhs.nodeType != rhs.nodeType {return false}
    if lhs.nodeBytes != rhs.nodeBytes {return false}
    if lhs.index != rhs.index {return false}
    if lhs.mergeGroup != rhs.mergeGroup {return false}
    if lhs.rawData != rhs.rawData {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogLeavesForRevisionRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogLeavesForRevisionRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "logType"),
    3: .same(proto: "application"),
    4: .same(proto: "revision"),
    5: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.logType) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.revision) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.logType != .unknownLog {
      try visitor.visitSingularEnumField(value: self.logType, fieldNumber: 2)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 3)
    }
    if self.revision != 0 {
      try visitor.visitSingularUInt64Field(value: self.revision, fieldNumber: 4)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogLeavesForRevisionRequest, rhs: TxPB_LogLeavesForRevisionRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.logType != rhs.logType {return false}
    if lhs.application != rhs.application {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogLeavesForRevisionResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogLeavesForRevisionResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "slh"),
    3: .same(proto: "leaves"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._slh) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.leaves) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    try { if let v = self._slh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.leaves.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.leaves, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogLeavesForRevisionResponse, rhs: TxPB_LogLeavesForRevisionResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs._slh != rhs._slh {return false}
    if lhs.leaves != rhs.leaves {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogLeavesForRevisionResponse.Leaf: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = TxPB_LogLeavesForRevisionResponse.protoMessageName + ".Leaf"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "nodeType"),
    2: .same(proto: "nodeBytes"),
    3: .same(proto: "nodePosition"),
    4: .same(proto: "hashesOfPeersInPathToRoot"),
    5: .same(proto: "rawData"),
    6: .same(proto: "metadata"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.nodeType) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.nodeBytes) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.nodePosition) }()
      case 4: try { try decoder.decodeRepeatedBytesField(value: &self.hashesOfPeersInPathToRoot) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.rawData) }()
      case 6: try { try decoder.decodeSingularBytesField(value: &self.metadata) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.nodeType != .paclNode {
      try visitor.visitSingularEnumField(value: self.nodeType, fieldNumber: 1)
    }
    if !self.nodeBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.nodeBytes, fieldNumber: 2)
    }
    if self.nodePosition != 0 {
      try visitor.visitSingularUInt64Field(value: self.nodePosition, fieldNumber: 3)
    }
    if !self.hashesOfPeersInPathToRoot.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.hashesOfPeersInPathToRoot, fieldNumber: 4)
    }
    if !self.rawData.isEmpty {
      try visitor.visitSingularBytesField(value: self.rawData, fieldNumber: 5)
    }
    if !self.metadata.isEmpty {
      try visitor.visitSingularBytesField(value: self.metadata, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogLeavesForRevisionResponse.Leaf, rhs: TxPB_LogLeavesForRevisionResponse.Leaf) -> Bool {
    if lhs.nodeType != rhs.nodeType {return false}
    if lhs.nodeBytes != rhs.nodeBytes {return false}
    if lhs.nodePosition != rhs.nodePosition {return false}
    if lhs.hashesOfPeersInPathToRoot != rhs.hashesOfPeersInPathToRoot {return false}
    if lhs.rawData != rhs.rawData {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogHeadRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogHeadRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "treeId"),
    4: .same(proto: "revision"),
    5: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 4: try { try decoder.decodeSingularInt64Field(value: &self.revision) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 2)
    }
    if self.revision != 0 {
      try visitor.visitSingularInt64Field(value: self.revision, fieldNumber: 4)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogHeadRequest, rhs: TxPB_LogHeadRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.treeID != rhs.treeID {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogHeadResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogHeadResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    4: .same(proto: "logHead"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._logHead) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    try { if let v = self._logHead {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogHeadResponse, rhs: TxPB_LogHeadResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs._logHead != rhs._logHead {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_MapHeadRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "MapHeadRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "treeId"),
    4: .same(proto: "revision"),
    5: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 4: try { try decoder.decodeSingularInt64Field(value: &self.revision) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 2)
    }
    if self.revision != 0 {
      try visitor.visitSingularInt64Field(value: self.revision, fieldNumber: 4)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_MapHeadRequest, rhs: TxPB_MapHeadRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.treeID != rhs.treeID {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_MapHeadResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "MapHeadResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "smh"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._smh) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    try { if let v = self._smh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_MapHeadResponse, rhs: TxPB_MapHeadResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs._smh != rhs._smh {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_MapNodeRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "MapNodeRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "treeId"),
    4: .same(proto: "path"),
    5: .same(proto: "depth"),
    6: .same(proto: "revision"),
    7: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.treeID) }()
      case 4: try { try decoder.decodeSingularBytesField(value: &self.path) }()
      case 5: try { try decoder.decodeSingularUInt32Field(value: &self.depth) }()
      case 6: try { try decoder.decodeSingularUInt64Field(value: &self.revision) }()
      case 7: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.treeID != 0 {
      try visitor.visitSingularUInt64Field(value: self.treeID, fieldNumber: 2)
    }
    if !self.path.isEmpty {
      try visitor.visitSingularBytesField(value: self.path, fieldNumber: 4)
    }
    if self.depth != 0 {
      try visitor.visitSingularUInt32Field(value: self.depth, fieldNumber: 5)
    }
    if self.revision != 0 {
      try visitor.visitSingularUInt64Field(value: self.revision, fieldNumber: 6)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_MapNodeRequest, rhs: TxPB_MapNodeRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.treeID != rhs.treeID {return false}
    if lhs.path != rhs.path {return false}
    if lhs.depth != rhs.depth {return false}
    if lhs.revision != rhs.revision {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_MapNodeResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "MapNodeResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "hash"),
    3: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.hash) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.value) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    if !self.hash.isEmpty {
      try visitor.visitSingularBytesField(value: self.hash, fieldNumber: 2)
    }
    if !self.value.isEmpty {
      try visitor.visitSingularBytesField(value: self.value, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_MapNodeResponse, rhs: TxPB_MapNodeResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.hash != rhs.hash {return false}
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PaclInclusionProofRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PaclInclusionProofRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "application"),
    3: .same(proto: "smts"),
    4: .same(proto: "requestUuid"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.smts) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.requestUuid) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 2)
    }
    if !self.smts.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.smts, fieldNumber: 3)
    }
    if !self.requestUuid.isEmpty {
      try visitor.visitSingularStringField(value: self.requestUuid, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PaclInclusionProofRequest, rhs: TxPB_PaclInclusionProofRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.application != rhs.application {return false}
    if lhs.smts != rhs.smts {return false}
    if lhs.requestUuid != rhs.requestUuid {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_PaclInclusionProofResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "PaclInclusionProofResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "logEntry"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.logEntry) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    if !self.logEntry.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.logEntry, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_PaclInclusionProofResponse, rhs: TxPB_PaclInclusionProofResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.logEntry != rhs.logEntry {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
