// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: ATServiceApi.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///  Copyright © 2024 Apple, Inc. All rights reserved.

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

enum TxPB_ATLogDataType: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknown // = 0
  case release // = 1

  /// MODEL = 2; not used
  case keybundleTgt // = 3
  case keybundleOtt // = 4
  case keybundleOhttp // = 5
  case testMarker // = 100
  case UNRECOGNIZED(Int)

  init() {
    self = .unknown
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknown
    case 1: self = .release
    case 3: self = .keybundleTgt
    case 4: self = .keybundleOtt
    case 5: self = .keybundleOhttp
    case 100: self = .testMarker
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknown: return 0
    case .release: return 1
    case .keybundleTgt: return 3
    case .keybundleOtt: return 4
    case .keybundleOhttp: return 5
    case .testMarker: return 100
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [TxPB_ATLogDataType] = [
    .unknown,
    .release,
    .keybundleTgt,
    .keybundleOtt,
    .keybundleOhttp,
    .testMarker,
  ]

}

/// Insert data can go in one of two sets of fields.
/// For extra environment verification, populate the ATInsertData field and leave type, data, and
/// unhashedMetadata fields empty (they will be ignored if insertData is set).
/// For traditional requests, set type, data, and unhashedMetadata fields with data to insert and
/// leave insertData empty.
/// version, application, and expiryMs fields must be populated in either case.
struct TxPB_ATLogInsertRequest: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var application: TxPB_Application = .unknownApplication

  var type: TxPB_ATLogDataType = .unknown

  var expiryMs: UInt64 = 0

  var data: Data = Data()

  /// additional data available to researchers that will not be hashed or signed by the server
  var unhashedMetadata: Data = Data()

  var insertData: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_ATLogInsertResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Possible status values: MUTATION_PENDING (success), INTERNAL_ERROR, INVALID_REQUEST
  var status: TxPB_Status = .unknownStatus

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_ATLogProofRequest: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var application: TxPB_Application = .unknownApplication

  /// This is the SHA256 hash of the logged data.
  /// If the same data has been inserted multiple times, this will return the latest entry.
  var identifier: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_ATLogProofResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Possible status values: OK, INTERNAL_ERROR, INVALID_REQUEST, NOT_FOUND, MUTATION_PENDING
  /// Other values should be treated as INTERNAL_ERROR
  /// NOT_FOUND indicates the value was never inserted
  /// MUTATION_PENDING means it has been inserted but hasn't yet sequenced into the log, PAT, and TLT
  /// OK will return a full response, other values will only include status and serverEventInfo
  var status: TxPB_Status = .unknownStatus

  var proofs: TxPB_ATLogProofs {
    get {return _proofs ?? TxPB_ATLogProofs()}
    set {_proofs = newValue}
  }
  /// Returns true if `proofs` has been explicitly set.
  var hasProofs: Bool {return self._proofs != nil}
  /// Clears the value of `proofs`. Subsequent reads from it will return its default value.
  mutating func clearProofs() {self._proofs = nil}

  /// Expiry time of the returned leaf. Matches the expiry set in the insert request for this leaf.
  /// Also available in proofs.inclusionProof.nodsBytes -> parse as as proto ChangeLogNodeV2 -> value -> parse as TLS ATLeafData -> expiryMs
  /// That one is hashed... signed... tree consistency protections..., but this is much easier to access.
  var expiryMs: UInt64 = 0

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _proofs: TxPB_ATLogProofs? = nil
}

struct TxPB_ATLogProofs: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Inclusion proof for this data if it exists in the TL.
  var inclusionProof: TxPB_LogEntry {
    get {return _inclusionProof ?? TxPB_LogEntry()}
    set {_inclusionProof = newValue}
  }
  /// Returns true if `inclusionProof` has been explicitly set.
  var hasInclusionProof: Bool {return self._inclusionProof != nil}
  /// Clears the value of `inclusionProof`. Subsequent reads from it will return its default value.
  mutating func clearInclusionProof() {self._inclusionProof = nil}

  /// If the inclusion proof isn't to a milestone root, this will be included to prove consistency with a recent milestone
  var milestoneConsistency: TxPB_LogConsistency {
    get {return _milestoneConsistency ?? TxPB_LogConsistency()}
    set {_milestoneConsistency = newValue}
  }
  /// Returns true if `milestoneConsistency` has been explicitly set.
  var hasMilestoneConsistency: Bool {return self._milestoneConsistency != nil}
  /// Clears the value of `milestoneConsistency`. Subsequent reads from it will return its default value.
  mutating func clearMilestoneConsistency() {self._milestoneConsistency = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _inclusionProof: TxPB_LogEntry? = nil
  fileprivate var _milestoneConsistency: TxPB_LogConsistency? = nil
}

struct TxPB_LogConsistency: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// SLH of a milestone root
  var startSlh: TxPB_SignedObject {
    get {return _storage._startSlh ?? TxPB_SignedObject()}
    set {_uniqueStorage()._startSlh = newValue}
  }
  /// Returns true if `startSlh` has been explicitly set.
  var hasStartSlh: Bool {return _storage._startSlh != nil}
  /// Clears the value of `startSlh`. Subsequent reads from it will return its default value.
  mutating func clearStartSlh() {_uniqueStorage()._startSlh = nil}

  /// redundant, matches SLH in inclusionProof
  var endSlh: TxPB_SignedObject {
    get {return _storage._endSlh ?? TxPB_SignedObject()}
    set {_uniqueStorage()._endSlh = newValue}
  }
  /// Returns true if `endSlh` has been explicitly set.
  var hasEndSlh: Bool {return _storage._endSlh != nil}
  /// Clears the value of `endSlh`. Subsequent reads from it will return its default value.
  mutating func clearEndSlh() {_uniqueStorage()._endSlh = nil}

  var proofHashes: [Data] {
    get {return _storage._proofHashes}
    set {_uniqueStorage()._proofHashes = newValue}
  }

  /// inclusion proof of the endSLH in the PAT, and the PAT head in the TLT
  var patInclusionProof: TxPB_LogEntry {
    get {return _storage._patInclusionProof ?? TxPB_LogEntry()}
    set {_uniqueStorage()._patInclusionProof = newValue}
  }
  /// Returns true if `patInclusionProof` has been explicitly set.
  var hasPatInclusionProof: Bool {return _storage._patInclusionProof != nil}
  /// Clears the value of `patInclusionProof`. Subsequent reads from it will return its default value.
  mutating func clearPatInclusionProof() {_uniqueStorage()._patInclusionProof = nil}

  var tltInclusionProof: TxPB_LogEntry {
    get {return _storage._tltInclusionProof ?? TxPB_LogEntry()}
    set {_uniqueStorage()._tltInclusionProof = newValue}
  }
  /// Returns true if `tltInclusionProof` has been explicitly set.
  var hasTltInclusionProof: Bool {return _storage._tltInclusionProof != nil}
  /// Clears the value of `tltInclusionProof`. Subsequent reads from it will return its default value.
  mutating func clearTltInclusionProof() {_uniqueStorage()._tltInclusionProof = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

extension TxPB_ATLogDataType: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN"),
    1: .same(proto: "RELEASE"),
    3: .same(proto: "KEYBUNDLE_TGT"),
    4: .same(proto: "KEYBUNDLE_OTT"),
    5: .same(proto: "KEYBUNDLE_OHTTP"),
    100: .same(proto: "TEST_MARKER"),
  ]
}

extension TxPB_ATLogInsertRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogInsertRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "application"),
    3: .same(proto: "type"),
    4: .same(proto: "expiryMs"),
    5: .same(proto: "data"),
    6: .same(proto: "unhashedMetadata"),
    7: .same(proto: "insertData"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.expiryMs) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.data) }()
      case 6: try { try decoder.decodeSingularBytesField(value: &self.unhashedMetadata) }()
      case 7: try { try decoder.decodeSingularBytesField(value: &self.insertData) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 2)
    }
    if self.type != .unknown {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 3)
    }
    if self.expiryMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.expiryMs, fieldNumber: 4)
    }
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 5)
    }
    if !self.unhashedMetadata.isEmpty {
      try visitor.visitSingularBytesField(value: self.unhashedMetadata, fieldNumber: 6)
    }
    if !self.insertData.isEmpty {
      try visitor.visitSingularBytesField(value: self.insertData, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogInsertRequest, rhs: TxPB_ATLogInsertRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.application != rhs.application {return false}
    if lhs.type != rhs.type {return false}
    if lhs.expiryMs != rhs.expiryMs {return false}
    if lhs.data != rhs.data {return false}
    if lhs.unhashedMetadata != rhs.unhashedMetadata {return false}
    if lhs.insertData != rhs.insertData {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ATLogInsertResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogInsertResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogInsertResponse, rhs: TxPB_ATLogInsertResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ATLogProofRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogProofRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "application"),
    3: .same(proto: "identifier"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.identifier) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 2)
    }
    if !self.identifier.isEmpty {
      try visitor.visitSingularBytesField(value: self.identifier, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogProofRequest, rhs: TxPB_ATLogProofRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.application != rhs.application {return false}
    if lhs.identifier != rhs.identifier {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ATLogProofResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogProofResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    3: .same(proto: "proofs"),
    4: .same(proto: "expiryMs"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._proofs) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.expiryMs) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    try { if let v = self._proofs {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    if self.expiryMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.expiryMs, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogProofResponse, rhs: TxPB_ATLogProofResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs._proofs != rhs._proofs {return false}
    if lhs.expiryMs != rhs.expiryMs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ATLogProofs: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogProofs"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "inclusionProof"),
    2: .same(proto: "milestoneConsistency"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._inclusionProof) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._milestoneConsistency) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._inclusionProof {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._milestoneConsistency {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogProofs, rhs: TxPB_ATLogProofs) -> Bool {
    if lhs._inclusionProof != rhs._inclusionProof {return false}
    if lhs._milestoneConsistency != rhs._milestoneConsistency {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_LogConsistency: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "LogConsistency"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    3: .same(proto: "startSLH"),
    4: .same(proto: "endSLH"),
    5: .same(proto: "proofHashes"),
    8: .same(proto: "patInclusionProof"),
    9: .same(proto: "tltInclusionProof"),
  ]

  fileprivate class _StorageClass {
    var _startSlh: TxPB_SignedObject? = nil
    var _endSlh: TxPB_SignedObject? = nil
    var _proofHashes: [Data] = []
    var _patInclusionProof: TxPB_LogEntry? = nil
    var _tltInclusionProof: TxPB_LogEntry? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _startSlh = source._startSlh
      _endSlh = source._endSlh
      _proofHashes = source._proofHashes
      _patInclusionProof = source._patInclusionProof
      _tltInclusionProof = source._tltInclusionProof
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._startSlh) }()
        case 4: try { try decoder.decodeSingularMessageField(value: &_storage._endSlh) }()
        case 5: try { try decoder.decodeRepeatedBytesField(value: &_storage._proofHashes) }()
        case 8: try { try decoder.decodeSingularMessageField(value: &_storage._patInclusionProof) }()
        case 9: try { try decoder.decodeSingularMessageField(value: &_storage._tltInclusionProof) }()
        default: break
        }
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._startSlh {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._endSlh {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      } }()
      if !_storage._proofHashes.isEmpty {
        try visitor.visitRepeatedBytesField(value: _storage._proofHashes, fieldNumber: 5)
      }
      try { if let v = _storage._patInclusionProof {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
      } }()
      try { if let v = _storage._tltInclusionProof {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_LogConsistency, rhs: TxPB_LogConsistency) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._startSlh != rhs_storage._startSlh {return false}
        if _storage._endSlh != rhs_storage._endSlh {return false}
        if _storage._proofHashes != rhs_storage._proofHashes {return false}
        if _storage._patInclusionProof != rhs_storage._patInclusionProof {return false}
        if _storage._tltInclusionProof != rhs_storage._tltInclusionProof {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
