// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: ATResearcherApi.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///  Copyright © 2024 Apple, Inc. All rights reserved.

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

struct TxPB_ATLogInclusionProofRequest: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: TxPB_ProtocolVersion = .unknownVersion

  var application: TxPB_Application = .unknownApplication

  /// These are the SHA256 hash of the logged data.
  /// If the same data has been inserted multiple times, this will return the latest entry.
  var identifier: [Data] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct TxPB_ATLogInclusionProofResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// OK, INVALID_REQUEST, or INTERNAL_ERROR
  var status: TxPB_Status = .unknownStatus

  /// root under which all leaves are proven
  var slh: TxPB_SignedObject {
    get {return _slh ?? TxPB_SignedObject()}
    set {_slh = newValue}
  }
  /// Returns true if `slh` has been explicitly set.
  var hasSlh: Bool {return self._slh != nil}
  /// Clears the value of `slh`. Subsequent reads from it will return its default value.
  mutating func clearSlh() {self._slh = nil}

  /// not guaranteed to have every requested proof
  /// all these proofs will be under the same log head, sorted by leaf index
  var leaves: [TxPB_ATLogInclusionProofResponse.Leaf] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct Leaf: @unchecked Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// always NodeType.ATL_NODE (ChangeLogNodeV2 with an ATLeafData struct)
    var nodeType: TxPB_NodeType = .paclNode

    var nodeBytes: Data = Data()

    /// in range [0, slh.logSize)
    var nodePosition: UInt64 = 0

    /// Path to slh above. Ordered with leaf at 0, root-1 at end
    var hashesOfPeersInPathToRoot: [Data] = []

    var rawData: Data = Data()

    var metadata: Data = Data()

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _slh: TxPB_SignedObject? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

extension TxPB_ATLogInclusionProofRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogInclusionProofRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "application"),
    3: .same(proto: "identifier"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.version) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.application) }()
      case 3: try { try decoder.decodeRepeatedBytesField(value: &self.identifier) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != .unknownVersion {
      try visitor.visitSingularEnumField(value: self.version, fieldNumber: 1)
    }
    if self.application != .unknownApplication {
      try visitor.visitSingularEnumField(value: self.application, fieldNumber: 2)
    }
    if !self.identifier.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.identifier, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogInclusionProofRequest, rhs: TxPB_ATLogInclusionProofRequest) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.application != rhs.application {return false}
    if lhs.identifier != rhs.identifier {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ATLogInclusionProofResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ATLogInclusionProofResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "status"),
    2: .same(proto: "slh"),
    3: .same(proto: "leaves"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.status) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._slh) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.leaves) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.status != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.status, fieldNumber: 1)
    }
    try { if let v = self._slh {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.leaves.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.leaves, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogInclusionProofResponse, rhs: TxPB_ATLogInclusionProofResponse) -> Bool {
    if lhs.status != rhs.status {return false}
    if lhs._slh != rhs._slh {return false}
    if lhs.leaves != rhs.leaves {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension TxPB_ATLogInclusionProofResponse.Leaf: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = TxPB_ATLogInclusionProofResponse.protoMessageName + ".Leaf"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "nodeType"),
    2: .same(proto: "nodeBytes"),
    3: .same(proto: "nodePosition"),
    4: .same(proto: "hashesOfPeersInPathToRoot"),
    5: .same(proto: "rawData"),
    6: .same(proto: "metadata"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.nodeType) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.nodeBytes) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.nodePosition) }()
      case 4: try { try decoder.decodeRepeatedBytesField(value: &self.hashesOfPeersInPathToRoot) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.rawData) }()
      case 6: try { try decoder.decodeSingularBytesField(value: &self.metadata) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.nodeType != .paclNode {
      try visitor.visitSingularEnumField(value: self.nodeType, fieldNumber: 1)
    }
    if !self.nodeBytes.isEmpty {
      try visitor.visitSingularBytesField(value: self.nodeBytes, fieldNumber: 2)
    }
    if self.nodePosition != 0 {
      try visitor.visitSingularUInt64Field(value: self.nodePosition, fieldNumber: 3)
    }
    if !self.hashesOfPeersInPathToRoot.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.hashesOfPeersInPathToRoot, fieldNumber: 4)
    }
    if !self.rawData.isEmpty {
      try visitor.visitSingularBytesField(value: self.rawData, fieldNumber: 5)
    }
    if !self.metadata.isEmpty {
      try visitor.visitSingularBytesField(value: self.metadata, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: TxPB_ATLogInclusionProofResponse.Leaf, rhs: TxPB_ATLogInclusionProofResponse.Leaf) -> Bool {
    if lhs.nodeType != rhs.nodeType {return false}
    if lhs.nodeBytes != rhs.nodeBytes {return false}
    if lhs.nodePosition != rhs.nodePosition {return false}
    if lhs.hashesOfPeersInPathToRoot != rhs.hashesOfPeersInPathToRoot {return false}
    if lhs.rawData != rhs.rawData {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
