// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: RopesHttpService.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///
/// HTTP service provided by ROPES.

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

package struct Proto_Ropes_HttpService_InvokeRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var type: Proto_Ropes_HttpService_InvokeRequest.OneOf_Type? = nil

  package var setupRequest: Proto_Ropes_HttpService_InvokeRequest.SetupRequest {
    get {
      if case .setupRequest(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeRequest.SetupRequest()
    }
    set {type = .setupRequest(newValue)}
  }

  package var loggingMetadata: Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata {
    get {
      if case .loggingMetadata(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata()
    }
    set {type = .loggingMetadata(newValue)}
  }

  package var terminate: Proto_Ropes_HttpService_InvokeRequest.Terminate {
    get {
      if case .terminate(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeRequest.Terminate()
    }
    set {type = .terminate(newValue)}
  }

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package enum OneOf_Type: Equatable, Sendable {
    case setupRequest(Proto_Ropes_HttpService_InvokeRequest.SetupRequest)
    case loggingMetadata(Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata)
    case terminate(Proto_Ropes_HttpService_InvokeRequest.Terminate)

  }

  package struct SetupRequest: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// oHTTP context that the client is using to send encrypted request chunks
    package var encryptedRequestOhttpContext: UInt32 = 0

    /// Node identifiers that the client has cached attestations for
    package var attestationMappings: [Proto_Ropes_HttpService_InvokeRequest.SetupRequest.AttestationMapping] = []

    package var capabilities: Proto_Ropes_Common_Capabilities {
      get {return _capabilities ?? Proto_Ropes_Common_Capabilities()}
      set {_capabilities = newValue}
    }
    /// Returns true if `capabilities` has been explicitly set.
    package var hasCapabilities: Bool {return self._capabilities != nil}
    /// Clears the value of `capabilities`. Subsequent reads from it will return its default value.
    package mutating func clearCapabilities() {self._capabilities = nil}

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package struct AttestationMapping: Sendable {
      // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      package var nodeIdentifier: String = String()

      package var ohttpContext: UInt32 = 0

      package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

      package init() {}
    }

    package init() {}

    fileprivate var _capabilities: Proto_Ropes_Common_Capabilities? = nil
  }

  package struct LoggingMetadata: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    package var message: String = String()

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  /// When an unexpected error happens, the client should send a Terminate message instead of abruptly
  /// closing the stream. This provides ROPES useful information for monitoring/alerting purposes.
  package struct Terminate: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    package var code: Proto_Ropes_HttpService_InvokeRequest.Terminate.Code = .undefined

    package var reason: String {
      get {return _reason ?? String()}
      set {_reason = newValue}
    }
    /// Returns true if `reason` has been explicitly set.
    package var hasReason: Bool {return self._reason != nil}
    /// Clears the value of `reason`. Subsequent reads from it will return its default value.
    package mutating func clearReason() {self._reason = nil}

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package enum Code: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
      package typealias RawValue = Int
      case undefined // = 0

      /// Client failed to decrypt a response chunk
      case cryptoError // = 1

      /// Error happened at the TIE layer
      case applicationError // = 2
      case UNRECOGNIZED(Int)

      package init() {
        self = .undefined
      }

      package init?(rawValue: Int) {
        switch rawValue {
        case 0: self = .undefined
        case 1: self = .cryptoError
        case 2: self = .applicationError
        default: self = .UNRECOGNIZED(rawValue)
        }
      }

      package var rawValue: Int {
        switch self {
        case .undefined: return 0
        case .cryptoError: return 1
        case .applicationError: return 2
        case .UNRECOGNIZED(let i): return i
        }
      }

      // The compiler won't synthesize support with the UNRECOGNIZED case.
      package static let allCases: [Proto_Ropes_HttpService_InvokeRequest.Terminate.Code] = [
        .undefined,
        .cryptoError,
        .applicationError,
      ]

    }

    package init() {}

    fileprivate var _reason: String? = nil
  }

  package init() {}
}

package struct Proto_Ropes_HttpService_InvokeResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var type: Proto_Ropes_HttpService_InvokeResponse.OneOf_Type? = nil

  package var attestationList: Proto_Ropes_Common_AttestationList {
    get {
      if case .attestationList(let v)? = type {return v}
      return Proto_Ropes_Common_AttestationList()
    }
    set {type = .attestationList(newValue)}
  }

  package var compressedAttestationList: Proto_Ropes_Common_CompressedAttestationList {
    get {
      if case .compressedAttestationList(let v)? = type {return v}
      return Proto_Ropes_Common_CompressedAttestationList()
    }
    set {type = .compressedAttestationList(newValue)}
  }

  package var nodeSelected: Proto_Ropes_HttpService_InvokeResponse.NodeSelected {
    get {
      if case .nodeSelected(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeResponse.NodeSelected()
    }
    set {type = .nodeSelected(newValue)}
  }

  package var loggingMetadata: Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata {
    get {
      if case .loggingMetadata(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata()
    }
    set {type = .loggingMetadata(newValue)}
  }

  package var rateLimitConfigurationList: Proto_Ropes_RateLimit_RateLimitConfigurationList {
    get {
      if case .rateLimitConfigurationList(let v)? = type {return v}
      return Proto_Ropes_RateLimit_RateLimitConfigurationList()
    }
    set {type = .rateLimitConfigurationList(newValue)}
  }

  package var expiredAttestationList: Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList {
    get {
      if case .expiredAttestationList(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList()
    }
    set {type = .expiredAttestationList(newValue)}
  }

  /// ROPES sends this message to signal client that it'll not receive further attestations
  /// on current connection, for client to fail early.
  package var noFurtherAttestations: Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations {
    get {
      if case .noFurtherAttestations(let v)? = type {return v}
      return Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations()
    }
    set {type = .noFurtherAttestations(newValue)}
  }

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package enum OneOf_Type: Equatable, Sendable {
    case attestationList(Proto_Ropes_Common_AttestationList)
    case compressedAttestationList(Proto_Ropes_Common_CompressedAttestationList)
    case nodeSelected(Proto_Ropes_HttpService_InvokeResponse.NodeSelected)
    case loggingMetadata(Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata)
    case rateLimitConfigurationList(Proto_Ropes_RateLimit_RateLimitConfigurationList)
    case expiredAttestationList(Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList)
    /// ROPES sends this message to signal client that it'll not receive further attestations
    /// on current connection, for client to fail early.
    case noFurtherAttestations(Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations)

  }

  package struct NodeSelected: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  package struct LoggingMetadata: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    package var message: String = String()

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  package struct NoFurtherAttestations: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  package struct ExpiredAttestationList: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    package var nodeIdentifier: [String] = []

    /// Threshold is configured on Ropes.
    /// True: client invalidate attestation cache and triggers a prefetch.
    /// False: client prunes the returned node identifiers from attestation cache.
    package var shouldClearCache: Bool = false

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  package init() {}
}

package struct Proto_Ropes_HttpService_PrefetchAttestationsRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var capabilities: Proto_Ropes_Common_Capabilities {
    get {return _capabilities ?? Proto_Ropes_Common_Capabilities()}
    set {_capabilities = newValue}
  }
  /// Returns true if `capabilities` has been explicitly set.
  package var hasCapabilities: Bool {return self._capabilities != nil}
  /// Clears the value of `capabilities`. Subsequent reads from it will return its default value.
  package mutating func clearCapabilities() {self._capabilities = nil}

  /// ROPES will return min(prefetch-k, client_requested_attestation_count) attestations in response.
  package var clientRequestedAttestationCount: UInt32 {
    get {return _clientRequestedAttestationCount ?? 0}
    set {_clientRequestedAttestationCount = newValue}
  }
  /// Returns true if `clientRequestedAttestationCount` has been explicitly set.
  package var hasClientRequestedAttestationCount: Bool {return self._clientRequestedAttestationCount != nil}
  /// Clears the value of `clientRequestedAttestationCount`. Subsequent reads from it will return its default value.
  package mutating func clearClientRequestedAttestationCount() {self._clientRequestedAttestationCount = nil}

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package init() {}

  fileprivate var _capabilities: Proto_Ropes_Common_Capabilities? = nil
  fileprivate var _clientRequestedAttestationCount: UInt32? = nil
}

package struct Proto_Ropes_HttpService_PrefetchAttestationsResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var attestation: [Proto_Ropes_Common_Attestation] = []

  package var rateLimitConfigurationList: Proto_Ropes_RateLimit_RateLimitConfigurationList {
    get {return _rateLimitConfigurationList ?? Proto_Ropes_RateLimit_RateLimitConfigurationList()}
    set {_rateLimitConfigurationList = newValue}
  }
  /// Returns true if `rateLimitConfigurationList` has been explicitly set.
  package var hasRateLimitConfigurationList: Bool {return self._rateLimitConfigurationList != nil}
  /// Clears the value of `rateLimitConfigurationList`. Subsequent reads from it will return its default value.
  package mutating func clearRateLimitConfigurationList() {self._rateLimitConfigurationList = nil}

  package var compressedAttestationList: Proto_Ropes_Common_CompressedAttestationList {
    get {return _compressedAttestationList ?? Proto_Ropes_Common_CompressedAttestationList()}
    set {_compressedAttestationList = newValue}
  }
  /// Returns true if `compressedAttestationList` has been explicitly set.
  package var hasCompressedAttestationList: Bool {return self._compressedAttestationList != nil}
  /// Clears the value of `compressedAttestationList`. Subsequent reads from it will return its default value.
  package mutating func clearCompressedAttestationList() {self._compressedAttestationList = nil}

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package init() {}

  fileprivate var _rateLimitConfigurationList: Proto_Ropes_RateLimit_RateLimitConfigurationList? = nil
  fileprivate var _compressedAttestationList: Proto_Ropes_Common_CompressedAttestationList? = nil
}

package struct Proto_Ropes_HttpService_ConfigRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var type: Proto_Ropes_HttpService_ConfigRequest.OneOf_Type? = nil

  package var rateLimitConfigRequest: Proto_Ropes_RateLimit_RateLimitConfigRequest {
    get {
      if case .rateLimitConfigRequest(let v)? = type {return v}
      return Proto_Ropes_RateLimit_RateLimitConfigRequest()
    }
    set {type = .rateLimitConfigRequest(newValue)}
  }

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package enum OneOf_Type: Equatable, Sendable {
    case rateLimitConfigRequest(Proto_Ropes_RateLimit_RateLimitConfigRequest)

  }

  package init() {}
}

package struct Proto_Ropes_HttpService_ConfigResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var type: Proto_Ropes_HttpService_ConfigResponse.OneOf_Type? = nil

  package var rateLimitConfigurationList: Proto_Ropes_RateLimit_RateLimitConfigurationList {
    get {
      if case .rateLimitConfigurationList(let v)? = type {return v}
      return Proto_Ropes_RateLimit_RateLimitConfigurationList()
    }
    set {type = .rateLimitConfigurationList(newValue)}
  }

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package enum OneOf_Type: Equatable, Sendable {
    case rateLimitConfigurationList(Proto_Ropes_RateLimit_RateLimitConfigurationList)

  }

  package init() {}
}

package struct Proto_Ropes_HttpService_AdminApiResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var supportedWorkloads: [Proto_Ropes_HttpService_AdminApiResponse.Workload] = []

  package var publicApiEndpoints: [Proto_Ropes_HttpService_AdminApiResponse.ApiEndpoint] = []

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  /// A collection of workloads with the same workload_type.
  package struct Workload: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// e.g., TIE, CMP, MOCK, etc.
    package var workloadType: String = String()

    package var mandatoryKeys: [String] = []

    package var routingParameters: Proto_Ropes_HttpService_AdminApiResponse.Workload.Parameters {
      get {return _routingParameters ?? Proto_Ropes_HttpService_AdminApiResponse.Workload.Parameters()}
      set {_routingParameters = newValue}
    }
    /// Returns true if `routingParameters` has been explicitly set.
    package var hasRoutingParameters: Bool {return self._routingParameters != nil}
    /// Clears the value of `routingParameters`. Subsequent reads from it will return its default value.
    package mutating func clearRoutingParameters() {self._routingParameters = nil}

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    /// Routing parameters
    package struct Parameters: Sendable {
      // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      /// An example of TIE workload: {"model": "A", "adapter": "B"}
      package var params: Dictionary<String,String> = [:]

      package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

      package init() {}
    }

    package init() {}

    fileprivate var _routingParameters: Proto_Ropes_HttpService_AdminApiResponse.Workload.Parameters? = nil
  }

  package struct ApiEndpoint: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// For example: "/invoke", "/prefetch"
    package var url: String = String()

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  package init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "com.apple.ropes.service.http.v1"

extension Proto_Ropes_HttpService_InvokeRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".InvokeRequest"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "setup_request"),
    2: .standard(proto: "logging_metadata"),
    3: .same(proto: "terminate"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Proto_Ropes_HttpService_InvokeRequest.SetupRequest?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .setupRequest(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .setupRequest(v)
        }
      }()
      case 2: try {
        var v: Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .loggingMetadata(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .loggingMetadata(v)
        }
      }()
      case 3: try {
        var v: Proto_Ropes_HttpService_InvokeRequest.Terminate?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .terminate(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .terminate(v)
        }
      }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.type {
    case .setupRequest?: try {
      guard case .setupRequest(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .loggingMetadata?: try {
      guard case .loggingMetadata(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .terminate?: try {
      guard case .terminate(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeRequest, rhs: Proto_Ropes_HttpService_InvokeRequest) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeRequest.SetupRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeRequest.protoMessageName + ".SetupRequest"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "encrypted_request_ohttp_context"),
    2: .standard(proto: "attestation_mappings"),
    3: .same(proto: "capabilities"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt32Field(value: &self.encryptedRequestOhttpContext) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.attestationMappings) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._capabilities) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.encryptedRequestOhttpContext != 0 {
      try visitor.visitSingularUInt32Field(value: self.encryptedRequestOhttpContext, fieldNumber: 1)
    }
    if !self.attestationMappings.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.attestationMappings, fieldNumber: 2)
    }
    try { if let v = self._capabilities {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeRequest.SetupRequest, rhs: Proto_Ropes_HttpService_InvokeRequest.SetupRequest) -> Bool {
    if lhs.encryptedRequestOhttpContext != rhs.encryptedRequestOhttpContext {return false}
    if lhs.attestationMappings != rhs.attestationMappings {return false}
    if lhs._capabilities != rhs._capabilities {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeRequest.SetupRequest.AttestationMapping: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeRequest.SetupRequest.protoMessageName + ".AttestationMapping"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "node_identifier"),
    2: .standard(proto: "ohttp_context"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.nodeIdentifier) }()
      case 2: try { try decoder.decodeSingularUInt32Field(value: &self.ohttpContext) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.nodeIdentifier.isEmpty {
      try visitor.visitSingularStringField(value: self.nodeIdentifier, fieldNumber: 1)
    }
    if self.ohttpContext != 0 {
      try visitor.visitSingularUInt32Field(value: self.ohttpContext, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeRequest.SetupRequest.AttestationMapping, rhs: Proto_Ropes_HttpService_InvokeRequest.SetupRequest.AttestationMapping) -> Bool {
    if lhs.nodeIdentifier != rhs.nodeIdentifier {return false}
    if lhs.ohttpContext != rhs.ohttpContext {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeRequest.protoMessageName + ".LoggingMetadata"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "message"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.message) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.message.isEmpty {
      try visitor.visitSingularStringField(value: self.message, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata, rhs: Proto_Ropes_HttpService_InvokeRequest.LoggingMetadata) -> Bool {
    if lhs.message != rhs.message {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeRequest.Terminate: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeRequest.protoMessageName + ".Terminate"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "code"),
    2: .same(proto: "reason"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.code) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._reason) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.code != .undefined {
      try visitor.visitSingularEnumField(value: self.code, fieldNumber: 1)
    }
    try { if let v = self._reason {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeRequest.Terminate, rhs: Proto_Ropes_HttpService_InvokeRequest.Terminate) -> Bool {
    if lhs.code != rhs.code {return false}
    if lhs._reason != rhs._reason {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeRequest.Terminate.Code: InternalSwiftProtobuf._ProtoNameProviding {
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNDEFINED"),
    1: .same(proto: "CRYPTO_ERROR"),
    2: .same(proto: "APPLICATION_ERROR"),
  ]
}

extension Proto_Ropes_HttpService_InvokeResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".InvokeResponse"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "attestation_list"),
    8: .standard(proto: "compressed_attestation_list"),
    2: .standard(proto: "node_selected"),
    3: .standard(proto: "logging_metadata"),
    4: .standard(proto: "rate_limit_configuration_list"),
    5: .standard(proto: "expired_attestation_list"),
    7: .standard(proto: "no_further_attestations"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Proto_Ropes_Common_AttestationList?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .attestationList(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .attestationList(v)
        }
      }()
      case 2: try {
        var v: Proto_Ropes_HttpService_InvokeResponse.NodeSelected?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .nodeSelected(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .nodeSelected(v)
        }
      }()
      case 3: try {
        var v: Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .loggingMetadata(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .loggingMetadata(v)
        }
      }()
      case 4: try {
        var v: Proto_Ropes_RateLimit_RateLimitConfigurationList?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .rateLimitConfigurationList(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .rateLimitConfigurationList(v)
        }
      }()
      case 5: try {
        var v: Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .expiredAttestationList(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .expiredAttestationList(v)
        }
      }()
      case 7: try {
        var v: Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .noFurtherAttestations(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .noFurtherAttestations(v)
        }
      }()
      case 8: try {
        var v: Proto_Ropes_Common_CompressedAttestationList?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .compressedAttestationList(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .compressedAttestationList(v)
        }
      }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.type {
    case .attestationList?: try {
      guard case .attestationList(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .nodeSelected?: try {
      guard case .nodeSelected(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .loggingMetadata?: try {
      guard case .loggingMetadata(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .rateLimitConfigurationList?: try {
      guard case .rateLimitConfigurationList(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .expiredAttestationList?: try {
      guard case .expiredAttestationList(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .noFurtherAttestations?: try {
      guard case .noFurtherAttestations(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case .compressedAttestationList?: try {
      guard case .compressedAttestationList(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeResponse, rhs: Proto_Ropes_HttpService_InvokeResponse) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeResponse.NodeSelected: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeResponse.protoMessageName + ".NodeSelected"
  package static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeResponse.NodeSelected, rhs: Proto_Ropes_HttpService_InvokeResponse.NodeSelected) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeResponse.protoMessageName + ".LoggingMetadata"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "message"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.message) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.message.isEmpty {
      try visitor.visitSingularStringField(value: self.message, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata, rhs: Proto_Ropes_HttpService_InvokeResponse.LoggingMetadata) -> Bool {
    if lhs.message != rhs.message {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeResponse.protoMessageName + ".NoFurtherAttestations"
  package static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations, rhs: Proto_Ropes_HttpService_InvokeResponse.NoFurtherAttestations) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_InvokeResponse.protoMessageName + ".ExpiredAttestationList"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "node_identifier"),
    2: .standard(proto: "should_clear_cache"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.nodeIdentifier) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.shouldClearCache) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.nodeIdentifier.isEmpty {
      try visitor.visitRepeatedStringField(value: self.nodeIdentifier, fieldNumber: 1)
    }
    if self.shouldClearCache != false {
      try visitor.visitSingularBoolField(value: self.shouldClearCache, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList, rhs: Proto_Ropes_HttpService_InvokeResponse.ExpiredAttestationList) -> Bool {
    if lhs.nodeIdentifier != rhs.nodeIdentifier {return false}
    if lhs.shouldClearCache != rhs.shouldClearCache {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_PrefetchAttestationsRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".PrefetchAttestationsRequest"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "capabilities"),
    2: .standard(proto: "client_requested_attestation_count"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._capabilities) }()
      case 2: try { try decoder.decodeSingularUInt32Field(value: &self._clientRequestedAttestationCount) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._capabilities {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._clientRequestedAttestationCount {
      try visitor.visitSingularUInt32Field(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_PrefetchAttestationsRequest, rhs: Proto_Ropes_HttpService_PrefetchAttestationsRequest) -> Bool {
    if lhs._capabilities != rhs._capabilities {return false}
    if lhs._clientRequestedAttestationCount != rhs._clientRequestedAttestationCount {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_PrefetchAttestationsResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".PrefetchAttestationsResponse"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "attestation"),
    2: .standard(proto: "rate_limit_configuration_list"),
    3: .standard(proto: "compressed_attestation_list"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.attestation) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._rateLimitConfigurationList) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._compressedAttestationList) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.attestation.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.attestation, fieldNumber: 1)
    }
    try { if let v = self._rateLimitConfigurationList {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._compressedAttestationList {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_PrefetchAttestationsResponse, rhs: Proto_Ropes_HttpService_PrefetchAttestationsResponse) -> Bool {
    if lhs.attestation != rhs.attestation {return false}
    if lhs._rateLimitConfigurationList != rhs._rateLimitConfigurationList {return false}
    if lhs._compressedAttestationList != rhs._compressedAttestationList {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_ConfigRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".ConfigRequest"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "rate_limit_config_request"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Proto_Ropes_RateLimit_RateLimitConfigRequest?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .rateLimitConfigRequest(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .rateLimitConfigRequest(v)
        }
      }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if case .rateLimitConfigRequest(let v)? = self.type {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_ConfigRequest, rhs: Proto_Ropes_HttpService_ConfigRequest) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_ConfigResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".ConfigResponse"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "rate_limit_configuration_list"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Proto_Ropes_RateLimit_RateLimitConfigurationList?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .rateLimitConfigurationList(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .rateLimitConfigurationList(v)
        }
      }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if case .rateLimitConfigurationList(let v)? = self.type {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_ConfigResponse, rhs: Proto_Ropes_HttpService_ConfigResponse) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_AdminApiResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".AdminApiResponse"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "supported_workloads"),
    2: .standard(proto: "public_api_endpoints"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.supportedWorkloads) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.publicApiEndpoints) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.supportedWorkloads.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.supportedWorkloads, fieldNumber: 1)
    }
    if !self.publicApiEndpoints.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.publicApiEndpoints, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_AdminApiResponse, rhs: Proto_Ropes_HttpService_AdminApiResponse) -> Bool {
    if lhs.supportedWorkloads != rhs.supportedWorkloads {return false}
    if lhs.publicApiEndpoints != rhs.publicApiEndpoints {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_AdminApiResponse.Workload: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_AdminApiResponse.protoMessageName + ".Workload"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "workload_type"),
    2: .standard(proto: "mandatory_keys"),
    4: .standard(proto: "routing_parameters"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.workloadType) }()
      case 2: try { try decoder.decodeRepeatedStringField(value: &self.mandatoryKeys) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._routingParameters) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.workloadType.isEmpty {
      try visitor.visitSingularStringField(value: self.workloadType, fieldNumber: 1)
    }
    if !self.mandatoryKeys.isEmpty {
      try visitor.visitRepeatedStringField(value: self.mandatoryKeys, fieldNumber: 2)
    }
    try { if let v = self._routingParameters {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_AdminApiResponse.Workload, rhs: Proto_Ropes_HttpService_AdminApiResponse.Workload) -> Bool {
    if lhs.workloadType != rhs.workloadType {return false}
    if lhs.mandatoryKeys != rhs.mandatoryKeys {return false}
    if lhs._routingParameters != rhs._routingParameters {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_AdminApiResponse.Workload.Parameters: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_AdminApiResponse.Workload.protoMessageName + ".Parameters"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "params"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeMapField(fieldType: InternalSwiftProtobuf._ProtobufMap<InternalSwiftProtobuf.ProtobufString,InternalSwiftProtobuf.ProtobufString>.self, value: &self.params) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.params.isEmpty {
      try visitor.visitMapField(fieldType: InternalSwiftProtobuf._ProtobufMap<InternalSwiftProtobuf.ProtobufString,InternalSwiftProtobuf.ProtobufString>.self, value: self.params, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_AdminApiResponse.Workload.Parameters, rhs: Proto_Ropes_HttpService_AdminApiResponse.Workload.Parameters) -> Bool {
    if lhs.params != rhs.params {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Ropes_HttpService_AdminApiResponse.ApiEndpoint: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_Ropes_HttpService_AdminApiResponse.protoMessageName + ".ApiEndpoint"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "url"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.url) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.url.isEmpty {
      try visitor.visitSingularStringField(value: self.url, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_Ropes_HttpService_AdminApiResponse.ApiEndpoint, rhs: Proto_Ropes_HttpService_AdminApiResponse.ApiEndpoint) -> Bool {
    if lhs.url != rhs.url {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
