// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: PrivateCloudCompute.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

package struct Proto_PrivateCloudCompute_PrivateCloudComputeRequest: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var type: Proto_PrivateCloudCompute_PrivateCloudComputeRequest.OneOf_Type? = nil

  package var applicationPayload: Data {
    get {
      if case .applicationPayload(let v)? = type {return v}
      return Data()
    }
    set {type = .applicationPayload(newValue)}
  }

  /// Metadata not passed on to the application service but used by cb_jophelper
  package var authToken: Proto_PrivateCloudCompute_AuthToken {
    get {
      if case .authToken(let v)? = type {return v}
      return Proto_PrivateCloudCompute_AuthToken()
    }
    set {type = .authToken(newValue)}
  }

  package var finalMessage: Proto_PrivateCloudCompute_FinalMessage {
    get {
      if case .finalMessage(let v)? = type {return v}
      return Proto_PrivateCloudCompute_FinalMessage()
    }
    set {type = .finalMessage(newValue)}
  }

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package enum OneOf_Type: Equatable, @unchecked Sendable {
    case applicationPayload(Data)
    /// Metadata not passed on to the application service but used by cb_jophelper
    case authToken(Proto_PrivateCloudCompute_AuthToken)
    case finalMessage(Proto_PrivateCloudCompute_FinalMessage)

  }

  package init() {}
}

package struct Proto_PrivateCloudCompute_AuthToken: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Long-term token used for abuse prevention
  package var tokenGrantingToken: Data = Data()

  /// Used to verify that the one-time token is derived from the TGT
  package var ottSalt: Data = Data()

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package init() {}
}

/// Message that does not carry any payload that signifies that this is the final message.
/// This message is not forwarded to the cloud app.
package struct Proto_PrivateCloudCompute_FinalMessage: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package init() {}
}

package struct Proto_PrivateCloudCompute_PrivateCloudComputeResponse: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  package var type: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.OneOf_Type? = nil

  /// To be logged on the client and submitted together with input prompt
  /// if agreed to by client (see PostResponseActions).
  package var responseUuid: Data {
    get {
      if case .responseUuid(let v)? = type {return v}
      return Data()
    }
    set {type = .responseUuid(newValue)}
  }

  package var responsePayload: Data {
    get {
      if case .responsePayload(let v)? = type {return v}
      return Data()
    }
    set {type = .responsePayload(newValue)}
  }

  package var responseSummary: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary {
    get {
      if case .responseSummary(let v)? = type {return v}
      return Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary()
    }
    set {type = .responseSummary(newValue)}
  }

  package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  package enum OneOf_Type: Equatable, @unchecked Sendable {
    /// To be logged on the client and submitted together with input prompt
    /// if agreed to by client (see PostResponseActions).
    case responseUuid(Data)
    case responsePayload(Data)
    case responseSummary(Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary)

  }

  /// Since we use length-prefixed protobuf rather than gRPC we include a response
  /// status ourselves
  package enum ResponseStatus: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
    package typealias RawValue = Int
    case ok // = 0
    case unauthenticated // = 1
    case internalError // = 2
    case invalidRequest // = 3
    case UNRECOGNIZED(Int)

    package init() {
      self = .ok
    }

    package init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .ok
      case 1: self = .unauthenticated
      case 2: self = .internalError
      case 3: self = .invalidRequest
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    package var rawValue: Int {
      switch self {
      case .ok: return 0
      case .unauthenticated: return 1
      case .internalError: return 2
      case .invalidRequest: return 3
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    package static let allCases: [Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseStatus] = [
      .ok,
      .unauthenticated,
      .internalError,
      .invalidRequest,
    ]

  }

  package struct ResponseSummary: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Metadata not passed on to the client-side application but handled by
    /// privatecloudcomputed
    package var postResponseActions: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.PostResponseActions {
      get {return _postResponseActions ?? Proto_PrivateCloudCompute_PrivateCloudComputeResponse.PostResponseActions()}
      set {_postResponseActions = newValue}
    }
    /// Returns true if `postResponseActions` has been explicitly set.
    package var hasPostResponseActions: Bool {return self._postResponseActions != nil}
    /// Clears the value of `postResponseActions`. Subsequent reads from it will return its default value.
    package mutating func clearPostResponseActions() {self._postResponseActions = nil}

    package var responseStatus: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseStatus = .ok

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}

    fileprivate var _postResponseActions: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.PostResponseActions? = nil
  }

  package struct PostResponseActions: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Ask the client to submit diagnostic report
    package var requestDiagnostics: Bool = false

    package var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    package init() {}
  }

  package init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "com.apple.privatecloudcompute.api.v1"

extension Proto_PrivateCloudCompute_PrivateCloudComputeRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".PrivateCloudComputeRequest"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "application_payload"),
    3: .standard(proto: "auth_token"),
    4: .standard(proto: "final_message"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Data?
        try decoder.decodeSingularBytesField(value: &v)
        if let v = v {
          if self.type != nil {try decoder.handleConflictingOneOf()}
          self.type = .applicationPayload(v)
        }
      }()
      case 3: try {
        var v: Proto_PrivateCloudCompute_AuthToken?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .authToken(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .authToken(v)
        }
      }()
      case 4: try {
        var v: Proto_PrivateCloudCompute_FinalMessage?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .finalMessage(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .finalMessage(v)
        }
      }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.type {
    case .applicationPayload?: try {
      guard case .applicationPayload(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularBytesField(value: v, fieldNumber: 1)
    }()
    case .authToken?: try {
      guard case .authToken(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .finalMessage?: try {
      guard case .finalMessage(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_PrivateCloudCompute_PrivateCloudComputeRequest, rhs: Proto_PrivateCloudCompute_PrivateCloudComputeRequest) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_PrivateCloudCompute_AuthToken: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".AuthToken"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "token_granting_token"),
    2: .standard(proto: "ott_salt"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.tokenGrantingToken) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.ottSalt) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.tokenGrantingToken.isEmpty {
      try visitor.visitSingularBytesField(value: self.tokenGrantingToken, fieldNumber: 1)
    }
    if !self.ottSalt.isEmpty {
      try visitor.visitSingularBytesField(value: self.ottSalt, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_PrivateCloudCompute_AuthToken, rhs: Proto_PrivateCloudCompute_AuthToken) -> Bool {
    if lhs.tokenGrantingToken != rhs.tokenGrantingToken {return false}
    if lhs.ottSalt != rhs.ottSalt {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_PrivateCloudCompute_FinalMessage: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".FinalMessage"
  package static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_PrivateCloudCompute_FinalMessage, rhs: Proto_PrivateCloudCompute_FinalMessage) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_PrivateCloudCompute_PrivateCloudComputeResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = _protobuf_package + ".PrivateCloudComputeResponse"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "response_uuid"),
    2: .standard(proto: "response_payload"),
    3: .standard(proto: "response_summary"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Data?
        try decoder.decodeSingularBytesField(value: &v)
        if let v = v {
          if self.type != nil {try decoder.handleConflictingOneOf()}
          self.type = .responseUuid(v)
        }
      }()
      case 2: try {
        var v: Data?
        try decoder.decodeSingularBytesField(value: &v)
        if let v = v {
          if self.type != nil {try decoder.handleConflictingOneOf()}
          self.type = .responsePayload(v)
        }
      }()
      case 3: try {
        var v: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .responseSummary(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .responseSummary(v)
        }
      }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.type {
    case .responseUuid?: try {
      guard case .responseUuid(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularBytesField(value: v, fieldNumber: 1)
    }()
    case .responsePayload?: try {
      guard case .responsePayload(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularBytesField(value: v, fieldNumber: 2)
    }()
    case .responseSummary?: try {
      guard case .responseSummary(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_PrivateCloudCompute_PrivateCloudComputeResponse, rhs: Proto_PrivateCloudCompute_PrivateCloudComputeResponse) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseStatus: InternalSwiftProtobuf._ProtoNameProviding {
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "OK"),
    1: .same(proto: "UNAUTHENTICATED"),
    2: .same(proto: "INTERNAL_ERROR"),
    3: .same(proto: "INVALID_REQUEST"),
  ]
}

extension Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_PrivateCloudCompute_PrivateCloudComputeResponse.protoMessageName + ".ResponseSummary"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    2: .standard(proto: "post_response_actions"),
    3: .standard(proto: "response_status"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularMessageField(value: &self._postResponseActions) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.responseStatus) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._postResponseActions {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if self.responseStatus != .ok {
      try visitor.visitSingularEnumField(value: self.responseStatus, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary, rhs: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.ResponseSummary) -> Bool {
    if lhs._postResponseActions != rhs._postResponseActions {return false}
    if lhs.responseStatus != rhs.responseStatus {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_PrivateCloudCompute_PrivateCloudComputeResponse.PostResponseActions: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  package static let protoMessageName: String = Proto_PrivateCloudCompute_PrivateCloudComputeResponse.protoMessageName + ".PostResponseActions"
  package static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "request_diagnostics"),
  ]

  package mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.requestDiagnostics) }()
      default: break
      }
    }
  }

  package func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.requestDiagnostics != false {
      try visitor.visitSingularBoolField(value: self.requestDiagnostics, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  package static func ==(lhs: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.PostResponseActions, rhs: Proto_PrivateCloudCompute_PrivateCloudComputeResponse.PostResponseActions) -> Bool {
    if lhs.requestDiagnostics != rhs.requestDiagnostics {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
