// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: Cloudboard.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

///*
/// CloudBoard API

import Foundation
@_implementationOnly import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

struct Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var type: Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest.OneOf_Type? = nil

  var setup: Com_Apple_Cloudboard_Api_V1_Setup {
    get {
      if case .setup(let v)? = type {return v}
      return Com_Apple_Cloudboard_Api_V1_Setup()
    }
    set {type = .setup(newValue)}
  }

  var terminate: Com_Apple_Cloudboard_Api_V1_Terminate {
    get {
      if case .terminate(let v)? = type {return v}
      return Com_Apple_Cloudboard_Api_V1_Terminate()
    }
    set {type = .terminate(newValue)}
  }

  var requestChunk: Com_Apple_Cloudboard_Api_V1_Chunk {
    get {
      if case .requestChunk(let v)? = type {return v}
      return Com_Apple_Cloudboard_Api_V1_Chunk()
    }
    set {type = .requestChunk(newValue)}
  }

  var parameters: Com_Apple_Cloudboard_Api_V1_Parameters {
    get {
      if case .parameters(let v)? = type {return v}
      return Com_Apple_Cloudboard_Api_V1_Parameters()
    }
    set {type = .parameters(newValue)}
  }

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  enum OneOf_Type: Equatable, Sendable {
    case setup(Com_Apple_Cloudboard_Api_V1_Setup)
    case terminate(Com_Apple_Cloudboard_Api_V1_Terminate)
    case requestChunk(Com_Apple_Cloudboard_Api_V1_Chunk)
    case parameters(Com_Apple_Cloudboard_Api_V1_Parameters)

  }

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_Setup: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_Terminate: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var code: Com_Apple_Cloudboard_Api_V1_Terminate.Code = .undefined

  var reason: String {
    get {return _reason ?? String()}
    set {_reason = newValue}
  }
  /// Returns true if `reason` has been explicitly set.
  var hasReason: Bool {return self._reason != nil}
  /// Clears the value of `reason`. Subsequent reads from it will return its default value.
  mutating func clearReason() {self._reason = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  enum Code: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case undefined // = 0
    case clientFoundOtherNode // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .undefined
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .undefined
      case 1: self = .clientFoundOtherNode
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .undefined: return 0
      case .clientFoundOtherNode: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Com_Apple_Cloudboard_Api_V1_Terminate.Code] = [
      .undefined,
      .clientFoundOtherNode,
    ]

  }

  init() {}

  fileprivate var _reason: String? = nil
}

struct Com_Apple_Cloudboard_Api_V1_DecryptionKey: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var encryptedPayload: Data = Data()

  var keyID: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_Chunk: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var encryptedPayload: Data = Data()

  var isFinal: Bool = false

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_Parameters: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var workload: Com_Apple_Cloudboard_Api_V1_Workload {
    get {return _workload ?? Com_Apple_Cloudboard_Api_V1_Workload()}
    set {_workload = newValue}
  }
  /// Returns true if `workload` has been explicitly set.
  var hasWorkload: Bool {return self._workload != nil}
  /// Clears the value of `workload`. Subsequent reads from it will return its default value.
  mutating func clearWorkload() {self._workload = nil}

  var decryptionKey: Com_Apple_Cloudboard_Api_V1_DecryptionKey {
    get {return _decryptionKey ?? Com_Apple_Cloudboard_Api_V1_DecryptionKey()}
    set {_decryptionKey = newValue}
  }
  /// Returns true if `decryptionKey` has been explicitly set.
  var hasDecryptionKey: Bool {return self._decryptionKey != nil}
  /// Clears the value of `decryptionKey`. Subsequent reads from it will return its default value.
  mutating func clearDecryptionKey() {self._decryptionKey = nil}

  var requestID: String = String()

  var tenantInfo: Com_Apple_Cloudboard_Api_V1_TenantInfo {
    get {return _tenantInfo ?? Com_Apple_Cloudboard_Api_V1_TenantInfo()}
    set {_tenantInfo = newValue}
  }
  /// Returns true if `tenantInfo` has been explicitly set.
  var hasTenantInfo: Bool {return self._tenantInfo != nil}
  /// Clears the value of `tenantInfo`. Subsequent reads from it will return its default value.
  mutating func clearTenantInfo() {self._tenantInfo = nil}

  var oneTimeToken: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _workload: Com_Apple_Cloudboard_Api_V1_Workload? = nil
  fileprivate var _decryptionKey: Com_Apple_Cloudboard_Api_V1_DecryptionKey? = nil
  fileprivate var _tenantInfo: Com_Apple_Cloudboard_Api_V1_TenantInfo? = nil
}

struct Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var type: Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse.OneOf_Type? = nil

  var setupAck: Com_Apple_Cloudboard_Api_V1_SetupAck {
    get {
      if case .setupAck(let v)? = type {return v}
      return Com_Apple_Cloudboard_Api_V1_SetupAck()
    }
    set {type = .setupAck(newValue)}
  }

  var responseChunk: Com_Apple_Cloudboard_Api_V1_Chunk {
    get {
      if case .responseChunk(let v)? = type {return v}
      return Com_Apple_Cloudboard_Api_V1_Chunk()
    }
    set {type = .responseChunk(newValue)}
  }

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  enum OneOf_Type: Equatable, Sendable {
    case setupAck(Com_Apple_Cloudboard_Api_V1_SetupAck)
    case responseChunk(Com_Apple_Cloudboard_Api_V1_Chunk)

  }

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_SetupAck: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// When CloudBoard sets the field to true, ROPES sends Terminate message before cancelling the stream of invokeWorkload.
  var supportTerminate: Bool = false

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var attestation: Com_Apple_Cloudboard_Api_V1_Attestation {
    get {return _attestation ?? Com_Apple_Cloudboard_Api_V1_Attestation()}
    set {_attestation = newValue}
  }
  /// Returns true if `attestation` has been explicitly set.
  var hasAttestation: Bool {return self._attestation != nil}
  /// Clears the value of `attestation`. Subsequent reads from it will return its default value.
  mutating func clearAttestation() {self._attestation = nil}

  var unpublishedAttestation: [Com_Apple_Cloudboard_Api_V1_UnpublishedAttestation] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _attestation: Com_Apple_Cloudboard_Api_V1_Attestation? = nil
}

/// Represents an attestation/key to be published to clients
struct Com_Apple_Cloudboard_Api_V1_Attestation: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var attestationBundle: Data = Data()

  var nextRefreshTime: InternalSwiftProtobuf.Google_Protobuf_Timestamp {
    get {return _nextRefreshTime ?? InternalSwiftProtobuf.Google_Protobuf_Timestamp()}
    set {_nextRefreshTime = newValue}
  }
  /// Returns true if `nextRefreshTime` has been explicitly set.
  var hasNextRefreshTime: Bool {return self._nextRefreshTime != nil}
  /// Clears the value of `nextRefreshTime`. Subsequent reads from it will return its default value.
  mutating func clearNextRefreshTime() {self._nextRefreshTime = nil}

  var keyID: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _nextRefreshTime: InternalSwiftProtobuf.Google_Protobuf_Timestamp? = nil
}

/// Represents an attestation/key that is no longer published to ROPES but that is still accepted by the node
struct Com_Apple_Cloudboard_Api_V1_UnpublishedAttestation: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var keyID: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_LoadRequest: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_LoadResponse: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var maxBatchSize: UInt32 = 0

  var currentBatchSize: UInt32 = 0

  var optimalBatchSize: UInt32 = 0

  /// Unset if value has not changed since previous message
  var workload: Com_Apple_Cloudboard_Api_V1_Workload {
    get {return _workload ?? Com_Apple_Cloudboard_Api_V1_Workload()}
    set {_workload = newValue}
  }
  /// Returns true if `workload` has been explicitly set.
  var hasWorkload: Bool {return self._workload != nil}
  /// Clears the value of `workload`. Subsequent reads from it will return its default value.
  mutating func clearWorkload() {self._workload = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _workload: Com_Apple_Cloudboard_Api_V1_Workload? = nil
}

struct Com_Apple_Cloudboard_Api_V1_Workload: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var type: String = String()

  var param: [Com_Apple_Cloudboard_Api_V1_Workload.Parameter] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct Parameter: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var key: String = String()

    var value: [String] = []

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

struct Com_Apple_Cloudboard_Api_V1_TenantInfo: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var bundleID: String {
    get {return _bundleID ?? String()}
    set {_bundleID = newValue}
  }
  /// Returns true if `bundleID` has been explicitly set.
  var hasBundleID: Bool {return self._bundleID != nil}
  /// Clears the value of `bundleID`. Subsequent reads from it will return its default value.
  mutating func clearBundleID() {self._bundleID = nil}

  var bundleVersion: String {
    get {return _bundleVersion ?? String()}
    set {_bundleVersion = newValue}
  }
  /// Returns true if `bundleVersion` has been explicitly set.
  var hasBundleVersion: Bool {return self._bundleVersion != nil}
  /// Clears the value of `bundleVersion`. Subsequent reads from it will return its default value.
  mutating func clearBundleVersion() {self._bundleVersion = nil}

  var featureID: String {
    get {return _featureID ?? String()}
    set {_featureID = newValue}
  }
  /// Returns true if `featureID` has been explicitly set.
  var hasFeatureID: Bool {return self._featureID != nil}
  /// Clears the value of `featureID`. Subsequent reads from it will return its default value.
  mutating func clearFeatureID() {self._featureID = nil}

  var clientInfo: String {
    get {return _clientInfo ?? String()}
    set {_clientInfo = newValue}
  }
  /// Returns true if `clientInfo` has been explicitly set.
  var hasClientInfo: Bool {return self._clientInfo != nil}
  /// Clears the value of `clientInfo`. Subsequent reads from it will return its default value.
  mutating func clearClientInfo() {self._clientInfo = nil}

  var automatedDeviceGroup: String {
    get {return _automatedDeviceGroup ?? String()}
    set {_automatedDeviceGroup = newValue}
  }
  /// Returns true if `automatedDeviceGroup` has been explicitly set.
  var hasAutomatedDeviceGroup: Bool {return self._automatedDeviceGroup != nil}
  /// Clears the value of `automatedDeviceGroup`. Subsequent reads from it will return its default value.
  mutating func clearAutomatedDeviceGroup() {self._automatedDeviceGroup = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _bundleID: String? = nil
  fileprivate var _bundleVersion: String? = nil
  fileprivate var _featureID: String? = nil
  fileprivate var _clientInfo: String? = nil
  fileprivate var _automatedDeviceGroup: String? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "com.apple.cloudboard.api.v1"

extension Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".InvokeWorkloadRequest"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "setup"),
    2: .same(proto: "terminate"),
    3: .standard(proto: "request_chunk"),
    4: .same(proto: "parameters"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Com_Apple_Cloudboard_Api_V1_Setup?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .setup(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .setup(v)
        }
      }()
      case 2: try {
        var v: Com_Apple_Cloudboard_Api_V1_Terminate?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .terminate(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .terminate(v)
        }
      }()
      case 3: try {
        var v: Com_Apple_Cloudboard_Api_V1_Chunk?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .requestChunk(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .requestChunk(v)
        }
      }()
      case 4: try {
        var v: Com_Apple_Cloudboard_Api_V1_Parameters?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .parameters(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .parameters(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.type {
    case .setup?: try {
      guard case .setup(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .terminate?: try {
      guard case .terminate(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .requestChunk?: try {
      guard case .requestChunk(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .parameters?: try {
      guard case .parameters(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest, rhs: Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Setup: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Setup"
  static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Setup, rhs: Com_Apple_Cloudboard_Api_V1_Setup) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Terminate: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Terminate"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "code"),
    2: .same(proto: "reason"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.code) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._reason) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.code != .undefined {
      try visitor.visitSingularEnumField(value: self.code, fieldNumber: 1)
    }
    try { if let v = self._reason {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Terminate, rhs: Com_Apple_Cloudboard_Api_V1_Terminate) -> Bool {
    if lhs.code != rhs.code {return false}
    if lhs._reason != rhs._reason {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Terminate.Code: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "UNDEFINED"),
    1: .same(proto: "CLIENT_FOUND_OTHER_NODE"),
  ]
}

extension Com_Apple_Cloudboard_Api_V1_DecryptionKey: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".DecryptionKey"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "encrypted_payload"),
    3: .standard(proto: "key_id"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.encryptedPayload) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.keyID) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.encryptedPayload.isEmpty {
      try visitor.visitSingularBytesField(value: self.encryptedPayload, fieldNumber: 1)
    }
    if !self.keyID.isEmpty {
      try visitor.visitSingularBytesField(value: self.keyID, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_DecryptionKey, rhs: Com_Apple_Cloudboard_Api_V1_DecryptionKey) -> Bool {
    if lhs.encryptedPayload != rhs.encryptedPayload {return false}
    if lhs.keyID != rhs.keyID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Chunk: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Chunk"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "encrypted_payload"),
    2: .standard(proto: "is_final"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.encryptedPayload) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.isFinal) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.encryptedPayload.isEmpty {
      try visitor.visitSingularBytesField(value: self.encryptedPayload, fieldNumber: 1)
    }
    if self.isFinal != false {
      try visitor.visitSingularBoolField(value: self.isFinal, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Chunk, rhs: Com_Apple_Cloudboard_Api_V1_Chunk) -> Bool {
    if lhs.encryptedPayload != rhs.encryptedPayload {return false}
    if lhs.isFinal != rhs.isFinal {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Parameters: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Parameters"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "workload"),
    2: .standard(proto: "decryption_key"),
    3: .standard(proto: "request_id"),
    4: .standard(proto: "tenant_info"),
    5: .standard(proto: "one_time_token"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._workload) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._decryptionKey) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.requestID) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._tenantInfo) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.oneTimeToken) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._workload {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._decryptionKey {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.requestID.isEmpty {
      try visitor.visitSingularStringField(value: self.requestID, fieldNumber: 3)
    }
    try { if let v = self._tenantInfo {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    if !self.oneTimeToken.isEmpty {
      try visitor.visitSingularBytesField(value: self.oneTimeToken, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Parameters, rhs: Com_Apple_Cloudboard_Api_V1_Parameters) -> Bool {
    if lhs._workload != rhs._workload {return false}
    if lhs._decryptionKey != rhs._decryptionKey {return false}
    if lhs.requestID != rhs.requestID {return false}
    if lhs._tenantInfo != rhs._tenantInfo {return false}
    if lhs.oneTimeToken != rhs.oneTimeToken {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".InvokeWorkloadResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "setup_ack"),
    2: .standard(proto: "response_chunk"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Com_Apple_Cloudboard_Api_V1_SetupAck?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .setupAck(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .setupAck(v)
        }
      }()
      case 2: try {
        var v: Com_Apple_Cloudboard_Api_V1_Chunk?
        var hadOneofValue = false
        if let current = self.type {
          hadOneofValue = true
          if case .responseChunk(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.type = .responseChunk(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.type {
    case .setupAck?: try {
      guard case .setupAck(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .responseChunk?: try {
      guard case .responseChunk(let v)? = self.type else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse, rhs: Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_SetupAck: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SetupAck"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "support_terminate"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.supportTerminate) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.supportTerminate != false {
      try visitor.visitSingularBoolField(value: self.supportTerminate, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_SetupAck, rhs: Com_Apple_Cloudboard_Api_V1_SetupAck) -> Bool {
    if lhs.supportTerminate != rhs.supportTerminate {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FetchAttestationRequest"
  static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest, rhs: Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FetchAttestationResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "attestation"),
    2: .standard(proto: "unpublished_attestation"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._attestation) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.unpublishedAttestation) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._attestation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.unpublishedAttestation.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.unpublishedAttestation, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse, rhs: Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse) -> Bool {
    if lhs._attestation != rhs._attestation {return false}
    if lhs.unpublishedAttestation != rhs.unpublishedAttestation {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Attestation: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Attestation"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "attestation_bundle"),
    2: .standard(proto: "next_refresh_time"),
    3: .standard(proto: "key_id"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.attestationBundle) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._nextRefreshTime) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.keyID) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.attestationBundle.isEmpty {
      try visitor.visitSingularBytesField(value: self.attestationBundle, fieldNumber: 1)
    }
    try { if let v = self._nextRefreshTime {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.keyID.isEmpty {
      try visitor.visitSingularBytesField(value: self.keyID, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Attestation, rhs: Com_Apple_Cloudboard_Api_V1_Attestation) -> Bool {
    if lhs.attestationBundle != rhs.attestationBundle {return false}
    if lhs._nextRefreshTime != rhs._nextRefreshTime {return false}
    if lhs.keyID != rhs.keyID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_UnpublishedAttestation: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UnpublishedAttestation"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "key_id"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.keyID) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.keyID.isEmpty {
      try visitor.visitSingularBytesField(value: self.keyID, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_UnpublishedAttestation, rhs: Com_Apple_Cloudboard_Api_V1_UnpublishedAttestation) -> Bool {
    if lhs.keyID != rhs.keyID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_LoadRequest: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoadRequest"
  static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_LoadRequest, rhs: Com_Apple_Cloudboard_Api_V1_LoadRequest) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_LoadResponse: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoadResponse"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "max_batch_size"),
    2: .standard(proto: "current_batch_size"),
    3: .standard(proto: "optimal_batch_size"),
    4: .same(proto: "workload"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt32Field(value: &self.maxBatchSize) }()
      case 2: try { try decoder.decodeSingularUInt32Field(value: &self.currentBatchSize) }()
      case 3: try { try decoder.decodeSingularUInt32Field(value: &self.optimalBatchSize) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._workload) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.maxBatchSize != 0 {
      try visitor.visitSingularUInt32Field(value: self.maxBatchSize, fieldNumber: 1)
    }
    if self.currentBatchSize != 0 {
      try visitor.visitSingularUInt32Field(value: self.currentBatchSize, fieldNumber: 2)
    }
    if self.optimalBatchSize != 0 {
      try visitor.visitSingularUInt32Field(value: self.optimalBatchSize, fieldNumber: 3)
    }
    try { if let v = self._workload {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_LoadResponse, rhs: Com_Apple_Cloudboard_Api_V1_LoadResponse) -> Bool {
    if lhs.maxBatchSize != rhs.maxBatchSize {return false}
    if lhs.currentBatchSize != rhs.currentBatchSize {return false}
    if lhs.optimalBatchSize != rhs.optimalBatchSize {return false}
    if lhs._workload != rhs._workload {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Workload: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Workload"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    3: .same(proto: "param"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.type) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.param) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.type.isEmpty {
      try visitor.visitSingularStringField(value: self.type, fieldNumber: 1)
    }
    if !self.param.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.param, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Workload, rhs: Com_Apple_Cloudboard_Api_V1_Workload) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.param != rhs.param {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_Workload.Parameter: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Com_Apple_Cloudboard_Api_V1_Workload.protoMessageName + ".Parameter"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "key"),
    2: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.key) }()
      case 2: try { try decoder.decodeRepeatedStringField(value: &self.value) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.key.isEmpty {
      try visitor.visitSingularStringField(value: self.key, fieldNumber: 1)
    }
    if !self.value.isEmpty {
      try visitor.visitRepeatedStringField(value: self.value, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_Workload.Parameter, rhs: Com_Apple_Cloudboard_Api_V1_Workload.Parameter) -> Bool {
    if lhs.key != rhs.key {return false}
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Cloudboard_Api_V1_TenantInfo: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TenantInfo"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "bundle_id"),
    2: .standard(proto: "bundle_version"),
    3: .standard(proto: "feature_id"),
    4: .standard(proto: "client_info"),
    5: .standard(proto: "automated_device_group"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._bundleID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._bundleVersion) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._featureID) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._clientInfo) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self._automatedDeviceGroup) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._bundleID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._bundleVersion {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._featureID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._clientInfo {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._automatedDeviceGroup {
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Com_Apple_Cloudboard_Api_V1_TenantInfo, rhs: Com_Apple_Cloudboard_Api_V1_TenantInfo) -> Bool {
    if lhs._bundleID != rhs._bundleID {return false}
    if lhs._bundleVersion != rhs._bundleVersion {return false}
    if lhs._featureID != rhs._featureID {return false}
    if lhs._clientInfo != rhs._clientInfo {return false}
    if lhs._automatedDeviceGroup != rhs._automatedDeviceGroup {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
