// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

//
// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the protocol buffer compiler.
// Source: keyrotationservice/keyrotationapi.proto
//
import InternalGRPC
import InternalSwiftProtobuf
import NIO
import NIOConcurrencyHelpers


///
///Fetch Delivery is intended for serial Request & Response flow. Service Client using Unary Delivery is expected to refresh
///its Request every 15 minutes
///
/// Usage: instantiate `AssetDeliveryClient`, then call methods of this protocol to make API calls.
internal protocol AssetDeliveryClientProtocol: GRPCClient {
  var serviceName: String { get }
  var interceptors: AssetDeliveryClientInterceptorFactoryProtocol? { get }

  func fetchDelivery(
    _ request: AssetRequest,
    callOptions: CallOptions?
  ) -> UnaryCall<AssetRequest, AssetResponse>
}

extension AssetDeliveryClientProtocol {
  internal var serviceName: String {
    return "AssetDelivery"
  }

  /// Unary call to FetchDelivery
  ///
  /// - Parameters:
  ///   - request: Request to send to FetchDelivery.
  ///   - callOptions: Call options.
  /// - Returns: A `UnaryCall` with futures for the metadata, status and response.
  internal func fetchDelivery(
    _ request: AssetRequest,
    callOptions: CallOptions? = nil
  ) -> UnaryCall<AssetRequest, AssetResponse> {
    return self.makeUnaryCall(
      path: AssetDeliveryClientMetadata.Methods.fetchDelivery.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeFetchDeliveryInterceptors() ?? []
    )
  }
}

@available(*, deprecated)
extension AssetDeliveryClient: @unchecked Sendable {}

@available(*, deprecated, renamed: "AssetDeliveryNIOClient")
internal final class AssetDeliveryClient: AssetDeliveryClientProtocol {
  private let lock = Lock()
  private var _defaultCallOptions: CallOptions
  private var _interceptors: AssetDeliveryClientInterceptorFactoryProtocol?
  internal let channel: GRPCChannel
  internal var defaultCallOptions: CallOptions {
    get { self.lock.withLock { return self._defaultCallOptions } }
    set { self.lock.withLockVoid { self._defaultCallOptions = newValue } }
  }
  internal var interceptors: AssetDeliveryClientInterceptorFactoryProtocol? {
    get { self.lock.withLock { return self._interceptors } }
    set { self.lock.withLockVoid { self._interceptors = newValue } }
  }

  /// Creates a client for the AssetDelivery service.
  ///
  /// - Parameters:
  ///   - channel: `GRPCChannel` to the service host.
  ///   - defaultCallOptions: Options to use for each service call if the user doesn't provide them.
  ///   - interceptors: A factory providing interceptors for each RPC.
  internal init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: AssetDeliveryClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self._defaultCallOptions = defaultCallOptions
    self._interceptors = interceptors
  }
}

internal struct AssetDeliveryNIOClient: AssetDeliveryClientProtocol {
  internal var channel: GRPCChannel
  internal var defaultCallOptions: CallOptions
  internal var interceptors: AssetDeliveryClientInterceptorFactoryProtocol?

  /// Creates a client for the AssetDelivery service.
  ///
  /// - Parameters:
  ///   - channel: `GRPCChannel` to the service host.
  ///   - defaultCallOptions: Options to use for each service call if the user doesn't provide them.
  ///   - interceptors: A factory providing interceptors for each RPC.
  internal init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: AssetDeliveryClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self.defaultCallOptions = defaultCallOptions
    self.interceptors = interceptors
  }
}

///
///Fetch Delivery is intended for serial Request & Response flow. Service Client using Unary Delivery is expected to refresh
///its Request every 15 minutes
@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
internal protocol AssetDeliveryAsyncClientProtocol: GRPCClient {
  static var serviceDescriptor: GRPCServiceDescriptor { get }
  var interceptors: AssetDeliveryClientInterceptorFactoryProtocol? { get }

  func makeFetchDeliveryCall(
    _ request: AssetRequest,
    callOptions: CallOptions?
  ) -> GRPCAsyncUnaryCall<AssetRequest, AssetResponse>
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension AssetDeliveryAsyncClientProtocol {
  internal static var serviceDescriptor: GRPCServiceDescriptor {
    return AssetDeliveryClientMetadata.serviceDescriptor
  }

  internal var interceptors: AssetDeliveryClientInterceptorFactoryProtocol? {
    return nil
  }

  internal func makeFetchDeliveryCall(
    _ request: AssetRequest,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncUnaryCall<AssetRequest, AssetResponse> {
    return self.makeAsyncUnaryCall(
      path: AssetDeliveryClientMetadata.Methods.fetchDelivery.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeFetchDeliveryInterceptors() ?? []
    )
  }
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension AssetDeliveryAsyncClientProtocol {
  internal func fetchDelivery(
    _ request: AssetRequest,
    callOptions: CallOptions? = nil
  ) async throws -> AssetResponse {
    return try await self.performAsyncUnaryCall(
      path: AssetDeliveryClientMetadata.Methods.fetchDelivery.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeFetchDeliveryInterceptors() ?? []
    )
  }
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
internal struct AssetDeliveryAsyncClient: AssetDeliveryAsyncClientProtocol {
  internal var channel: GRPCChannel
  internal var defaultCallOptions: CallOptions
  internal var interceptors: AssetDeliveryClientInterceptorFactoryProtocol?

  internal init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: AssetDeliveryClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self.defaultCallOptions = defaultCallOptions
    self.interceptors = interceptors
  }
}

internal protocol AssetDeliveryClientInterceptorFactoryProtocol: Sendable {

  /// - Returns: Interceptors to use when invoking 'fetchDelivery'.
  func makeFetchDeliveryInterceptors() -> [ClientInterceptor<AssetRequest, AssetResponse>]
}

internal enum AssetDeliveryClientMetadata {
  internal static let serviceDescriptor = GRPCServiceDescriptor(
    name: "AssetDelivery",
    fullName: "AssetDelivery",
    methods: [
      AssetDeliveryClientMetadata.Methods.fetchDelivery,
    ]
  )

  internal enum Methods {
    internal static let fetchDelivery = GRPCMethodDescriptor(
      name: "FetchDelivery",
      path: "/AssetDelivery/FetchDelivery",
      type: GRPCCallType.unary
    )
  }
}

