// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

//
// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the protocol buffer compiler.
// Source: Cloudboard.proto
//
import InternalGRPC
import InternalSwiftProtobuf
import NIO
import NIOConcurrencyHelpers


/// To build a server, implement a class that conforms to this protocol.
internal protocol Com_Apple_Cloudboard_Api_V1_CloudBoardProvider: CallHandlerProvider {
  var interceptors: Com_Apple_Cloudboard_Api_V1_CloudBoardServerInterceptorFactoryProtocol? { get }

  func invokeWorkload(context: StreamingResponseCallContext<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse>) -> EventLoopFuture<(StreamEvent<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest>) -> Void>

  func fetchAttestation(request: Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest, context: StatusOnlyCallContext) -> EventLoopFuture<Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse>

  func watchLoadLevel(request: Com_Apple_Cloudboard_Api_V1_LoadRequest, context: StreamingResponseCallContext<Com_Apple_Cloudboard_Api_V1_LoadResponse>) -> EventLoopFuture<GRPCStatus>
}

extension Com_Apple_Cloudboard_Api_V1_CloudBoardProvider {
  internal var serviceName: Substring {
    return Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata.serviceDescriptor.fullName[...]
  }

  /// Determines, calls and returns the appropriate request handler, depending on the request's method.
  /// Returns nil for methods not handled by this service.
  internal func handle(
    method name: Substring,
    context: CallHandlerContext
  ) -> GRPCServerHandlerProtocol? {
    switch name {
    case "InvokeWorkload":
      return BidirectionalStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse>(),
        interceptors: self.interceptors?.makeInvokeWorkloadInterceptors() ?? [],
        observerFactory: self.invokeWorkload(context:)
      )

    case "FetchAttestation":
      return UnaryServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse>(),
        interceptors: self.interceptors?.makeFetchAttestationInterceptors() ?? [],
        userFunction: self.fetchAttestation(request:context:)
      )

    case "WatchLoadLevel":
      return ServerStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Cloudboard_Api_V1_LoadRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Cloudboard_Api_V1_LoadResponse>(),
        interceptors: self.interceptors?.makeWatchLoadLevelInterceptors() ?? [],
        userFunction: self.watchLoadLevel(request:context:)
      )

    default:
      return nil
    }
  }
}

/// To implement a server, implement an object which conforms to this protocol.
@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
internal protocol Com_Apple_Cloudboard_Api_V1_CloudBoardAsyncProvider: CallHandlerProvider, Sendable {
  static var serviceDescriptor: GRPCServiceDescriptor { get }
  var interceptors: Com_Apple_Cloudboard_Api_V1_CloudBoardServerInterceptorFactoryProtocol? { get }

  func invokeWorkload(
    requestStream: GRPCAsyncRequestStream<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest>,
    responseStream: GRPCAsyncResponseStreamWriter<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse>,
    context: GRPCAsyncServerCallContext
  ) async throws

  func fetchAttestation(
    request: Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest,
    context: GRPCAsyncServerCallContext
  ) async throws -> Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse

  func watchLoadLevel(
    request: Com_Apple_Cloudboard_Api_V1_LoadRequest,
    responseStream: GRPCAsyncResponseStreamWriter<Com_Apple_Cloudboard_Api_V1_LoadResponse>,
    context: GRPCAsyncServerCallContext
  ) async throws
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Com_Apple_Cloudboard_Api_V1_CloudBoardAsyncProvider {
  internal static var serviceDescriptor: GRPCServiceDescriptor {
    return Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata.serviceDescriptor
  }

  internal var serviceName: Substring {
    return Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata.serviceDescriptor.fullName[...]
  }

  internal var interceptors: Com_Apple_Cloudboard_Api_V1_CloudBoardServerInterceptorFactoryProtocol? {
    return nil
  }

  internal func handle(
    method name: Substring,
    context: CallHandlerContext
  ) -> GRPCServerHandlerProtocol? {
    switch name {
    case "InvokeWorkload":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse>(),
        interceptors: self.interceptors?.makeInvokeWorkloadInterceptors() ?? [],
        wrapping: { try await self.invokeWorkload(requestStream: $0, responseStream: $1, context: $2) }
      )

    case "FetchAttestation":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse>(),
        interceptors: self.interceptors?.makeFetchAttestationInterceptors() ?? [],
        wrapping: { try await self.fetchAttestation(request: $0, context: $1) }
      )

    case "WatchLoadLevel":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Com_Apple_Cloudboard_Api_V1_LoadRequest>(),
        responseSerializer: ProtobufSerializer<Com_Apple_Cloudboard_Api_V1_LoadResponse>(),
        interceptors: self.interceptors?.makeWatchLoadLevelInterceptors() ?? [],
        wrapping: { try await self.watchLoadLevel(request: $0, responseStream: $1, context: $2) }
      )

    default:
      return nil
    }
  }
}

internal protocol Com_Apple_Cloudboard_Api_V1_CloudBoardServerInterceptorFactoryProtocol: Sendable {

  /// - Returns: Interceptors to use when handling 'invokeWorkload'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeInvokeWorkloadInterceptors() -> [ServerInterceptor<Com_Apple_Cloudboard_Api_V1_InvokeWorkloadRequest, Com_Apple_Cloudboard_Api_V1_InvokeWorkloadResponse>]

  /// - Returns: Interceptors to use when handling 'fetchAttestation'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeFetchAttestationInterceptors() -> [ServerInterceptor<Com_Apple_Cloudboard_Api_V1_FetchAttestationRequest, Com_Apple_Cloudboard_Api_V1_FetchAttestationResponse>]

  /// - Returns: Interceptors to use when handling 'watchLoadLevel'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeWatchLoadLevelInterceptors() -> [ServerInterceptor<Com_Apple_Cloudboard_Api_V1_LoadRequest, Com_Apple_Cloudboard_Api_V1_LoadResponse>]
}

internal enum Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata {
  internal static let serviceDescriptor = GRPCServiceDescriptor(
    name: "CloudBoard",
    fullName: "com.apple.cloudboard.api.v1.CloudBoard",
    methods: [
      Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata.Methods.invokeWorkload,
      Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata.Methods.fetchAttestation,
      Com_Apple_Cloudboard_Api_V1_CloudBoardServerMetadata.Methods.watchLoadLevel,
    ]
  )

  internal enum Methods {
    internal static let invokeWorkload = GRPCMethodDescriptor(
      name: "InvokeWorkload",
      path: "/com.apple.cloudboard.api.v1.CloudBoard/InvokeWorkload",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let fetchAttestation = GRPCMethodDescriptor(
      name: "FetchAttestation",
      path: "/com.apple.cloudboard.api.v1.CloudBoard/FetchAttestation",
      type: GRPCCallType.unary
    )

    internal static let watchLoadLevel = GRPCMethodDescriptor(
      name: "WatchLoadLevel",
      path: "/com.apple.cloudboard.api.v1.CloudBoard/WatchLoadLevel",
      type: GRPCCallType.serverStreaming
    )
  }
}
