// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
package protocol APIProtocol: Sendable {
    /// Receive a heartbeat from a node in the fleet.
    ///
    /// Receive a heartbeat
    ///
    /// - Remark: HTTP `POST /heartbeats/sources/{source}/assets/{assetType}/{assetId}`.
    /// - Remark: Generated from `#/paths//heartbeats/sources/{source}/assets/{assetType}/{assetId}/post(heartbeat)`.
    func heartbeat(_ input: Operations.heartbeat.Input) async throws -> Operations.heartbeat.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Receive a heartbeat from a node in the fleet.
    ///
    /// Receive a heartbeat
    ///
    /// - Remark: HTTP `POST /heartbeats/sources/{source}/assets/{assetType}/{assetId}`.
    /// - Remark: Generated from `#/paths//heartbeats/sources/{source}/assets/{assetType}/{assetId}/post(heartbeat)`.
    package func heartbeat(
        path: Operations.heartbeat.Input.Path,
        headers: Operations.heartbeat.Input.Headers = .init(),
        body: Operations.heartbeat.Input.Body
    ) async throws -> Operations.heartbeat.Output {
        try await heartbeat(Operations.heartbeat.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
package enum Servers {
    /// Generated server url
    package static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "/api/v1",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
package enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    package enum Schemas {
        /// - Remark: Generated from `#/components/schemas/Source`.
        @frozen package enum Source: String, Codable, Hashable, Sendable {
            case CLOUDBOARDD = "CLOUDBOARDD"
        }
        /// - Remark: Generated from `#/components/schemas/AssetType`.
        @frozen package enum AssetType: String, Codable, Hashable, Sendable {
            case NODE = "NODE"
        }
        /// - Remark: Generated from `#/components/schemas/FieldError`.
        package struct FieldError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/FieldError/field`.
            package var field: Swift.String?
            /// - Remark: Generated from `#/components/schemas/FieldError/code`.
            package var code: Swift.String?
            /// - Remark: Generated from `#/components/schemas/FieldError/message`.
            package var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/FieldError/value`.
            package var value: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `FieldError`.
            ///
            /// - Parameters:
            ///   - field:
            ///   - code:
            ///   - message:
            ///   - value:
            package init(
                field: Swift.String? = nil,
                code: Swift.String? = nil,
                message: Swift.String? = nil,
                value: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.field = field
                self.code = code
                self.message = message
                self.value = value
            }
            package enum CodingKeys: String, CodingKey {
                case field
                case code
                case message
                case value
            }
        }
        /// - Remark: Generated from `#/components/schemas/ResponseError`.
        package struct ResponseError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ResponseError/timestamp`.
            package var timestamp: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/ResponseError/path`.
            package var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/ResponseError/status`.
            package var status: Swift.Int32
            /// - Remark: Generated from `#/components/schemas/ResponseError/error`.
            package var error: Swift.String
            /// - Remark: Generated from `#/components/schemas/ResponseError/message`.
            package var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/ResponseError/requestId`.
            package var requestId: Swift.String
            /// - Remark: Generated from `#/components/schemas/ResponseError/version`.
            package var version: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ResponseError/errors`.
            package var errors: [Components.Schemas.FieldError]?
            /// Creates a new `ResponseError`.
            ///
            /// - Parameters:
            ///   - timestamp:
            ///   - path:
            ///   - status:
            ///   - error:
            ///   - message:
            ///   - requestId:
            ///   - version:
            ///   - errors:
            package init(
                timestamp: Foundation.Date,
                path: Swift.String,
                status: Swift.Int32,
                error: Swift.String,
                message: Swift.String,
                requestId: Swift.String,
                version: Swift.String? = nil,
                errors: [Components.Schemas.FieldError]? = nil
            ) {
                self.timestamp = timestamp
                self.path = path
                self.status = status
                self.error = error
                self.message = message
                self.requestId = requestId
                self.version = version
                self.errors = errors
            }
            package enum CodingKeys: String, CodingKey {
                case timestamp
                case path
                case status
                case error
                case message
                case requestId
                case version
                case errors
            }
        }
        /// - Remark: Generated from `#/components/schemas/HeartbeatPayload`.
        package struct HeartbeatPayload: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/HeartbeatPayload/timestamp`.
            package var timestamp: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/HeartbeatPayload/state`.
            package var state: Components.Schemas.State
            /// - Remark: Generated from `#/components/schemas/HeartbeatPayload/operationalStatus`.
            package var operationalStatus: Components.Schemas.NodeOperationalStatus?
            /// - Remark: Generated from `#/components/schemas/HeartbeatPayload/metadata`.
            package var metadata: Components.Schemas.PayloadMetadata
            /// Creates a new `HeartbeatPayload`.
            ///
            /// - Parameters:
            ///   - timestamp:
            ///   - state:
            ///   - operationalStatus:
            ///   - metadata:
            package init(
                timestamp: Foundation.Date,
                state: Components.Schemas.State,
                operationalStatus: Components.Schemas.NodeOperationalStatus? = nil,
                metadata: Components.Schemas.PayloadMetadata
            ) {
                self.timestamp = timestamp
                self.state = state
                self.operationalStatus = operationalStatus
                self.metadata = metadata
            }
            package enum CodingKeys: String, CodingKey {
                case timestamp
                case state
                case operationalStatus
                case metadata
            }
        }
        /// - Remark: Generated from `#/components/schemas/NodeOperationalStatus`.
        @frozen package enum NodeOperationalStatus: String, Codable, Hashable, Sendable {
            case UNINITIALIZED = "UNINITIALIZED"
            case INITIALIZING = "INITIALIZING"
            case WAITING_FOR_FIRST_ATTESTATION_FETCH = "WAITING_FOR_FIRST_ATTESTATION_FETCH"
            case WAITING_FOR_FIRST_KEY_FETCH = "WAITING_FOR_FIRST_KEY_FETCH"
            case WAITING_FOR_FIRST_HOT_PROPERTY_UPDATE = "WAITING_FOR_FIRST_HOT_PROPERTY_UPDATE"
            case WAITING_FOR_WORKLOAD_REGISTRATION = "WAITING_FOR_WORKLOAD_REGISTRATION"
            case COMPONENTS_FAILED_TO_RUN = "COMPONENTS_FAILED_TO_RUN"
            case SERVICE_DISCOVERY_UPDATE_SUCCESS = "SERVICE_DISCOVERY_UPDATE_SUCCESS"
            case SERVICE_DISCOVERY_UPDATE_FAILURE = "SERVICE_DISCOVERY_UPDATE_FAILURE"
            case SERVICE_DISCOVERY_PUBLISHER_DRAINING = "SERVICE_DISCOVERY_PUBLISHER_DRAINING"
            case DAEMON_DRAINED = "DAEMON_DRAINED"
            case DAEMON_EXITING_ON_ERROR = "DAEMON_EXITING_ON_ERROR"
        }
        /// - Remark: Generated from `#/components/schemas/PayloadMetadata`.
        package struct PayloadMetadata: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/cloudOSReleaseType`.
            package var cloudOSReleaseType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/cloudOSBuilderVersion`.
            package var cloudOSBuilderVersion: Swift.String?
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/serverOSReleaseType`.
            package var serverOSReleaseType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/serverOSBuildVersion`.
            package var serverOSBuildVersion: Swift.String?
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/configVersion`.
            package var configVersion: Swift.String?
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/workloadEnabled`.
            package var workloadEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/PayloadMetadata/cryptexes`.
            package var cryptexes: [Swift.String]?
            /// Creates a new `PayloadMetadata`.
            ///
            /// - Parameters:
            ///   - cloudOSReleaseType:
            ///   - cloudOSBuilderVersion:
            ///   - serverOSReleaseType:
            ///   - serverOSBuildVersion:
            ///   - configVersion:
            ///   - workloadEnabled:
            ///   - cryptexes:
            package init(
                cloudOSReleaseType: Swift.String? = nil,
                cloudOSBuilderVersion: Swift.String? = nil,
                serverOSReleaseType: Swift.String? = nil,
                serverOSBuildVersion: Swift.String? = nil,
                configVersion: Swift.String? = nil,
                workloadEnabled: Swift.Bool? = nil,
                cryptexes: [Swift.String]? = nil
            ) {
                self.cloudOSReleaseType = cloudOSReleaseType
                self.cloudOSBuilderVersion = cloudOSBuilderVersion
                self.serverOSReleaseType = serverOSReleaseType
                self.serverOSBuildVersion = serverOSBuildVersion
                self.configVersion = configVersion
                self.workloadEnabled = workloadEnabled
                self.cryptexes = cryptexes
            }
            package enum CodingKeys: String, CodingKey {
                case cloudOSReleaseType
                case cloudOSBuilderVersion
                case serverOSReleaseType
                case serverOSBuildVersion
                case configVersion
                case workloadEnabled
                case cryptexes
            }
        }
        /// - Remark: Generated from `#/components/schemas/State`.
        @frozen package enum State: String, Codable, Hashable, Sendable {
            case UP = "UP"
            case DOWN = "DOWN"
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    package enum Parameters {}
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    package enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    package enum Responses {}
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    package enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
package enum Operations {
    /// Receive a heartbeat from a node in the fleet.
    ///
    /// Receive a heartbeat
    ///
    /// - Remark: HTTP `POST /heartbeats/sources/{source}/assets/{assetType}/{assetId}`.
    /// - Remark: Generated from `#/paths//heartbeats/sources/{source}/assets/{assetType}/{assetId}/post(heartbeat)`.
    package enum heartbeat {
        package static let id: Swift.String = "heartbeat"
        package struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/path`.
            package struct Path: Sendable, Hashable {
                /// Source system
                ///
                /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/path/source`.
                package var source: Components.Schemas.Source
                /// Asset type
                ///
                /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/path/assetType`.
                package var assetType: Components.Schemas.AssetType
                /// Asset ID, for example a hostname or another unique identifier.
                ///
                /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/path/assetId`.
                package var assetId: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - source: Source system
                ///   - assetType: Asset type
                ///   - assetId: Asset ID, for example a hostname or another unique identifier.
                package init(
                    source: Components.Schemas.Source,
                    assetType: Components.Schemas.AssetType,
                    assetId: Swift.String
                ) {
                    self.source = source
                    self.assetType = assetType
                    self.assetId = assetId
                }
            }
            package var path: Operations.heartbeat.Input.Path
            /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/header`.
            package struct Headers: Sendable, Hashable {
                package var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.heartbeat.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                package init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.heartbeat.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            package var headers: Operations.heartbeat.Input.Headers
            /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/requestBody`.
            @frozen package enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.HeartbeatPayload)
            }
            package var body: Operations.heartbeat.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            package init(
                path: Operations.heartbeat.Input.Path,
                headers: Operations.heartbeat.Input.Headers = .init(),
                body: Operations.heartbeat.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen package enum Output: Sendable, Hashable {
            package struct Accepted: Sendable, Hashable {
                /// Creates a new `Accepted`.
                package init() {}
            }
            /// Indicates that the heartbeat was received.
            ///
            /// - Remark: Generated from `#/paths//heartbeats/sources/{source}/assets/{assetType}/{assetId}/post(heartbeat)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.heartbeat.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            package var accepted: Operations.heartbeat.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            package struct BadRequest: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/responses/400/content`.
                @frozen package enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/responses/400/content/application\/json`.
                    case json(Components.Schemas.ResponseError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    package var json: Components.Schemas.ResponseError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                package var body: Operations.heartbeat.Output.BadRequest.Body
                /// Creates a new `BadRequest`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                package init(body: Operations.heartbeat.Output.BadRequest.Body) {
                    self.body = body
                }
            }
            /// Indicates that the heartbeat was rejected.
            ///
            /// - Remark: Generated from `#/paths//heartbeats/sources/{source}/assets/{assetType}/{assetId}/post(heartbeat)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.heartbeat.Output.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            package var badRequest: Operations.heartbeat.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            package struct InternalServerError: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/responses/500/content`.
                @frozen package enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/heartbeats/sources/{source}/assets/{assetType}/{assetId}/POST/responses/500/content/application\/json`.
                    case json(Components.Schemas.ResponseError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    package var json: Components.Schemas.ResponseError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                package var body: Operations.heartbeat.Output.InternalServerError.Body
                /// Creates a new `InternalServerError`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                package init(body: Operations.heartbeat.Output.InternalServerError.Body) {
                    self.body = body
                }
            }
            /// Internal server error.
            ///
            /// - Remark: Generated from `#/paths//heartbeats/sources/{source}/assets/{assetType}/{assetId}/post(heartbeat)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Operations.heartbeat.Output.InternalServerError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            package var internalServerError: Operations.heartbeat.Output.InternalServerError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen package enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            package init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            package var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            package static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
