// Copyright © 2024 Apple Inc. All Rights Reserved.

// APPLE INC.
// PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT
// PLEASE READ THE FOLLOWING PRIVATE CLOUD COMPUTE SOURCE CODE INTERNAL USE LICENSE AGREEMENT (“AGREEMENT”) CAREFULLY BEFORE DOWNLOADING OR USING THE APPLE SOFTWARE ACCOMPANYING THIS AGREEMENT(AS DEFINED BELOW). BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, DO NOT DOWNLOAD OR USE THE APPLE SOFTWARE. THESE TERMS AND CONDITIONS CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND APPLE.
// IMPORTANT NOTE: BY DOWNLOADING OR USING THE APPLE SOFTWARE, YOU ARE AGREEING ON YOUR OWN BEHALF AND/OR ON BEHALF OF YOUR COMPANY OR ORGANIZATION TO THE TERMS OF THIS AGREEMENT.
// 1. As used in this Agreement, the term “Apple Software” collectively means and includes all of the Apple Private Cloud Compute materials provided by Apple here, including but not limited to the Apple Private Cloud Compute software, tools, data, files, frameworks, libraries, documentation, logs and other Apple-created materials. In consideration for your agreement to abide by the following terms, conditioned upon your compliance with these terms and subject to these terms, Apple grants you, for a period of ninety (90) days from the date you download the Apple Software, a limited, non-exclusive, non-sublicensable license under Apple’s copyrights in the Apple Software to download, install, compile and run the Apple Software internally within your organization only on a single Apple-branded computer you own or control, for the sole purpose of verifying the security and privacy characteristics of Apple Private Cloud Compute. This Agreement does not allow the Apple Software to exist on more than one Apple-branded computer at a time, and you may not distribute or make the Apple Software available over a network where it could be used by multiple devices at the same time. You may not, directly or indirectly, redistribute the Apple Software or any portions thereof. The Apple Software is only licensed and intended for use as expressly stated above and may not be used for other purposes or in other contexts without Apple's prior written permission. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein.
// 2. The Apple Software is provided by Apple on an "AS IS" basis. APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT THAT THE APPLE SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE APPLE SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS IN THE APPLE SOFTWARE WILL BE CORRECTED, OR THAT THE APPLE SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED REPRESENTATIVE WILL CREATE A WARRANTY.
// 3. IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, COMPILATION OR OPERATION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 4. This Agreement is effective until terminated. Your rights under this Agreement will terminate automatically without notice from Apple if you fail to comply with any term(s) of this Agreement. Upon termination, you agree to cease all use of the Apple Software and destroy all copies, full or partial, of the Apple Software. This Agreement constitutes the entire understanding of the parties with respect to the subject matter contained herein, and supersedes all prior negotiations, representations, or understandings, written or oral. This Agreement will be governed and construed in accordance with the laws of the State of California, without regard to its choice of law rules.
// You may report security issues about Apple products to product-security@apple.com, as described here: https://www.apple.com/support/security/. Non-security bugs and enhancement requests can be made via https://bugreport.apple.com as described here: https://developer.apple.com/bug-reporting/
// EA1937
// 10/02/2024

// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: AttestationBundle.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

import Foundation
import InternalSwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: InternalSwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: InternalSwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

enum Proto_HashAlg: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case unknown // = 0
  case sha256 // = 1
  case sha384 // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .unknown
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknown
    case 1: self = .sha256
    case 2: self = .sha384
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknown: return 0
    case .sha256: return 1
    case .sha384: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [Proto_HashAlg] = [
    .unknown,
    .sha256,
    .sha384,
  ]

}

struct Proto_AttestationBundle: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// DER encoded SEP attestation blob.
  var sepAttestation: Data = Data()

  /// Image4 Manifest DER blob.
  var apTicket: Data = Data()

  var sealedHashes: Proto_SealedHashLedger {
    get {return _sealedHashes ?? Proto_SealedHashLedger()}
    set {_sealedHashes = newValue}
  }
  /// Returns true if `sealedHashes` has been explicitly set.
  var hasSealedHashes: Bool {return self._sealedHashes != nil}
  /// Clears the value of `sealedHashes`. Subsequent reads from it will return its default value.
  mutating func clearSealedHashes() {self._sealedHashes = nil}

  var provisioningCertificateChain: [Data] = []

  /// Unix timestamp of the key's epxiration, as hinted by the attested device
  var keyExpiration: InternalSwiftProtobuf.Google_Protobuf_Timestamp {
    get {return _keyExpiration ?? InternalSwiftProtobuf.Google_Protobuf_Timestamp()}
    set {_keyExpiration = newValue}
  }
  /// Returns true if `keyExpiration` has been explicitly set.
  var hasKeyExpiration: Bool {return self._keyExpiration != nil}
  /// Clears the value of `keyExpiration`. Subsequent reads from it will return its default value.
  mutating func clearKeyExpiration() {self._keyExpiration = nil}

  var transparencyProofs: Proto_TransparencyProofs {
    get {return _transparencyProofs ?? Proto_TransparencyProofs()}
    set {_transparencyProofs = newValue}
  }
  /// Returns true if `transparencyProofs` has been explicitly set.
  var hasTransparencyProofs: Bool {return self._transparencyProofs != nil}
  /// Clears the value of `transparencyProofs`. Subsequent reads from it will return its default value.
  mutating func clearTransparencyProofs() {self._transparencyProofs = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _sealedHashes: Proto_SealedHashLedger? = nil
  fileprivate var _keyExpiration: InternalSwiftProtobuf.Google_Protobuf_Timestamp? = nil
  fileprivate var _transparencyProofs: Proto_TransparencyProofs? = nil
}

struct Proto_SealedHashLedger: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var slots: Dictionary<String,Proto_SealedHash> = [:]

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Proto_SealedHash: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var hashAlg: Proto_HashAlg = .unknown

  var entries: [Proto_SealedHash.Entry] = []

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  struct Entry: @unchecked Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Flags set for the sealed hash update. Uses int32 since Flags can be Bitwise OR'd together.
    var flags: Int32 = 0

    /// The actual bytes (up to 48) sent to AppleKeyStore to set or ratchet into a Software Sealed Hash Register. Despite the name, it isn't necessarily a digest.
    var digest: Data = Data()

    /// A tagged union of different payloads that are written to a Software Sealed Hash Register.
    /// Each payload should have enough information in of itself to reconstruct the above `digest` value.
    var info: Proto_SealedHash.Entry.OneOf_Info? = nil

    /// Information over a cryptex that result to `digest` when hashed canonically using `alg`
    var cryptex: Proto_Cryptex {
      get {
        if case .cryptex(let v)? = info {return v}
        return Proto_Cryptex()
      }
      set {info = .cryptex(newValue)}
    }

    /// A libCryptex defined magic value that serves as and END marker for a register. Typically should have FLAG_RATCHET_LOCKED
    var cryptexSalt: Proto_Cryptex.Salt {
      get {
        if case .cryptexSalt(let v)? = info {return v}
        return Proto_Cryptex.Salt()
      }
      set {info = .cryptexSalt(newValue)}
    }

    /// A SecureConfig Entry
    var secureConfig: Proto_SecureConfig {
      get {
        if case .secureConfig(let v)? = info {return v}
        return Proto_SecureConfig()
      }
      set {info = .secureConfig(newValue)}
    }

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    /// A tagged union of different payloads that are written to a Software Sealed Hash Register.
    /// Each payload should have enough information in of itself to reconstruct the above `digest` value.
    enum OneOf_Info: Equatable, Sendable {
      /// Information over a cryptex that result to `digest` when hashed canonically using `alg`
      case cryptex(Proto_Cryptex)
      /// A libCryptex defined magic value that serves as and END marker for a register. Typically should have FLAG_RATCHET_LOCKED
      case cryptexSalt(Proto_Cryptex.Salt)
      /// A SecureConfig Entry
      case secureConfig(Proto_SecureConfig)

    }

    enum Flags: InternalSwiftProtobuf.Enum, Swift.CaseIterable {
      typealias RawValue = Int
      case flagNone // = 0
      case flagRatchet // = 2
      case flagRatchetLock // = 4
      case UNRECOGNIZED(Int)

      init() {
        self = .flagNone
      }

      init?(rawValue: Int) {
        switch rawValue {
        case 0: self = .flagNone
        case 2: self = .flagRatchet
        case 4: self = .flagRatchetLock
        default: self = .UNRECOGNIZED(rawValue)
        }
      }

      var rawValue: Int {
        switch self {
        case .flagNone: return 0
        case .flagRatchet: return 2
        case .flagRatchetLock: return 4
        case .UNRECOGNIZED(let i): return i
        }
      }

      // The compiler won't synthesize support with the UNRECOGNIZED case.
      static let allCases: [Proto_SealedHash.Entry.Flags] = [
        .flagNone,
        .flagRatchet,
        .flagRatchetLock,
      ]

    }

    init() {}
  }

  init() {}
}

struct Proto_Cryptex: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var image4Manifest: Data = Data()

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  /// Metadata about a libCryptex salt. Actual value can be inspected from `SealedHash.Entry.digest`
  struct Salt: Sendable {
    // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = InternalSwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

struct Proto_SecureConfig: @unchecked Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var entry: Data = Data()

  var metadata: Dictionary<String,String> = [:]

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}
}

struct Proto_TransparencyProofs: Sendable {
  // InternalSwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var proofs: ATLogProofs {
    get {return _proofs ?? ATLogProofs()}
    set {_proofs = newValue}
  }
  /// Returns true if `proofs` has been explicitly set.
  var hasProofs: Bool {return self._proofs != nil}
  /// Clears the value of `proofs`. Subsequent reads from it will return its default value.
  mutating func clearProofs() {self._proofs = nil}

  var unknownFields = InternalSwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _proofs: ATLogProofs? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "proto"

extension Proto_HashAlg: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "HASH_ALG_UNKNOWN"),
    1: .same(proto: "HASH_ALG_SHA256"),
    2: .same(proto: "HASH_ALG_SHA384"),
  ]
}

extension Proto_AttestationBundle: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AttestationBundle"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "sep_attestation"),
    2: .standard(proto: "ap_ticket"),
    3: .standard(proto: "sealed_hashes"),
    4: .standard(proto: "provisioning_certificate_chain"),
    6: .standard(proto: "key_expiration"),
    8: .standard(proto: "transparency_proofs"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.sepAttestation) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.apTicket) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._sealedHashes) }()
      case 4: try { try decoder.decodeRepeatedBytesField(value: &self.provisioningCertificateChain) }()
      case 6: try { try decoder.decodeSingularMessageField(value: &self._keyExpiration) }()
      case 8: try { try decoder.decodeSingularMessageField(value: &self._transparencyProofs) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sepAttestation.isEmpty {
      try visitor.visitSingularBytesField(value: self.sepAttestation, fieldNumber: 1)
    }
    if !self.apTicket.isEmpty {
      try visitor.visitSingularBytesField(value: self.apTicket, fieldNumber: 2)
    }
    try { if let v = self._sealedHashes {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    if !self.provisioningCertificateChain.isEmpty {
      try visitor.visitRepeatedBytesField(value: self.provisioningCertificateChain, fieldNumber: 4)
    }
    try { if let v = self._keyExpiration {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    } }()
    try { if let v = self._transparencyProofs {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_AttestationBundle, rhs: Proto_AttestationBundle) -> Bool {
    if lhs.sepAttestation != rhs.sepAttestation {return false}
    if lhs.apTicket != rhs.apTicket {return false}
    if lhs._sealedHashes != rhs._sealedHashes {return false}
    if lhs.provisioningCertificateChain != rhs.provisioningCertificateChain {return false}
    if lhs._keyExpiration != rhs._keyExpiration {return false}
    if lhs._transparencyProofs != rhs._transparencyProofs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_SealedHashLedger: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SealedHashLedger"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "slots"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeMapField(fieldType: InternalSwiftProtobuf._ProtobufMessageMap<InternalSwiftProtobuf.ProtobufString,Proto_SealedHash>.self, value: &self.slots) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.slots.isEmpty {
      try visitor.visitMapField(fieldType: InternalSwiftProtobuf._ProtobufMessageMap<InternalSwiftProtobuf.ProtobufString,Proto_SealedHash>.self, value: self.slots, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_SealedHashLedger, rhs: Proto_SealedHashLedger) -> Bool {
    if lhs.slots != rhs.slots {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_SealedHash: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SealedHash"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "hash_alg"),
    2: .same(proto: "entries"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.hashAlg) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.entries) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.hashAlg != .unknown {
      try visitor.visitSingularEnumField(value: self.hashAlg, fieldNumber: 1)
    }
    if !self.entries.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.entries, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_SealedHash, rhs: Proto_SealedHash) -> Bool {
    if lhs.hashAlg != rhs.hashAlg {return false}
    if lhs.entries != rhs.entries {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_SealedHash.Entry: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Proto_SealedHash.protoMessageName + ".Entry"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "flags"),
    2: .same(proto: "digest"),
    3: .same(proto: "cryptex"),
    4: .standard(proto: "cryptex_salt"),
    5: .standard(proto: "secure_config"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self.flags) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.digest) }()
      case 3: try {
        var v: Proto_Cryptex?
        var hadOneofValue = false
        if let current = self.info {
          hadOneofValue = true
          if case .cryptex(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.info = .cryptex(v)
        }
      }()
      case 4: try {
        var v: Proto_Cryptex.Salt?
        var hadOneofValue = false
        if let current = self.info {
          hadOneofValue = true
          if case .cryptexSalt(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.info = .cryptexSalt(v)
        }
      }()
      case 5: try {
        var v: Proto_SecureConfig?
        var hadOneofValue = false
        if let current = self.info {
          hadOneofValue = true
          if case .secureConfig(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.info = .secureConfig(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.flags != 0 {
      try visitor.visitSingularInt32Field(value: self.flags, fieldNumber: 1)
    }
    if !self.digest.isEmpty {
      try visitor.visitSingularBytesField(value: self.digest, fieldNumber: 2)
    }
    switch self.info {
    case .cryptex?: try {
      guard case .cryptex(let v)? = self.info else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .cryptexSalt?: try {
      guard case .cryptexSalt(let v)? = self.info else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .secureConfig?: try {
      guard case .secureConfig(let v)? = self.info else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_SealedHash.Entry, rhs: Proto_SealedHash.Entry) -> Bool {
    if lhs.flags != rhs.flags {return false}
    if lhs.digest != rhs.digest {return false}
    if lhs.info != rhs.info {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_SealedHash.Entry.Flags: InternalSwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    0: .same(proto: "FLAG_NONE"),
    2: .same(proto: "FLAG_RATCHET"),
    4: .same(proto: "FLAG_RATCHET_LOCK"),
  ]
}

extension Proto_Cryptex: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Cryptex"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .standard(proto: "image4_manifest"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.image4Manifest) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.image4Manifest.isEmpty {
      try visitor.visitSingularBytesField(value: self.image4Manifest, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_Cryptex, rhs: Proto_Cryptex) -> Bool {
    if lhs.image4Manifest != rhs.image4Manifest {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_Cryptex.Salt: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Proto_Cryptex.protoMessageName + ".Salt"
  static let _protobuf_nameMap = InternalSwiftProtobuf._NameMap()

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_Cryptex.Salt, rhs: Proto_Cryptex.Salt) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_SecureConfig: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SecureConfig"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "entry"),
    2: .same(proto: "metadata"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.entry) }()
      case 2: try { try decoder.decodeMapField(fieldType: InternalSwiftProtobuf._ProtobufMap<InternalSwiftProtobuf.ProtobufString,InternalSwiftProtobuf.ProtobufString>.self, value: &self.metadata) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.entry.isEmpty {
      try visitor.visitSingularBytesField(value: self.entry, fieldNumber: 1)
    }
    if !self.metadata.isEmpty {
      try visitor.visitMapField(fieldType: InternalSwiftProtobuf._ProtobufMap<InternalSwiftProtobuf.ProtobufString,InternalSwiftProtobuf.ProtobufString>.self, value: self.metadata, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_SecureConfig, rhs: Proto_SecureConfig) -> Bool {
    if lhs.entry != rhs.entry {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Proto_TransparencyProofs: InternalSwiftProtobuf.Message, InternalSwiftProtobuf._MessageImplementationBase, InternalSwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TransparencyProofs"
  static let _protobuf_nameMap: InternalSwiftProtobuf._NameMap = [
    1: .same(proto: "proofs"),
  ]

  mutating func decodeMessage<D: InternalSwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._proofs) }()
      default: break
      }
    }
  }

  func traverse<V: InternalSwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._proofs {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Proto_TransparencyProofs, rhs: Proto_TransparencyProofs) -> Bool {
    if lhs._proofs != rhs._proofs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
