// Copyright (c) 2021, Apple Inc. All rights reserved.
//
// Use of this source code is governed by a BSD-3-clause license that can be
// found in the LICENSE.txt file or at https://opensource.org/licenses/BSD-3-Clause

#include "BlobUtils.hpp"

namespace MILBlob {
namespace TestUtil {

AutoDeleteTempFile MakeStorageTempFileWith3Records()
{
    AutoDeleteTempFile tempfile;

    // clang-format off
    std::vector<uint16_t> bytes {
        // HEADER
        0x0001, 0x0000, 0x0002, 0x0000,  // count=1, version=2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_5
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_6
        // 64 Bytes
        // METADATA 1
        0xBEEF, 0xDEAD, 0x0003, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint8_t
        0x0005, 0x0000, 0x0000, 0x0000,  // sizeInBytes=5 bytes
        0x0080, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 128 Bytes
        // DATA 1
        0x0002, 0x0040, 0x0007, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 192 Bytes
        // METADATA 2
        0xBEEF, 0xDEAD, 0x0001, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=Fp16
        0x0008, 0x0000, 0x0000, 0x0000,  // sizeInBytes=8 bytes
        0x0100, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 256 Bytes
        // DATA 2
        0x000E, 0xC0FE, 0x0810, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 320 Bytes
        // METADATA 3
        0xBEEF, 0xDEAD, 0x0002, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=Float32
        0x0010, 0x0000, 0x0000, 0x0000,  // sizeInBytes=16 bytes
        0x0180, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 384 Bytes
        // DATA 3
        0x0000, 0x0070, 0x0FEE, 0x000C,
        0xFACE, 0x0008, 0xFADE, 0x0091,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        //448 Bytes
        // METADATA 4
        0xBEEF, 0xDEAD, 0x0004, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=Int8
        0x0006, 0x0000, 0x0000, 0x0000,  // sizeInBytes=6 bytes
        0x0200, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 512 Bytes
        // DATA 4
        0xf8f0, 0x02fe, 0x1008, 0x0000, // [-16, -8, -2, 2, 8, 16]
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 576 Bytes
        // METADATA 5
        0xBEEF, 0xDEAD, 0x0005, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=Bf16
        0x0008, 0x0000, 0x0000, 0x0000,  // sizeInBytes=8 bytes
        0x0280, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 640 Bytes
        // DATA 5
        0x000E, 0xC0FE, 0x0810, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 704 BYTES
        // METADATA 6
        0xBEEF, 0xDEAD, 0x0006, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=int16
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0300, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 768 BYTES
        // DATA 6
        0xe8d0, 0x007e, 0x0000, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 832 BYTES
        // METADATA 7
        0xBEEF, 0xDEAD, 0x0007, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint16
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0380, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 896 BYTES
        // DATA 7
        0xe8d0, 0x007e, 0x0000, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 960 BYTES
        // METADATA 8
        0xBEEF, 0xDEAD, 0x0008, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=int4
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0400, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // padding_size_in_bits
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1024 BYTES
        // DATA 8
        0xe8d0, 0x007e, 0x0000, 0x0000,

        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1088 BYTES
        // METADATA 9
        0xBEEF, 0xDEAD, 0x000B, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint4
        0x0003, 0x0000, 0x0000, 0x0000,  // sizeInBytes=3 bytes
        0x0480, 0x0000, 0x0000, 0x0000,  // offset
        0x0004, 0x0000, 0x0000, 0x0000,  // padding_size_in_bits = 4
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1152 BYTES
        // DATA 9
        0xe8d1, 0x107c, 0x0000, 0x0000,

        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1216 BYTES
        // METADATA 10
        0xBEEF, 0xDEAD, 0x0009, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint1
        0x0003, 0x0000, 0x0000, 0x0000,  // sizeInBytes=3 bytes
        0x0500, 0x0000, 0x0000, 0x0000,  // offset
        0x0007, 0x0000, 0x0000, 0x0000,  // padding_size_in_bits = 7
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1280 BYTES
        // DATA 10
        0xEC24, 0xFFF7, 0x0000, 0x0000,

        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1344 BYTES
        // METADATA 11
        0xBEEF, 0xDEAD, 0x000A, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint2
        0x0002, 0x0000, 0x0000, 0x0000,  // sizeInBytes=2 bytes
        0x0580, 0x0000, 0x0000, 0x0000,  // offset
        0x0002, 0x0000, 0x0000, 0x0000,  // padding_size_in_bits = 2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1408 BYTES
        // DATA 11
        0xEC24, 0x0000, 0x0000, 0x0000,

        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1472 BYTES
        // METADATA 12
        0xBEEF, 0xDEAD, 0x000C, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint3
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0600, 0x0000, 0x0000, 0x0000,  // offset
        0x0005, 0x0000, 0x0000, 0x0000,  // padding_size_in_bits = 5 (9 elements)
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1536 BYTES
        // DATA 12
        0xEC24, 0x1D45, 0x0000, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1600 BYTES
        // METADATA 13
        0xBEEF, 0xDEAD, 0x000E, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=int32
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0680, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1664 BYTES
        // DATA 13
        0x0C24, 0x0000, 0x0000, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1728 BYTES
        // METADATA 14
        0xBEEF, 0xDEAD, 0x000F, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=uint32
        0x0008, 0x0000, 0x0000, 0x0000,  // sizeInBytes=8 bytes
        0x0700, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1792 BYTES
        // DATA 14
        0x0C24, 0x0000, 0xBEEF, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1856 BYTES
        // METADATA 15
        0xBEEF, 0xDEAD, 0x0011, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=Fp8E5M2
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0780, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 1920 BYTES
        // DATA 15
        0xEFBE, 0xCA00, 0x0000, 0x0000,
        // Padding
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        // 1984 BYTES
        // METADATA 16
        0xBEEF, 0xDEAD, 0x0010, 0x0000,  // sentinel=0xDEADBEEF, mil_dtype=Fp8E4M3
        0x0004, 0x0000, 0x0000, 0x0000,  // sizeInBytes=4 bytes
        0x0780, 0x0000, 0x0000, 0x0000,  // offset
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_0
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_1
        0x0001, 0x0000, 0x0000, 0x0000,  // reserved_2
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_3
        0x0000, 0x0000, 0x0000, 0x0000,  // reserved_4
        // 2048 BYTES
        // DATA 15
        0xEFBE, 0xCA00, 0x0000, 0x0000,
    };
    // clang-format on

    WriteBlobFile(tempfile.GetFilename(), Util::MakeSpan(bytes));
    return tempfile;
}

}  // namespace TestUtil
}  // namespace MILBlob
