```{eval-rst}
.. index:: 
   single: TensorFlow; source formats
   single: PyTorch; source formats
```


# Source and Conversion Formats

Use the `convert()` method of the Core ML Tools [Unified Conversion API](https://apple.github.io/coremltools/index.html) (available from Core ML Tools version 4.0 and newer versions) to convert deep learning models to the Core ML model format in order to deploy them in the [Core ML](https://developer.apple.com/documentation/coreml) framework. 


## Supported Source Formats

Source model formats supported by the [Unified Conversion API](unified-conversion-api) include the following:

### TensorFlow versions 1.x Formats

- Frozen [`tf.Graph`](https://www.tensorflow.org/api_docs/python/tf/Graph)
- Frozen graph (`.pb`) file path
- [`tf.keras.Model`](https://www.tensorflow.org/api_docs/python/tf/keras)
- [HDF5 file path](https://keras.io/api/models/model_saving_apis/) (`.h5`)
- [SavedModel](https://www.tensorflow.org/guide/saved_model) directory path

### TensorFlow versions 2.x Formats

- [`tf.keras.Model`](https://www.tensorflow.org/api_docs/python/tf/keras)
- [HDF5 file path](https://keras.io/api/models/model_saving_apis/) (`.h5`)
- [SavedModel](https://www.tensorflow.org/guide/saved_model) directory path
- [Concrete function](https://www.tensorflow.org/guide/concrete_function).

### PyTorch Formats

- [TorchScript](https://pytorch.org/docs/stable/jit.html) object
- TorchScript object saved as a `.pt` file
- [ExportedProgram](https://pytorch.org/docs/stable/export.html) object

```{eval-rst}
.. index:: 
   single: convert to; target format
   single: neural network; target format
   single: ML program; target format
```

## Target Conversion Formats

You can choose which format to use during conversion using the `convert_to` or the `minimum_deployment_target` arguments in the [`convert()`](https://apple.github.io/coremltools/source/coremltools.converters.convert.html#module-coremltools.converters._converters_entry) method.

### Default Format

While `neuralnetwork` was the format originally used by Core ML to represent neural networks, it is now in maintenance mode and no longer receiving new features. The `mlprogram` model format, deployable to `iOS15`, `macOS12`, `watchOS8`, `tvOS15`, and newer versions, is the recommended format. 

Since the `neuralnetwork` format is widely available, it is still the default format produced by versions of the [Unified Conversion API](unified-conversion-api) older than 7.0. Calling [convert()](https://apple.github.io/coremltools/source/coremltools.converters.convert.html#coremltools.converters._converters_entry.convert) without providing the `convert_to` or the `minimum_deployment_target` parameters, in versions older than 7.0, defaults to the `iOS11`/`macOS10.13` deployment target and the `neuralnetwork` backend.

However, in 7.0 and newer versions of Core ML Tools, the [`convert()`](https://apple.github.io/coremltools/source/coremltools.converters.convert.html#module-coremltools.converters._converters_entry) method produces an `mlprogram` by default with the `iOS15`/`macOS12` deployment target. You can override this behavior by providing a `minimum_deployment_target` value.

### Format Differences

The following table summarizes the format differences:

|   | Neural Network | ML Program |
| ----------- | ----------- | ----------- |
| Minimum deployment target | macOS 10.13, iOS 11, watchOS 4, tvOS 11 | macOS 12, iOS 15, watchOS 8, tvOS 15 |
| Supported file formats | `.mlmodel` or `.mlpackage` | `.mlpackage` |

```{note}
To learn more about the differences between the two formats, see [Comparing ML Programs and Neural Networks](comparing-ml-programs-and-neural-networks).
```

#### Minimum Deployment Target

- Neural network: macOS 10.13, iOS 11, watchOS 4, tvOS 11
- ML Program: macOS 12, iOS 15, watchOS 8, tvOS 15

#### Supported Core ML File Formats

- Neural network: `.mlmodel` or [`.mlpackage`](convert-to-ml-program.md#save-ml-programs-as-model-packages)
- ML Program: [`.mlpackage`](convert-to-ml-program.md#save-ml-programs-as-model-packages)

#### How to Produce

- Core ML Tools versions older than 7.0:
	- Neural network: Generated by default by the [`convert()`](https://apple.github.io/coremltools/source/coremltools.converters.convert.html#module-coremltools.converters._converters_entry) method.
	- ML Program: Use either `convert_to="mlprogram"`, or `minimum_deployment_target=target.iOS15` or newer. 

- Core ML Tools 7.0 and newer:
	- Neural network: Use `minimum_deployment_target=target.iOS14` or older.
	- ML Program: Generated by default by the [`convert()`](https://apple.github.io/coremltools/source/coremltools.converters.convert.html#module-coremltools.converters._converters_entry) method.

#### Format Specification

- Neural network: See [NeuralNetwork.proto](https://github.com/apple/coremltools/blob/main/mlmodel/format/NeuralNetwork.proto) or [NeuralNetwork spec description](https://apple.github.io/coremltools/mlmodel/Format/NeuralNetwork.html).
- ML Program: See [MIL.proto](https://github.com/apple/coremltools/blob/main/mlmodel/format/MIL.proto) or [MILspec.Program spec description](https://apple.github.io/coremltools/mlmodel/Format/MIL.html).

#### Supported Operations

- Neural network: Set of supported ops frozen. For the current list of ops (also known as _layers_), see the [NeuralNetwork spec description](https://apple.github.io/coremltools/mlmodel/Format/NeuralNetwork.html).
- ML Program: New ops are added continually. For the current list of ops, see [MIL Ops](https://apple.github.io/coremltools/source/coremltools.converters.mil.mil.ops.defs.html).

#### Feature Development

- Neural network: Frozen, under maintenance only.
- ML Program: All new features target the ML Program format.

#### Performance Improvements

- Neural network: Limited.
- ML Program: All major performance enhancements target ML Program.



