
Contribution Guidelines
=======================

The Core ML `.mlmodel` file format is a publicly documented specification. The Core ML Tools source code is 100% open source under the [BSD-3 Clause license](https://github.com/apple/coremltools/blob/master/LICENSE.txt). We welcome all contributions and ideas to grow the product. We ask that you follow the [contributing guidelines and code of conduct](#guidelines-and-code-of-conduct), which are typical of open source communities.

There are many ways to contribute to coremltools. [**Use these templates**](https://github.com/apple/coremltools/issues/new/choose) to report issues, make feature requests, or ask questions. We welcome even minor improvements to code, testing, and documentation, as well as requests for new features and enhancements. Don’t hesitate to do the following:

* Report issues you are facing. Check [open issues](https://github.com/apple/coremltools/issues) to see if the issue has already been reported, and [current pull requests](https://github.com/apple/coremltools/pulls) to see if the issue has already been addressed. Comment on or thumbs-up issues that have already been reported by others. We encourage you to resolve or add comments.
* Request new features or enhancements, or ask questions, using [these templates](https://github.com/apple/coremltools/issues/new/choose).
* Add new code to improve a feature or add functionality by submitting a GitHub [pull request](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request). For examples, see the [list of current pull requests](https://github.com/apple/coremltools/pulls). 
* Improve the documentation. Even if you find only a typo, don’t hesitate to send us a pull request with your corrections. 

For instructions, see [**Contributing**](https://coremltools.readme.io/docs/how-to-contribute).

## Guidelines and code of conduct 

The contributing guidelines and code of conduct are similar to those of most open source communities. They include participating in the community through developing, receiving help, and answering questions as well as engaging in a highly motivated and positive environment. For example:

* Providing comments that are helpful, motivating and constructive.
* Treating with respect others within the community.
* Collaborating with others to produce new and useful contributions to the community.

To ensure that issues and pull requests can be addressed quickly, please do the following before submitting issues, questions, or pull requests:

* Check [open issues](https://github.com/apple/coremltools/issues) and [current pull requests](https://github.com/apple/coremltools/pulls) in the repository to see if your issue, feature request, or question already exists or has already been addressed.
* Fill in the appropriate [template](https://github.com/apple/coremltools/issues/new/choose) with as much detail as possible as well as code snippets, so that we are able to reproduce the issue.
* Promptly reply to any requests or questions asked by others within the community on your issue or pull request.

## Resources

For more information, see the following:

* [Contributing](https://coremltools.readme.io/docs/how-to-contribute) for instructions on contributing to the repository.
* Core ML Tools [README](README.md) file for this repository
* [Release Notes](https://github.com/apple/coremltools/releases/) for the current release and previous releases
* [Guides and examples](https://coremltools.readme.io/) with installation and troubleshooting
* [API Reference](https://apple.github.io/coremltools/index.html)
* [Core ML Specification](https://apple.github.io/coremltools/mlmodel/index.html)
* [Building from Source](BUILDING.md)

