# Supported browsers and frameworks

Dubbo-JS extends its support to all modern web browsers that embrace the widely implemented Fetch API and Encoding API standards. The library itself, along with the generated codebase, conforms to the ES2017 specification and is fully compatible with TypeScript 5.

Embodying a neutral stance towards frameworks, Dubbo-JS comfortably operates in vanilla JavaScript environments and is equally adept at integrating with popular application and testing frameworks. These include React, Next.js from the React ecosystem, as well as others like Svelte, Vue, Playwright, and Vitest. Additionally, it harmoniously pairs with commonly used package managers such as npm, pnpm, and Yarn, offering immediate usability without additional configuration.

Dubbo-JS also melds seamlessly with various module loaders and bundlers, including esbuild, Vite, and Rollup, catering to diverse development workflows.

While striving for universality, it's worth noting that certain subtleties and common setup challenges may arise based on the specific tooling within your project. This section serves to shed light on these potential issues and presents actionable workarounds with accompanying examples to guide you through configuring Dubbo-JS in your technology stack effectively.
