# Hacktoberfest Open Source Project

Welcome to the Hacktoberfest Open Source Project! We're excited to have you here and appreciate your interest in contributing to our open-source project.

## Table of Contents
1. [What is Open Source?](#what-is-open-source)
2. [What is Hacktoberfest?](#what-is-hacktoberfest)
3. [How to Contribute](#how-to-contribute)
4. [Tech Stack](#tech-stack)
5. [About the Project](#about-the-project)

---
## What is Open Source
Open source is a term used to describe something that is freely available to the public for use, modification, and redistribution. This is most commonly used in the context of software, but it can also apply to other types of creative works, such as music, literature, and even hardware designs.

Open source software is released under a license that grants users the right to use, study, change, and distribute the software and its source code. This means that anyone can inspect the code, modify it to suit their needs, and share their changes with others.

There are many benefits to open source software. It is often more reliable and secure than proprietary software, because it is constantly being reviewed and improved by the community. Open source software is also often more affordable, because it does not require expensive licensing fees.
The open source philosophy is based on the belief that collaboration and transparency are the best way to create high-quality products and services. Open source projects are often developed by a community of volunteers, but there are also many companies that develop and support open source software.

If you are interested in learning more about open source, there are many resources available online and in libraries. You can also find open source projects to contribute to on websites like GitHub and GitLab.
## What is Hacktoberfest?

Hacktoberfest is an annual celebration of open source software sponsored by DigitalOcean, GitHub, and Dev.to. It encourages individuals to contribute to open source projects during the month of October. By participating in Hacktoberfest, you can learn, collaborate, and contribute to the open source community while earning cool swag and prizes.
To participate in Hacktoberfest, you simply need to create a GitHub account and register for the event. Once you are registered, you can start contributing to open source projects by creating pull requests. A pull request is a way to suggest changes to a project's code.

To qualify for the Hacktoberfest challenge, you must make four pull requests that are merged into different open source repositories. Pull requests must be merged between October 1 and October 31.

If you are new to open source, there are many resources available to help you get started. There are also many beginner-friendly projects that you can contribute to.

Hacktoberfest is a great way to learn about open source software and to contribute to the open source community. It is also a great way to meet other developers and to learn new skills.

Here are some tips for participating in Hacktoberfest:

Find a project that you are interested in and that you have some skills in.
Read the project's documentation and contribution guidelines carefully.
Start with small contributions, such as fixing typos or adding documentation.
Be respectful of the maintainers and follow their instructions.
Don't be afraid to ask for help.
Hacktoberfest is a great opportunity to give back to the open source community and to learn new skills. I encourage everyone to participate!

For more information about Hacktoberfest, visit [Hacktoberfest Official Website](https://hacktoberfest.digitalocean.com/).

## How to Contribute

We welcome contributions from developers of all levels of experience. To contribute to our project for Hacktoberfest, follow these steps:

0. **Star the repo**: Star the repo by pressing the topmost-right button to start your wonderful journey.
1. **Fork the Repository**: Click the "Fork" button at the top right of the project's GitHub page to create your own copy of the repository.

2. **Clone the Repository**: Use Git to clone the forked repository to your local machine.
   
    ``` bash
    git clone https://github.com/CareerDevelopmentHub/magic-notes.git
    ```

3. **Create a Branch**: Create a new branch for your contribution
    ``` bash
    git checkout -b feature/my-contribution
    ```

4. **Make Changes**: Make your desired changes to the project. This can include bug fixes, feature additions, documentation improvements, etc

5. **Commit Changes**: Commit your changes with a descriptive commit message.
    ``` bash
    git commit -m "Add feature: my contribution"
    ```

6. **Push Changes**: Push your changes to your forked repository on GitHub.
    ``` bash
    git push origin feature/my-contribution
    ```

7. **Create a Pull Request**: Go to the original project's GitHub page and click the "New Pull Request" button. Compare your branch to the main branch and create the pull request.

## Tech Stack
Magic Notes utilizes the following technologies:

[![My Skills](https://skillicons.dev/icons?i=html,css,bootstrap,javascript)](https://skillicons.dev)


## About the Project
Magic Notes is an open source web application designed specifically for students who want to take notes during class but don’t know where to begin.It uses the Bootstrap CSS framework to create a responsive and visually appealing layout. The app has two main sections:

Add note: This section contains a form where users can enter and add new notes. The form has a text area for entering the note content and a button for adding the note.

Your notes: This section lists all of the user's saved notes. Each note is displayed as a card with the note content and a button for deleting the note.
The app also uses JavaScript to handle the following functionality:

1. Validates the note form before adding a new note.
2. Displays a toast notification if the note form is empty.
3. Deletes a note when the user clicks the delete button.
4. Overall, this is a simple but functional notes app. 
5. It uses Bootstrap to create a responsive and visually appealing layout, and it uses JavaScript to handle basic functionality such as form validation and note deletion.

![image](Hactoberfest.png)
