![Header](https://github.com/annshsingh/flutter-widget-guide/blob/master/Header_fwg.png)

# Flutter Widget Guide

A flutter appliction listing all the widgets covered in [Flutter widget of the week playlist](https://www.youtube.com/playlist?list=PLjxrf2q8roU23XGwz3Km7sQZFTdB996iG)

## Get the app

### Now featured on [itsallwidgets.com](https://itsallwidgets.com) - [Have a look!](https://itsallwidgets.com/flutter-app/flutter-widget-guide) :tada:

Click on the image below to download 

<a href='https://play.google.com/store/apps/details?id=com.annsh.flutterwidgetguide&hl=en&pcampaignid=MKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1'><img alt='Get it on Google Play' src='https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png' width="250"/></a>

### ![slack](slack_logo.png) Want to Join the Slack Community? - [Send me an invite](https://join.slack.com/t/flutter-worldwide/shared_invite/enQtNzMyMjM3Nzc2Njc0LTdmYWI5ZGU5YjgxNjliYzhjZTU0MWNkZTA5MjY4ZmJiMjg4ZGQ2ZDQwNDdiOTdiOWVkZDA2NjY5YjllMGQ1M2M)
 
## About
I created this project to improve my skills with dart and flutter as a development platform. I am used to developing native android apps so I'll be focusing on designing this project for android platform.</br> 
This project might help you to learn about Flutter if you are a beginner in this space.</br>
My experience with flutter has been great thus far.</br> 
I hope you like it too.
</br>The project is developed in [Dart](https://www.dartlang.org/) language.</br>
All the files are listed in the [/lib](https://github.com/annshsingh/flutter-widget-guide/tree/master/lib) folder.</br>

[![GitHub stars](https://img.shields.io/github/stars/annshsingh/FlutterWidgetGuide?style=social)](https://github.com/annshsingh/FlutterWidgetGuide) [![GitHub forks](https://img.shields.io/github/forks/annshsingh/FlutterWidgetGuide?style=social)](https://github.com/annshsingh/FlutterWidgetGuide/fork) [![GitHub watchers](https://img.shields.io/github/watchers/annshsingh/FlutterWidgetGuide?style=social&label=Watch)](https://github.com/annshsingh/FlutterWidgetGuide) [![GitHub followers](https://img.shields.io/github/followers/annshsingh?style=social&label=Follow)](https://github.com/annshsingh)
[![Twitter Follow](https://img.shields.io/twitter/follow/annsh2013?style=social)](https://twitter.com/annsh2013)

#### :star: the repo to show some :heart: and motivate me to work on the project :smiley:

## Widget List
   1. [Safe Area](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/safe_area.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-safearea-widget-in-5-mins-or-less-df4620a7d08f)
   2. [Expanded](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/expanded.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-expanded-widget-in-5-mins-or-less-7fac99839658)
   3. [Wrap](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/wrap.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-wrap-widget-in-5-mins-or-less-f77ad249c176)
   4. [Animated Container](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_container.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-animatedcontainer-widget-in-5-mins-or-less-347b69eaad0f)
   5. [Opacity](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/opacity.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-opacity-widget-in-5-mins-or-less-969c3f635437)
   6. [Future Builder](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/future_builder.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-futurebuilder-widget-in-5-mins-or-less-3bef3e5e1bff)
   7. [Fade Transition](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/fade_transition.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-fadetransition-widget-in-5-mins-or-less-78e714ba722)
   8. [Floating Action Button](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/floating_action_button.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-fab-widget-in-5-mins-or-less-bbf84db22d3c)
   9. [Page View](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/page_view.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-pageview-widget-in-5-mins-or-less-bc7968f264ac)
   10. [Table](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/table.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-table-widget-in-5-mins-or-less-9b7f7f796014)
   11. [Sliver App Bar](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/sliver_app_bar.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-sliverappbar-widget-in-5-mins-or-less-d39ae4bf98c8)
   12. [Sliver List](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/sliver_list.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-sliverlist-widget-in-5-mins-or-less-d1215c677388)
   13. [Sliver Grid](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/sliver_grid.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-slivergrid-widget-in-5-mins-or-less-e6a95d6c4e76)
   14. [Fade In Image](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/fade_in_image.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-fadeinimage-widget-in-5-mins-or-less-2659a9aa5bfd)
   15. [Stream Builder](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/stream_builder.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-streambuilder-widget-in-5-mins-or-less-9f6a34f7ed2f)
   16. [Inherited Model](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/inherited_model.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-inheritedmodel-widget-in-5-mins-or-less-a2b0dd8beb43)
   17. [ClipRRect](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/clip_r_rect.dart)
   18. [Hero](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/hero.dart) | [![read](medium_icon.png)](https://medium.com/flutter-community/flutter-widget-guide-hero-widget-in-5-mins-or-less-3a8d0b479d4a)
   19. [Custom Paint](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/custom_paint.dart)
   20. [Tooltip](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/tooltip.dart)
   21. [Fitted Box](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/fitted_box.dart)
   22. [Layout Builder](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/layout_builder.dart)
   23. [Absorb Pointer](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/absorb_pointer.dart)
   24. [Transform](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/transform.dart)
   25. [Back Drop Filter](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/backdrop_filter.dart)
   26. [Align](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/align.dart)
   27. [Positioned](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/positioned.dart)
   28. [Animated Builder](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_builder.dart)
   29. [Dismissible](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/dismissible.dart)
   30. [SizedBox Widget](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/sized_box.dart)
   31. [Value Listnable Builder](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/value_listenable_builder.dart)
   32. [Draggable](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/draggable.dart)
   33. [AnimatedList](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_list.dart)
   34. [Flexible](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/flexible.dart)
   35. [MediaQuery](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/media_query.dart)
   36. [Spacer](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/spacer.dart)
   37. [InheritedWidget](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/inherited_widget.dart) (coming soon)
   38. [AnimatedIcon](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_icon.dart)
   39. [AspectRatio](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/aspect_ratio.dart)
   40. [LimitedBox](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/limited_box.dart)
   41. [Placeholder](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/placeholder.dart)
   42. [RichText](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/rich_text.dart)
   43. [ReorderableListView](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/reorderable_listiew.dart)
   44. [AnimatedSwitcher](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_switcher.dart)
   45. [AnimatedPositioned](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_positioned.dart)
   46. [AnimatedPadding](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/animated_padding.dart)
   47. [Indexed Stack](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/indexed_stack.dart)
   48. [Semantics](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/semantics_widget.dart)
   49. [ConstrainedBox](https://github.com/annshsingh/flutter-widget-guide/blob/master/lib/screens/constrained_box.dart)
   50. [Stack](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/stack_widget.dart)
   51. [AnimatedOpacity](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/animated_opacity.dart)
   52. [FractionallySizedBox](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/fractionally_sizedbox.dart)
   53. [ListView](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/list_view.dart)
   54. [ListTile](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/list_tile.dart)
   55. [Container](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/container.dart)
   56. [SelectableText](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/selectable_text.dart)
   57. [DataTable](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/datatable_widget.dart)
   58. [Slider](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/slider_widget.dart)
   59. [AlertDialog](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/alert_dialog_widget.dart)
   60. [AnimatedCrossFade](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/animated_crossfade_widget.dart)
   61. [DraggableScrollableSheet](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/draggable_scrollable_sheet.dart)
   62. [ColorFiltered](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/color_filtered.dart)
   63. [ToggleButtons](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/toggle_buttons.dart)
   64. [CupertinoActionSheet](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/cupertino_action_sheet.dart)
   65. [TweenAnimationBuilder](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/tween_animation_builder.dart)
   66. [Image](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/image_widget.dart)
   67. [Tab View](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/tabs_widget.dart)
   68. [Drawer](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/drawer_widget.dart)
   69. [SnackBar](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/snackbar_widget.dart)
   70. [ListWheelScrollView](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/listwheelscrollview_widget.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-listwheelscrollview-widget-in-5-mins-or-less-c1da452355d2)
   71. [ShaderMask](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/shadermask_widget.dart) | [![read](medium_icon.png)](https://medium.com/@annsh/flutter-widget-guide-shadermask-widget-in-5-mins-or-less-ab9954f526c7)
   72. [NotificationListener](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/notification_listener.dart)
   73. [Builder](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/builder.dart)
   74. [ClipPath](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/clip_path.dart)
   75. [ProgressIndicator](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/circularProgressIndicator.dart)
   76. [Divider](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/divider.dart)
   77. [IgnorePointer](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/ignore_pointer.dart)
   78. [CupertinoActivityIndicator](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/cupertino_activity_indicator.dart)
   79. [ClipOval](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/clipoval.dart)
   80. [AnimatedWidget](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/animated_widget.dart)
   81. [Padding](https://github.com/annshsingh/FlutterWidgetGuide/blob/master/lib/screens/padding.dart)
   
#### I'll try my best to keep the list in sync with the [Youtube Playlist](https://www.youtube.com/playlist?list=PLOU2XLYxmsIL0pH0zWe_ZOHgGhZ7UasUE) :thumbsup:

## Additional Features
   1. Flutter webview implementation
   2. Youtube Video Player
   3. Firebase RemoteConfig
   4. Firebase Cloud Messaging
   5. Firebase AdMob
   6. View Code inside the app.
   7. Copy code or part of code.
   8. Dark Mode
   
## Things to work on in the Future
   1. Save favourite widgets in "Favourites" section - Using SQFlite/Hive.
   2. Collection based view insted of a list - Change Home Page layout. 
   3. Search functionality in list - Add "Search" action on Home Page.
   4. Mark your favourite widget - Firebase cloudstore functionality.
   5. Add Firebase Analytics to track screen views.
   6. Reduce app size by 25% or more.
  
## App Screenshots
<img src="https://github.com/annshsingh/flutter-widget-guide/blob/master/Screen_1.png" alt="Screen1" width="153px" height="280px"><img src="https://github.com/annshsingh/flutter-widget-guide/blob/master/screen_2.png" alt="Screen2" width="153px" height="280px"><img src="https://github.com/annshsingh/flutter-widget-guide/blob/master/screen_4.png" alt="Screen4" width="153px" height="280px"><img src="https://github.com/annshsingh/flutter-widget-guide/blob/master/screen_3.png" alt="Screen3" width="320px" height="153px">
</br>&nbsp; &nbsp; &nbsp;List of Widgets&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Explore a Widget&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; Widget Video&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Source Code

## Building the project

Some files might be missing from the project because of security reasons, as they contain key values.</br>
These are the steps you need to follow to build the project successfully.

### 1. Missing Key.Properties file
Please follow the following steps:

Step 1. Go to android > app > build.gradle</br>

Now,</br>
Comment this line **keystoreProperties.load(new FileInputStream(keystorePropertiesFile))**</br>
Next,</br>Comment everything inside __signingConfigs and buildTypes__</br>
It should look something like this - </br>

```
//keystoreProperties.load(new FileInputStream(keystorePropertiesFile))

signingConfigs {
       // release {
           // keyAlias keystoreProperties['keyAlias']
           // keyPassword keystoreProperties['keyPassword']
           //storeFile file(keystoreProperties['storeFile'])
           // storePassword keystoreProperties['storePassword']
       // }
    }

    buildTypes {
       // release {
           // TODO: Add your own signing config for the release build.
           // Signing with the debug keys for now, so `flutter run --release` works.
           // signingConfig signingConfigs.release
           // minifyEnabled false
           // shrinkResources false
           // useProguard true
           // proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard-rules.pro'
       // }
    }
```
</br>
Step 2. Go to android > local.properties</br>
Add following lines -

```
flutter.versionName=1.0.7
flutter.versionCode=8
flutter.buildMode=release
```
### 2. Missing google-services.json file

This file is used to add firebase services to the project. You might want to add your own file, or better yet, comment the code inside the project to remove the implementation.
Go to **home_page.dart** file and comment out the code for firebase remote config to remove this error.


## Learn more on Flutter
[Official Flutter documentation](https://flutter.dev/docs)</br>
[Flutter widget list](https://flutter.dev/docs/development/ui/widgets)</br>
[Flutter youtube channel](https://www.youtube.com/channel/UCwXdFgeE9KYzlDdR7TG9cMw)

## Created & maintained by
[Annsh Singh](https://github.com/annshsingh)
([LinkedIn](https://www.linkedin.com/in/annsh/))
([Play Store](https://play.google.com/store/apps/dev?id=4716299969505523086&hl=en))
([Twitter](https://mobile.twitter.com/annsh2013))

[![Open Source](https://badges.frapsoft.com/os/v1/open-source.svg?v=102)](https://opensource.org/licenses/Apache-2.0)
[![License](https://img.shields.io/badge/license-Apache%202.0-blue.svg)](https://github.com/annshsingh/flutter-widget-guide/blob/master/LICENSE)

## Contribution Guidelines
This project is a fully open source project, and contributions are welcome. Information on how to get started can be found at the [contributor guide](https://github.com/annshsingh/flutter-widget-guide/blob/master/CONTRIBUTING.md).

## Support

If you learned something from the source code of this project and want to thank me, you can support by buying me a cup of :coffee: or a :doughnut:

[PayPal](https://www.paypal.me/annshsingh) </br>
Google Pay **(annsh29-1@okhdfcbank)**

## License

```
Copyright 2019 Annsh Singh

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

```
