# Contributing to Flutter Widget Guide

:+1::tada: Hey there, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to [this](https://github.com/annshsingh/flutter-widget-guide) project. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.
</br>

#### Want to add a widget?

All the widgets that have not been added to the project will be listed in the [README.md](https://github.com/annshsingh/flutter-widget-guide/blob/master/README.md) file.
If you wish to add one, please raise a pull request with only the widget file. Don't make changes to any other file (unless absolutely required). </br>
> Note: Please have a look at the other widget screens and follow the same theme pattern.

#### Things to keep in mind while raising a pull request.

First of all, thanks again for taking out the time to contribute to this project.</br>

I will try my best to consider and add your contribution but to keep things clear for me as well as for other users, i would like you to have 
a look at the following points before raising a pull request:
* If the pull request is to add a widget to the list:
  * Please provide the title of your PR as <b>New Widget - ABCD widget</b>
  * In the description of your PR mention the link of the widget from the widget of the week playlist along with a brief explaination of your implementation.
  * Try to make your implementation as interactive as possible as it helps the user to make changes to the widget and observe the widget behaviour.
  * Add comments in the dart file as it helps me as well as others to easily understand your code.
  * Try to limit the contribution to a single commit.
* If the pull request is to change the formatting that does not directly affect the functionality of any of the widgets:
  * Please provide the title of your PR as <b>Formatting - ABCD widget.dart, XYZ widget.dart (name of the file(s))</b>
  * Please specify the exact reason for your changes and the need for the same in the description.
* Are you trying to file a bug?
  * Specify the title of you PR as <b> Bug Report - ABCD widget.dart (name of the file(s))</b>
  * Give a detailed explanation in the description.
  
Please reach out to me at - [Email](mailto:annsh29@gmail.com)  if you want to discuss something related to the project or just want to have a chat :smiley:
</br>Cheers :beers:
