/*
 * The MIT License
 *
 * *** Copyright © Long Zhang(kanch)
 * *** Email: kanchisme@gmail.com
 * *** Code created on Apr 19 2018
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package dbi.analyzer;

/**
 *
 * @author kanch
 */
public class ChartOption {

    public static String OPTION_HISTOGRAM = "option = {"
            + "        title : {"
            + "        text: '@TITLE',"
            + "        subtext: '@SUBTITLE',"
            + "        x:'center'"
            + "    },"
            + "    xAxis: {"
            + "        type: 'category',"
            + "        data: @XDATA"
            + "    },"
            + "    yAxis: {"
            + "        type: 'value'"
            + "    },"
            + "    series: [{"
            + "        data: @YDATA,"
            + "        type: 'bar'"
            + "    }]"
            + "};";

    public static String OPTION_LINE = "option = {"
            + "    title : {"
            + "        text: '@TITLE',"
            + "        subtext: '@SUBTITLE',"
            + "        x:'center'"
            + "    },"
            + "    xAxis: {"
            + "        type: 'category',"
            + "        data: @XDATA"
            + "    },"
            + "    yAxis: {"
            + "        type: 'value'"
            + "    },"
            + "    series: [{"
            + "        data: @YDATA,"
            + "        type: 'line'"
            + "    }]"
            + "};";

    public static String OPTION_PIE = "option = {"
            + "    title : {"
            + "        text: '@TITLE',"
            + "        subtext: '@SUBTITLE',"
            + "        x:'center'"
            + "    },"
            + "    tooltip : {"
            + "        trigger: 'item',"
            + "        formatter: \"{a} <br/>{b} : {c} ({d}%)\""
            + "    },"
            + "    legend: {"
            + "        orient: 'vertical',"
            + "        right: 10,"
            + "        top: 100,"
            + "        bottom: 20,"
            + "        data: [@XDATA]"
            + "    },"
            + "    series : ["
            + "        {"
            + "            name: '@INFO',"
            + "            type: 'pie',"
            + "            radius : '55%',"
            + "            center: ['50%', '60%'],"
            + "            data:["
            + "                @YDATA"
            + "            ],"
            + "            itemStyle: {"
            + "                emphasis: {"
            + "                    shadowBlur: 10,"
            + "                    shadowOffsetX: 0,"
            + "                    shadowColor: 'rgba(0, 0, 0, 0.5)'"
            + "                }"
            + "            }"
            + "        }"
            + "    ]"
            + "};";

    public static String OPTION_SCATTER_WITH_AVERAGE = "option = {"
            + "    title: {"
            + "        text: '@TITLE',"
            + "        subtext: '@SUBTITLE',"
            + "        x: 'center',"
            + "        y: 0"
            + "    },"
            + "    tooltip: {"
            + "        formatter: '@TOOLTIP {a}: ({c})'"
            + "    },"
            + "    xAxis: ["
            + "        {gridIndex: 0, min: 0, max: @XMAX},"
            + "    ],"
            + "    yAxis: ["
            + "        {gridIndex: 0, min: @YMIN, max: @YMAX},"
            + "    ],"
            + "    series: ["
            + "        {"
            + "            name: 'value',"
            + "            type: 'scatter',"
            + "            xAxisIndex: 0,"
            + "            yAxisIndex: 0,"
            + "            data:  ["
            + "                        @DATA"
            + "                    ],"
            + "            markLine: {"
            + "                            animation: true,"
            + "                            label: {"
            + "                                normal: {"
            + "                                    formatter: '@AVERAGE_TEXT',"
            + "                                    textStyle: {"
            + "                                        align: 'bottom'"
            + "                                    }"
            + "                                }"
            + "                            },"
            + "                            lineStyle: {"
            + "                                normal: {"
            + "                                    type: 'solid'"
            + "                                }"
            + "                            },"
            + "                            tooltip: {"
            + "                                formatter: '@AVERAGE_TEXT:@AVG_Y'"
            + "                            },"
            + "                            data: [[{"
            + "                                coord: [@AVG_X1, @AVG_Y],"
            + "                                symbol: 'none'"
            + "                            }, {"
            + "                                coord: [@AVG_X2, @AVG_Y],"
            + "                                symbol: 'none'"
            + "                            }]]"
            + "                        }"
            + "        }"
            + "    ]"
            + "};";

    public static String OPTION_HISTOGRAM_FULLAREA = "option = {"
            + "        title : {"
            + "        text: '@TITLE',"
            + "        subtext: '@SUBTITLE',"
            + "        x:'center'"
            + "    },"
            + "    xAxis: {"
            + "        type: 'category',"
            + "        boundaryGap: false,"
            + "        data: [@XDATA]"
            + "    },"
            + "    yAxis: {"
            + "        type: 'value'"
            + "    },"
            + "    series: [{"
            + "        data: [@YDATA],"
            + "        type: 'line',"
            + "        areaStyle: {}"
            + "    }]"
            + "};";

    public static String OPTION_TREEMAP = "option = {"
            + "    series: [{"
            + "        type: 'treemap',"
            + "        data: [@DATA]"
            + "    }]"
            + "};";

    public static String OPTION_COUNTM = "option = {"   ////app.title = '@TITLE';
            + "    tooltip: {"
            + "        trigger: 'item',"
            + "        formatter: \"{a} <br/>{b}: {c} ({d}%)\""
            + "    },"
            + "    legend: {"
            + "        orient: 'vertical',"
            + "        x: 'left',"
            + "        data:@LEGNED_DATA"
            + "    },"
            + "    series: [ @DATA"
            + "    ]"
            + "};";

    public static String OPTION_COUNTM_INNERCIRCLE = "        {"
            + "            name:'@TIP',"
            + "            type:'pie',"
            + "            selectedMode: 'single',"
            + "            radius: @RADIUS,"
            + ""
            + "            label: {"
            + "                normal: {"
            + "                    position: 'inner'"
            + "                }"
            + "            },"
            + "            labelLine: {"
            + "                normal: {"
            + "                    show: false"
            + "                }"
            + "            },"
            + "            data:[@YDATA]"
            + "        },";

    public static String OPTION_COUNTM_OUTERCIRCLE = "        {"
            + "            name:'@TIP',"
            + "            type:'pie',"
            + "            radius: @RADIUS,"
            + "            label: {"
            + "                normal: {"
            + "                    formatter: '{b|{b}: }{c}  {per|{d}%}  ',"
            + "                    backgroundColor: '#eee',"
            + "                    borderColor: '#aaa',"
            + "                    borderWidth: 1,"
            + "                    borderRadius: 4,"
            + "                    shadowOffsetY: 2,"
            + "                    shadowColor: '#999',"
            + "                    padding: [0, 7],"
            + "                    rich: {"
            + "                        b: {"
            + "                            fontSize: 16,"
            + "                            lineHeight: 33"
            + "                        },"
            + "                        per: {"
            + "                            color: '#eee',"
            + "                            backgroundColor: '#334455',"
            + "                            padding: [2, 4],"
            + "                            borderRadius: 2"
            + "                        }"
            + "                    }"
            + "                }"
            + "            },"
            + "            data:[@YDATA]"
            + "        },";

    public static String OPTION_TRENDM = "option = {"
            + "    title: {"
            + "        text: \"@TITLE\""
            + "    },"
            + "    tooltip : {"
            + "        trigger: 'axis',"
            + "        axisPointer: {"
            + "            type: 'cross',"
            + "            label: {"
            + "                backgroundColor: '#6a7985'"
            + "            }"
            + "        }"
            + "    },"
            + "    legend: {"
            + "        data:@LEGEND_DATA"
            + "    },"
            + "    toolbox: {"
            + "        feature: {"
            + "            saveAsImage: {}"
            + "        }"
            + "    },"
            + "    grid: {"
            + "        left: '3%',"
            + "        right: '4%',"
            + "        bottom: '3%',"
            + "        containLabel: true"
            + "    },"
            + "    xAxis : ["
            + "        {"
            + "            type : 'category',"
            + "            boundaryGap : false,"
            + "            data : @XDATA"
            + "        }"
            + "    ],"
            + "    yAxis : ["
            + "        {"
            + "            type : 'value'"
            + "        }"
            + "    ],"
            + "    series : ["
            + "    @YDATA ]"
            + "};";

    public static String OPTION_TRENDM_DATA_WITH_LABEL = "{"
            + "            name:'@NAME',"
            + "            type:'line',"
            + "            stack: '总量',"
            + "            label: {"
            + "                normal: {"
            + "                    show: true,"
            + "                    position: 'top'"
            + "                }"
            + "            },"
            + "            areaStyle: {normal: {}},"
            + "            data:@DATA"
            + "        }";

    public static String OPTION_TRENDM_DATA = "{"
            + "            name:'@NAME',"
            + "            type:'line',"
            + "            stack: '总量',"
            + "            areaStyle: {normal: {}},"
            + "            data:@DATA"
            + "        },";
}
