/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOConnectPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.TimeoutInterruptHandler;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class NSProtocolNIO
extends NSProtocol {
    private NIONSDataChannel probePacket;

    public NSProtocolNIO(boolean bl) {
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, true, bl);
    }

    @Override
    void negotiateConnection(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2) throws IOException, NetException {
        NIOConnectPacket nIOConnectPacket = new NIOConnectPacket(this.sAtts);
        NVPair nVPair = null;
        String string = null;
        block13: while (true) {
            Object object;
            String string2;
            IOException iOException = null;
            NIOPacket nIOPacket = null;
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            try {
                nIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !bl, bl2, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
                nIOPacket = NIOPacket.readNIOPacket(this.sAtts);
                n2 = nIOPacket.header.type;
            }
            catch (InterruptedIOException interruptedIOException) {
                string2 = String.format("%s, connect lapse %d ms.", interruptedIOException.getMessage(), System.currentTimeMillis() - l2);
                object = new IOException(string2, interruptedIOException);
                throw object;
            }
            catch (IOException iOException2) {
                n2 = 4;
                string2 = String.format("%s, connect lapse %d ms.", iOException2.getMessage(), System.currentTimeMillis() - l2);
                object = new IOException(string2, iOException2);
                iOException = object;
            }
            switch (n2) {
                case 2: {
                    NIOAcceptPacket nIOAcceptPacket = (NIOAcceptPacket)nIOPacket;
                    this.sAtts.setNegotiatedSDUAndTDU(nIOAcceptPacket.sduSize, nIOAcceptPacket.tduSize);
                    this.sAtts.setNegotiatedOptions(nIOAcceptPacket.options);
                    this.sAtts.setConnectData(nIOAcceptPacket.connectData);
                    break block13;
                }
                case 5: {
                    NIORedirectPacket nIORedirectPacket = (NIORedirectPacket)nIOPacket;
                    ConnOption connOption = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    string2 = nIORedirectPacket.redirectData;
                    object = null;
                    if ((nIORedirectPacket.header.flags & 2) == 2 && nIORedirectPacket.redirectData.indexOf(0) != -1) {
                        string2 = nIORedirectPacket.redirectData.substring(0, nIORedirectPacket.redirectData.indexOf(0));
                        this.sAtts.redirecting = true;
                        object = nIORedirectPacket.redirectData.substring(nIORedirectPacket.redirectData.indexOf(0) + 1, nIORedirectPacket.redirectData.length());
                    }
                    this.establishConnection(string2);
                    this.sAtts.cOption.restoreFromOrigCoption(connOption);
                    if (!this.sAtts.redirecting) continue block13;
                    this.sAtts.cOption.conn_data.setLength(0);
                    this.sAtts.cOption.conn_data.append((String)object);
                    break;
                }
                case 4: {
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                    if (interruptTask != null && interruptTask.isInterrupted()) {
                        Thread.interrupted();
                    }
                    try {
                        this.establishConnection(null, true);
                    }
                    catch (NetException netException) {
                        // empty catch block
                    }
                    if (this.sAtts.cOption != null) continue block13;
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (nIOPacket != null) {
                        NIORefusePacket nIORefusePacket = (NIORefusePacket)nIOPacket;
                        try {
                            NVPair nVPair2;
                            nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(nIORefusePacket.refuseData), "ERROR");
                            if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "CODE")) != null) {
                                string = nVPair2.valueToString();
                            }
                        }
                        catch (NLException nLException) {
                        }
                        throw new NetException(string == null ? 206 : Integer.parseInt(string), "");
                    }
                }
                case 11: {
                    if ((nIOPacket.header.flags & 8) != 8) continue block13;
                    this.sAtts.renegotiateSSLSession();
                    break;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
        }
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.sAtts.dataChannel.writeDataToSocketChannel();
        boolean bl = false;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            if (i2 >= 1703910) {
                n4 = 1703910;
            } else {
                n4 = i2;
                bl = true;
            }
            this.sAtts.ddPacket.writeToSocketChannel(n4, bl);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n4);
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.write(byteBuffer);
            }
            n2 += n4;
        }
    }

    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException {
        int n3;
        boolean bl = false;
        this.sAtts.ddPacket.readFromSocketChannel(true);
        this.sAtts.ddPacket.readPayloadBuffer();
        int n4 = this.sAtts.ddPacket.totalDataLength;
        if ((this.sAtts.ddPacket.descriptorFLaG & 1) != 0) {
            bl = true;
        }
        if (byArray.length < n2 + n4) {
            throw new IOException("Assertion Failed");
        }
        ByteBuffer byteBuffer = this.sAtts.buffer;
        for (n3 = 0; n3 < n4; n3 += byteBuffer.limit()) {
            byteBuffer.clear();
            byteBuffer.limit(Math.min(byteBuffer.capacity(), n4 - n3));
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.read(byteBuffer);
            }
            byteBuffer.rewind();
            byteBuffer.get(byArray, n2 + n3, byteBuffer.limit());
        }
        nArray[0] = n3;
        return bl;
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.dataChannel.sendEOF();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(1, (byte)2);
        while (this.sAtts.onBreakReset) {
            this.sAtts.markerPacket.readFromSocketChannel(true, false);
            this.sAtts.markerPacket.readPayloadBuffer();
            if (!this.sAtts.markerPacket.isResetPkt()) continue;
            this.sAtts.onBreakReset = false;
        }
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public InputStream getInputStream() throws NetException, IOException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public OutputStream getOutputStream() throws NetException, IOException {
        return this.getNetOutputStream();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.socketChannel = this.sAtts.nt.getSocketChannel();
        this.sAtts.initializeBuffer(this.sAtts.getSDU());
    }

    @Override
    protected void sendMarker(int n2, byte by) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sAtts.markerPacket.writeToSocketChannel(n2, by);
    }

    @Override
    void sendProbePacket() throws IOException {
        if (this.probePacket == null) {
            this.probePacket = new NIONSDataChannel(this.sAtts);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        byte[] byArray = new byte[26];
        this.probePacket.writeDataToSocketChannel(byArray);
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

