/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public final class NIODataDescriptorPacket
extends NIOPacket
implements SQLnetDef {
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd = new int[26];
    boolean useLongDescriptor = false;
    private static final byte[] STANDARD_SDD_MAX_DD = new byte[]{0, 72, 0, 0, 15, 0, 0, 0, 0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    NIODataDescriptorPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 15;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        ByteOrder byteOrder = this.session.buffer.order();
        this.session.buffer.order(ByteOrder.BIG_ENDIAN);
        this.descriptorFLaG = this.session.payloadBuffer.getInt();
        this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
        this.totalDataLength = this.session.payloadBuffer.getInt();
        this.session.buffer.order(byteOrder);
    }

    final void writeToSocketChannel(int n2, boolean bl) throws IOException {
        if (n2 == 1703910 && !bl) {
            this.session.buffer.clear();
            this.session.buffer.put(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length);
            this.session.buffer.rewind();
            while (this.session.buffer.hasRemaining()) {
                this.session.socketChannel.write(this.session.buffer);
            }
        } else {
            int n3;
            this.useLongDescriptor = false;
            this.descriptorFLaG = 2;
            if (bl) {
                this.descriptorFLaG |= 1;
            }
            int n4 = 0;
            int n5 = n2;
            while (n5 > 0) {
                this.sdd[n4] = n5 > 65535 ? 65535 : n5;
                n5 -= this.sdd[n4];
                ++n4;
            }
            this.session.payloadBuffer.clear();
            this.session.payloadBuffer.putInt(this.descriptorFLaG);
            this.session.payloadBuffer.putInt(n2);
            this.session.payloadBuffer.putInt(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                this.session.payloadBuffer.putShort((short)this.sdd[n3]);
            }
            for (n3 = n4; n3 < 26; ++n3) {
                this.session.payloadBuffer.putShort((short)0);
            }
            this.writeToSocketChannel();
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

