# FireJSX 🔥

**The React Framework for SSB, SSR and Serverless technologies**

FireJSX is the framework required by modern react developers 😎 to build great sites with ease. 

FireJSX allows you to build **professional** static/dynamic websites with no limitations whatsoever. FireJSX sites are fully functional React apps, allowing you to create high-quality, dynamic/static web apps, from blogs to e-commerce sites to user dashboards.

FireJSX handles page preloading, builds optimised chunks, grows with you using powerful plugin API, saves your sweet-sweet money💰 because FireJSX sites are very-very efficient and cheap to host. Go Serverless, SSR or just dump your SSB to an S3 bucket. There is no limit to what you can do with FireJSX.

Excited to learn more?

Visit the [quick start](https://github.com/eAdded/FireJSX/wiki/Quick-Start) guide to get your site spinning within a minute.

## How is it different ? 👽

+ Server Side Render with maximum of 3 lines of code. No need to fake an express server.

+ Lightning fast rendering with latency as low as 3ms.

+ Portable code. Export for fly builds once. Run it any-where. No need to carry node_modules around. Reduced cold start
  time.

+ 0 overhead, means smaller bundle sizes and faster apps. Bundle sizes smaller by at least 100kb when compared to other
  frameworks.

+ Dev Friendly. Low build time through build time caching.

+ Advance caching mechanism ensures lightning fast routing.

+ Made with the thought of Long term caching for fast cdn delivery

+ Easily pull in data from any data source and pass it to your page with no confusing and buggy `getInitialProps`
  or getServerSideProps. Moreover, you don't need to learn any extra technology such as `GraphQL` or worry about
  efficiency and code spitting.

+ Customizable. Customize the framework to your liking.

+ Scalable. Grow feature set using easy to write plugins.

+ Easy to use node interface. You are not limited to the cli interface anymore.

+ Modern. Made with serverless technological services in mind.

Read more [here](https://webbuddy360.com/AniketFuryRocks/The%202021%20web%20development%20stack)

## Who is using FireJSX ? 🤩

+ [WB360](https://webbuddy360.com)
+ [AlokProducts.com](https://alokproducts.com)

## Documentation 📚

Documentation is available at the official [FireJSX Github Wiki](https://github.com/eAdded/FireJSX/wiki)

## Special Thanks 🙏

<p>
<img align="left" height="150px" width="150px" src="jetbrains.svg"/>
<br/>
<p>
We want to thank <a href="https://www.jetbrains.com/?from=FireJSX"><b>JetBrains</b></a><br/> for providing us a<br/><b>Free JetBrains Open Source license</b>
</p>
</p>
<br/>

## Code of conduct

Code of conduct can be found at **[CODE_OF_CONDUCT.md](CODE_OF_CONDUCT.md)**

## Contributing

Make sure to read **[Contribution Guidelines](CONTRIBUTING.md)** before contributing.

Need help with :

1. Documentation
2. React Error Overlay design
3. Webpack 5 and React Fast Refresh Integration

Free feel to help, contact maintainer if necessary.

## License & Copyright

Copyright (C) 2020 Aniket Prajapati

Licensed under the **[GNU GENERAL PUBLIC LICENSE](LICENSE)**

## Contributors

+ [Aniket Prajapati](https://github.com/aniketfuryrocks)
  @[prajapati.ani306@gmail.com](mailto:prajapati.ani306@gmail.com) , [eAdded](http://www.eadded.com) (MAINTAINER)
