<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Umum Sistem Informasi Bebas Tanggungan Tugas Akhir Jurusan Teknologi Informasi</title>
    <style>
        * {
            font-family: 'Times New Roman', Times, serif;
        }

        h1 {
            font-size: 16px;
        }

        #letterhead {
            text-align: center;
            border-bottom: 3px solid black;
            padding-bottom: 10px;
            height: auto;
        }

        #img-container {
            height: 180px;
            float: left;
            margin-right: 50px;
        }

        #letterhead img {
            width: 100px;
            height: auto;
        }

        #letterhead-title {
            text-align: center;
        }

        .content {
            margin-top: 20px;
        }

        .formal-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-family: Arial, sans-serif;
        }

        .formal-table th,
        .formal-table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        .formal-table th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
        }

        .formal-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .formal-table tr:hover {
            background-color: #ddd;
        }

        .formal-table {
            border: 2px solid #4CAF50;
            border-radius: 8px;
        }

        .signature {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div id="letterhead">
        <div id="img-container">
            <img src="data:image/png;base64,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"
                alt="School Logo">
        </div>
        <div id="letterhead-title">
            <h1 style="font-weight: normal; font-size: inherit;">KEMENTERIAN PENDIDIKAN, KEBUDAYAAN, <br>RISET, DAN
                TEKNOLOGI</h1>
            <h1 style="font-weight: normal; font-size: inherit;">POLITEKNIK NEGERI MALANG</h1>
            <h1 style="font-size: inherit;">PROGRAM STUDI TEKNIK INFORMATIKA <br>JURUSAN TEKNOLOGI INFORMASI</h1>
            <p style="font-size: inherit;">Jl. Soekarno Hatta No.9 Jatimulyo, Lowokwaru, Malang, 65141</p>
            <p style="font-size: inherit;">Telp. (0341) 404424 - 404425, Fax (0341) 404420,</p>
            <p style="font-size: inherit;">http://www.polinema.ac.id</p>
        </div>
    </div>

    <div class="content">
        <h1 style="text-align: center;">LAPORAN UMUM BEBAS TANGGUNGAN TUGAS AKHIR <br>PERIODE 2024</h1>

        <p>Berdasarkan data yang diperoleh pada sistem bebas tanggungan tugas akhir "FINALIS JTI" selama satu tahun
            terakhir, didapatkan data yang bisa dirangkum sebagai berikut:</p>

        <table class="formal-table">
            <thead>
                <tr>
                    <th rowspan="2">Kategori</th>
                    <th colspan="3" style="text-align: center;">Total</th>
                </tr>
                <tr>
                    <th>D4 TI</th>
                    <th>D4 SIB</th>
                    <th>D2 PPLS</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Jumlah mahasiswa yang telah melunasi tanggungan tugas akhir</td>
                    <td><?= $data['d4_ti']['lunas'] ?></td>
                    <td><?= $data['d4_sib']['lunas'] ?></td>
                    <td><?= $data['d2_ppls']['lunas'] ?></td>
                </tr>
                <tr>
                    <td>Jumlah mahasiswa yang belum melunasi tanggungan tugas akhir</td>
                    <td><?= $data['d4_ti']['belum_lunas'] ?></td>
                    <td><?= $data['d4_sib']['belum_lunas'] ?></td>
                    <td><?= $data['d2_ppls']['belum_lunas'] ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="signature">
        <p>Mengetahui,</p>
        <?php $fmt = new IntlDateFormatter('id_ID', IntlDateFormatter::LONG, IntlDateFormatter::NONE); ?>
        <p>Malang, <?= $fmt->format(new DateTime()) ?></p>
        <p>Admin Jurusan Teknologi Informasi</p>
        <br><br><br>
        <p><u>Danin, S.AP.</u><br>NIP: 1234567890</p>
    </div>
</body>

</html>