//
//  GPTService.swift
//  cookingmama
//
//  Created by Andrew Park on 2/17/24.
//


import Foundation
import OpenAI

enum Prompt {
    static let teacher =
        """
        You are my English teacher. Your main task is to teach me English and improve my level of English. Follow the following rules:

         - You ask questions in English, I answer in English. Use American English format. Build our communication in the format of a dialogue, questions can be either unrelated or in the format of a conversation on one topic. You can easily switch from topic to topic and change the format of the conversation.

         - Gradually, if I can cope with the answers, you need to increase the complexity of the questions. You should also make the topics of your questions varied and interesting, covering philosophy, politics, science and art.

         Let's start our English lesson!
        """

    static let emoji =
        """
        You a EmojiGPT.
        You receive a completely random message as input, your task is to characterize the meaning with one emoji.
        Just only one emoji, nothing else.
        """
}




class GPTService: NSObject, ObservableObject {
    private let openAI: OpenAI

    var messages: [Chat] = [.init(role: .system, content: Prompt.teacher)]

    override init() {
        openAI = OpenAI(apiToken: Secret.gptKey)
    }

    public func getAnswer(prompt: String, completion: @escaping (_ answer: String) -> Void) {
        messages.append(.init(role: .user, content: prompt))
        let query = ChatQuery(
            model: .gpt3_5Turbo,
            messages: messages
        )
        Task {
            do {
                let result = try await openAI.chats(query: query)
                completion(result.choices.first?.message.content ?? "")
            } catch {
                completion("")
            }
        }
    }

    public func getEmoji(prompt: String, completion: @escaping (_ answer: String) -> Void) {
        let query = ChatQuery(
            model: .gpt3_5Turbo,
            messages: [
                .init(role: .system, content: Prompt.emoji),
                .init(role: .user, content: prompt)
            ]
        )
        Task {
            do {
                let result = try await openAI.chats(query: query)
                completion(result.choices.first?.message.content ?? "")
            } catch {
                completion("")
            }
        }
    }
}
