
import Foundation

// Define a struct to match the JSON response structure
struct RecipeResponse: Decodable {
    let success: Bool
    let generatedRecipe: String
    let ingredients: String
    let instacartAndShoppingList: [ShoppingItem]

    enum CodingKeys: String, CodingKey {
        case success
        case generatedRecipe = "generated_recipe"
        case ingredients
        case instacartAndShoppingList = "instacart_and_shopping_list"
    }

    struct ShoppingItem: Decodable {
        let item: String
        let store: String
        let price: String
    }
}

extension RecipeResponse {
//    Computed Property
    func recipeTranscript(text: String) -> String {
       return "Here's your order for the \(text).. \(ingredients) "
    }
}

// Example mock data for SwiftUI preview or testing
extension RecipeResponse {
    static var example: RecipeResponse {
        return RecipeResponse(
            success: true,
            generatedRecipe: "Chocolate banana pizza minutes to make: 40 ingredients: 1. chocolate graham cracker crumbs 2. unsalted butter 3. semi-sweet chocolate chips 4. bananas 5. chocolate syrup 6. sliced almonds steps: 1. preheat oven to 350F 2. melt butter in a 9-inch pie pan in a microwave or on the stovetop 3. stir in graham cracker crumbs, and press onto bottom and up sides of pie pan 4. bake for 10 minutes, cool completely 5. in a double boiler or a large metal bowl set over a saucepan of simmering water, melt chocolate chips, stirring frequently until melted and smooth 6. remove from heat 7. peel bananas, cut in half lengthwise, and cut each half into 3 long pieces 8. arrange banana slices in concentric circles over the crust 9. pour melted chocolate over banana slices, spreading to cover evenly",
            ingredients: "chocolate graham cracker crumbs, unsalted butter, semi-sweet chocolate chips, bananas, chocolate syrup, sliced almonds",
            instacartAndShoppingList: [
                ShoppingItem(item: "Nice! Wafer Bites Chocolate - 7.05 oz", store: "Walgreens.com", price: "$1.29"),
                ShoppingItem(item: "Nice! Almonds Unsalted - 1.5 oz", store: "Walgreens.com", price: "$0.99"),
                ShoppingItem(item: "Imperial Spread Sticks Regular 16 oz", store: "Target", price: "$1.99"),
                ShoppingItem(item: "Banana - each - Good & Gather", store: "Target", price: "$0.35"),
                ShoppingItem(item: "Nestle Nesquik Low Fat Milk, Double Chocolate - 14 fl oz bottle", store: "Walmart", price: "$1.76"),
                ShoppingItem(item: "Kars PB'n Dark Chocolate - 2 oz", store: "Ace Hardware", price: "$1.79")
            ]
        )
    }
}


// Define a struct to perform the network request
struct RecipeFetcher {
    static func fetchRecipe(forFood desiredFood: String) async throws -> RecipeResponse {
        let endpoint = URL(string: "https://eohr4l2odp1g8eo.m.pipedream.net")!
        var request = URLRequest(url: endpoint)
        request.httpMethod = "POST"
        request.addValue("application/json", forHTTPHeaderField: "Content-Type")
        request.httpBody = try? JSONEncoder().encode(["desiredFood": desiredFood])

        let (data, response) = try await URLSession.shared.data(for: request)
        guard let httpResponse = response as? HTTPURLResponse, httpResponse.statusCode == 200 else {
            throw URLError(.badServerResponse)
        }

        return try JSONDecoder().decode(RecipeResponse.self, from: data)
    }
}

