# Contributing to Serialized Search and Replace

This document contains basic guidelines to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## Pull requests are actively welcomed

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
5. Make sure your code lints.
6. Issue your pull request.

## Any contributions you make will be under the MIT Software License

In short, when you submit code changes, your submissions are understood to be under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the project.

## Report bugs using [issues](https://github.com/andreekeberg/serialized-search-replace/issues)

All bugs are tracked using GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/andreekeberg/serialized-search-replace/issues/new); it's that easy!

## Write bug reports with detail, background, and sample code

**Great bug reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
  - What you expected would happen
  - What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

## Use a Consistent Coding Style

All code should follow the [PSR-12: Extended Coding Style](https://www.php-fig.org/psr/psr-12/)

* 4 spaces for indentation rather than tabs
* Newlines after opening curly brackets in classes and methods

## License

By contributing to Serialized Search and Replace, you agree that your contributions will be licensed under its MIT License.
