/*!
 * phaser-input - version 2.0.2 
 * Adds input boxes to Phaser like CanvasInput, but also works for WebGL and Mobile, made for Phaser only.
 *
 * OrangeGames
 * Build at 27-01-2017
 * Released under MIT License 
 */

var __extends=this&&this.__extends||function(a,b){function c(){this.constructor=a}for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d]);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)},PhaserInput;!function(a){var b;!function(a){a[a.text=0]="text",a[a.password=1]="password",a[a.number=2]="number"}(b=a.InputType||(a.InputType={}));var c=function(){function a(a,c,d,e){void 0===d&&(d=b.text),void 0===e&&(e="");var f=this;this.focusIn=new Phaser.Signal,this.focusOut=new Phaser.Signal,this.id=c,this.type=d,this.game=a;var g=this.game.canvas.getBoundingClientRect().top+document.body.scrollTop;this.element=document.createElement("input"),this.element.id=c,this.element.style.position="absolute",this.element.style.top=g+"px",this.element.style.left=(-40).toString()+"px",this.element.style.width=10..toString()+"px",this.element.style.height=10..toString()+"px",this.element.style.border="0px",this.element.value=this.value,this.element.type=b[d],this.element.addEventListener("focusin",function(){f.focusIn.dispatch()}),this.element.addEventListener("focusout",function(){f.focusOut.dispatch()}),document.body.appendChild(this.element)}return a.prototype.addKeyUpListener=function(a){this.callback=a,document.addEventListener("keyup",this.callback)},a.prototype.blockKeyDownEvents=function(){document.addEventListener("keydown",this.preventKeyPropagation)},a.prototype.preventKeyPropagation=function(a){a.stopPropagation?a.stopPropagation():event.cancelBubble=!0},a.prototype.unblockKeyDownEvents=function(){document.removeEventListener("keydown",this.preventKeyPropagation)},a.prototype.removeEventListener=function(){document.removeEventListener("keyup",this.callback)},a.prototype.destroy=function(){document.body.removeChild(this.element)},a.prototype.setMax=function(a,c){if(void 0!==a)if(this.type===b.text||this.type===b.password)this.element.maxLength=parseInt(a,10);else if(this.type===b.number){if(this.element.max=a,void 0===c)return;this.element.min=c}},Object.defineProperty(a.prototype,"value",{get:function(){return this.element.value},set:function(a){this.element.value=a},enumerable:!0,configurable:!0}),a.prototype.focus=function(){var a=this;if(this.element.focus(),!this.game.device.desktop&&this.game.device.chrome)var b=window.innerWidth,c=window.innerHeight,d=!1,e=setInterval(function(){(b>window.innerWidth||c>window.innerHeight)&&(d=!0),d&&b===window.innerWidth&&c===window.innerHeight&&(a.focusOut.dispatch(),clearInterval(e))},50)},a.prototype.blur=function(){this.element.blur()},Object.defineProperty(a.prototype,"hasSelection",{get:function(){return this.type===b.number?!1:this.element.selectionStart!==this.element.selectionEnd},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"caretStart",{get:function(){return this.element.selectionEnd},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"caretEnd",{get:function(){return this.element.selectionStart},enumerable:!0,configurable:!0}),a.prototype.getCaretPosition=function(){return this.type===b.number?-1:this.element.selectionStart},a.prototype.setCaretPosition=function(a){this.type!==b.number&&this.element.setSelectionRange(a,a)},a}();a.InputElement=c}(PhaserInput||(PhaserInput={}));var PhaserInput;!function(a){var b=function(b){function c(c,d,e,f){void 0===f&&(f={});var g=b.call(this,c,d,e)||this;return g.focusOutOnEnter=!0,g.placeHolder=null,g.box=null,g.focus=!1,g.value="",g.windowScale=1,g.blockInput=!0,g.blink=!0,g.cnt=0,g.inputOptions=f,g.inputOptions.width="number"==typeof f.width?f.width:150,g.inputOptions.padding="number"==typeof f.padding?f.padding:0,g.inputOptions.textAlign=f.textAlign||"left",g.inputOptions.type=f.type||a.InputType.text,g.inputOptions.borderRadius="number"==typeof f.borderRadius?f.borderRadius:0,g.inputOptions.height="number"==typeof f.height?f.height:14,g.inputOptions.fillAlpha=void 0===f.fillAlpha?1:f.fillAlpha,g.inputOptions.selectionColor=f.selectionColor||"rgba(179, 212, 253, 0.8)",g.inputOptions.zoom=c.device.desktop?!1:f.zoom||!1,g.box=new a.InputBox(g.game,f),g.setTexture(g.box.generateTexture()),g.textMask=new a.TextMask(g.game,f),g.addChild(g.textMask),g.domElement=new a.InputElement(g.game,"phaser-input-"+(1e4*Math.random()|0).toString(),g.inputOptions.type,g.value),g.domElement.setMax(g.inputOptions.max,g.inputOptions.min),g.selection=new a.SelectionHighlight(g.game,g.inputOptions),g.selection.mask=g.textMask,g.addChild(g.selection),f.placeHolder&&f.placeHolder.length>0&&(g.placeHolder=new Phaser.Text(c,g.inputOptions.padding,g.inputOptions.padding,f.placeHolder,{font:f.font||"14px Arial",fontWeight:f.fontWeight||"normal",fill:f.placeHolderColor||"#bfbebd"}),g.placeHolder.mask=g.textMask,g.addChild(g.placeHolder)),g.cursor=new Phaser.Text(c,g.inputOptions.padding,g.inputOptions.padding-2,"|",{font:f.font||"14px Arial",fontWeight:f.fontWeight||"normal",fill:f.cursorColor||"#000000"}),g.cursor.visible=!1,g.addChild(g.cursor),g.text=new Phaser.Text(c,g.inputOptions.padding,g.inputOptions.padding,"",{font:f.font||"14px Arial",fontWeight:f.fontWeight||"normal",fill:f.fill||"#000000"}),g.text.mask=g.textMask,g.addChild(g.text),g.offscreenText=new Phaser.Text(c,g.inputOptions.padding,g.inputOptions.padding,"",{font:f.font||"14px Arial",fontWeight:f.fontWeight||"normal",fill:f.fill||"#000000"}),g.updateTextAlignment(),g.inputEnabled=!0,g.input.useHandCursor=!0,g.game.input.onDown.add(g.checkDown,g),g.domElement.focusOut.add(function(){a.KeyboardOpen&&(g.endFocus(),g.inputOptions.zoom&&g.zoomOut())}),g}return __extends(c,b),Object.defineProperty(c.prototype,"width",{get:function(){return this.inputOptions.width},set:function(a){this.inputOptions.width=a,this.box.resize(a),this.textMask.resize(a),this.updateTextAlignment()},enumerable:!0,configurable:!0}),c.prototype.updateTextAlignment=function(){switch(this.inputOptions.textAlign){case"left":this.text.anchor.set(0,0),this.text.x=this.inputOptions.padding,null!==this.placeHolder&&this.placeHolder.anchor.set(0,0),this.cursor.x=this.inputOptions.padding+this.getCaretPosition();break;case"center":this.text.anchor.set(.5,0),this.text.x=this.inputOptions.padding+this.inputOptions.width/2,null!==this.placeHolder&&(this.placeHolder.anchor.set(.5,0),this.placeHolder.x=this.inputOptions.padding+this.inputOptions.width/2),this.cursor.x=this.inputOptions.padding+this.inputOptions.width/2-this.text.width/2+this.getCaretPosition();break;case"right":this.text.anchor.set(1,0),this.text.x=this.inputOptions.padding+this.inputOptions.width,null!==this.placeHolder&&(this.placeHolder.anchor.set(1,0),this.placeHolder.x=this.inputOptions.padding+this.inputOptions.width),this.cursor.x=this.inputOptions.padding+this.inputOptions.width}},c.prototype.checkDown=function(b){if(this.value||this.resetText(),this.input.checkPointerOver(b)){if(this.focus)return void this.setCaretOnclick(b);this.inputOptions.zoom&&!a.Zoomed&&this.zoomIn(),this.startFocus()}else this.focus===!0&&(this.endFocus(),this.inputOptions.zoom&&this.zoomOut())},c.prototype.update=function(){if(this.focus){if(30!==this.cnt)return this.cnt++;this.cursor.visible=this.blink,this.blink=!this.blink,this.cnt=0}},c.prototype.endFocus=function(){var b=this;this.focus&&(this.domElement.removeEventListener(),this.blockInput===!0&&this.domElement.unblockKeyDownEvents(),this.focus=!1,0===this.value.length&&null!==this.placeHolder&&(this.placeHolder.visible=!0),this.cursor.visible=!1,this.game.device.desktop?setTimeout(function(){b.domElement.blur()},0):this.domElement.blur(),this.game.device.desktop||(a.KeyboardOpen=!1,a.onKeyboardClose.dispatch()))},c.prototype.startFocus=function(){var b=this;this.focus=!0,null!==this.placeHolder&&(this.placeHolder.visible=!1),this.game.device.desktop?setTimeout(function(){b.keyUpProcessor()},0):this.keyUpProcessor(),this.game.device.desktop||(a.KeyboardOpen=!0,a.onKeyboardOpen.dispatch())},c.prototype.keyUpProcessor=function(){this.domElement.addKeyUpListener(this.keyListener.bind(this)),this.domElement.focus(),this.blockInput===!0&&this.domElement.blockKeyDownEvents()},c.prototype.updateText=function(){var b="";if(this.inputOptions.type===a.InputType.password)for(var c=0;c<this.value.length;c++)b+="*";else if(this.inputOptions.type===a.InputType.number){var d=parseInt(this.value);b=d<parseInt(this.inputOptions.min)?this.value=this.domElement.value=this.inputOptions.min:d>parseInt(this.inputOptions.max)?this.value=this.domElement.value=this.inputOptions.max:this.value}else b=this.value;if(this.text.setText(b),this.text.width>this.inputOptions.width)this.text.anchor.x=1,this.text.x=this.inputOptions.padding+this.inputOptions.width;else switch(this.inputOptions.textAlign){case"left":this.text.anchor.set(0,0),this.text.x=this.inputOptions.padding;break;case"center":this.text.anchor.set(.5,0),this.text.x=this.inputOptions.padding+this.inputOptions.width/2;break;case"right":this.text.anchor.set(1,0),this.text.x=this.inputOptions.padding+this.inputOptions.width}},c.prototype.updateCursor=function(){if(this.text.width>this.inputOptions.width||"right"===this.inputOptions.textAlign)this.cursor.x=this.inputOptions.padding+this.inputOptions.width;else switch(this.inputOptions.textAlign){case"left":this.cursor.x=this.inputOptions.padding+this.getCaretPosition();break;case"center":this.cursor.x=this.inputOptions.padding+this.inputOptions.width/2-this.text.width/2+this.getCaretPosition()}},c.prototype.getCaretPosition=function(){var b=this.domElement.getCaretPosition();if(-1===b)return this.text.width;var c=this.value;if(this.inputOptions.type===a.InputType.password){c="";for(var d=0;d<this.value.length;d++)c+="*"}return this.offscreenText.setText(c.slice(0,b)),this.offscreenText.width},c.prototype.setCaretOnclick=function(a){var b=this.text.toLocal(new PIXI.Point(a.x,a.y),this.game.world).x;this.inputOptions.textAlign&&"center"===this.inputOptions.textAlign&&(b+=this.text.width/2);for(var c=this.text.width/this.value.length,d=0,e=0;e<this.value.length;e++)if(b>=e*c&&(e+1)*c>=b){d=e;break}b>(this.value.length-1)*c&&(d=this.value.length),this.startFocus(),this.domElement.setCaretPosition(d),this.updateCursor()},c.prototype.updateSelection=function(){if(this.domElement.hasSelection){var b=this.value;if(this.inputOptions.type===a.InputType.password){b="";for(var c=0;c<this.value.length;c++)b+="*"}switch(b=b.substring(this.domElement.caretStart,this.domElement.caretEnd),this.offscreenText.setText(b),this.selection.updateSelection(this.offscreenText.getBounds()),this.inputOptions.textAlign){case"left":this.selection.x=this.inputOptions.padding;break;case"center":this.selection.x=this.inputOptions.padding+this.inputOptions.width/2-this.text.width/2}}else this.selection.clear()},c.prototype.zoomIn=function(){if(!a.Zoomed){var b=this.getBounds();window.innerHeight>window.innerWidth?this.windowScale=this.game.width/(1.5*b.width):this.windowScale=this.game.width/2/(1.5*b.width);var c=(this.game.width-1.5*b.width)/2/this.windowScale;this.game.world.scale.set(this.game.world.scale.x*this.windowScale,this.game.world.scale.y*this.windowScale),this.game.world.pivot.set(b.x-c,b.y-2*this.inputOptions.padding),a.Zoomed=!0}},c.prototype.zoomOut=function(){a.Zoomed&&(this.game.world.scale.set(this.game.world.scale.x/this.windowScale,this.game.world.scale.y/this.windowScale),this.game.world.pivot.set(0,0),a.Zoomed=!1)},c.prototype.keyListener=function(a){return this.value=this.domElement.value,13===a.keyCode?void(this.focusOutOnEnter&&this.endFocus()):(this.updateText(),this.updateCursor(),this.updateSelection(),void a.preventDefault())},c.prototype.destroy=function(a){this.game.input.onDown.remove(this.checkDown,this),this.domElement.focusIn.removeAll(),this.domElement.focusOut.removeAll(),this.domElement.destroy(),b.prototype.destroy.call(this,a)},c.prototype.resetText=function(){this.setText()},c.prototype.setText=function(a){void 0===a&&(a=""),null!==this.placeHolder&&(a.length>0?this.placeHolder.visible=!1:this.placeHolder.visible=!0),this.value=a,this.domElement.value=this.value,this.updateText(),this.updateCursor(),this.endFocus()},c}(Phaser.Sprite);a.InputField=b}(PhaserInput||(PhaserInput={}));var PhaserInput;!function(a){var b=function(a){function b(b,c){var d=a.call(this,b,0,0)||this;d.bgColor=c.backgroundColor?parseInt(c.backgroundColor.slice(1),16):16777215,d.borderRadius=c.borderRadius||0,d.borderWidth=c.borderWidth||1,d.borderColor=c.borderColor?parseInt(c.borderColor.slice(1),16):9803157,d.boxAlpha=c.fillAlpha,d.padding=c.padding;var e,e=c.height,f=c.width;c.font&&(e=Math.max(parseInt(c.font.substr(0,c.font.indexOf("px")),10),e)),d.boxHeight=2*d.padding+e;var f=c.width;return d.boxWidth=2*d.padding+f,d.drawBox(),d}return __extends(b,a),b.prototype.resize=function(a){this.boxWidth=2*this.padding+a,this.drawBox()},b.prototype.drawBox=function(){this.clear().beginFill(this.bgColor,this.boxAlpha).lineStyle(this.borderWidth,this.borderColor,this.boxAlpha),this.borderRadius>0?this.drawRoundedRect(0,0,this.boxWidth,this.boxHeight,this.borderRadius):this.drawRect(0,0,this.boxWidth,this.boxHeight)},b}(Phaser.Graphics);a.InputBox=b}(PhaserInput||(PhaserInput={}));var PhaserInput;!function(a){var b=function(a){function b(b,c){var d=a.call(this,b,c.padding,c.padding)||this;return d.inputOptions=c,d}return __extends(b,a),b.prototype.updateSelection=function(a){var c=Phaser.Color.webToColor(this.inputOptions.selectionColor);this.clear(),this.beginFill(b.rgb2hex(c),c.a),this.drawRect(a.x,a.y,a.width,a.height-this.inputOptions.padding)},b.rgb2hex=function(a){return parseInt(("0"+a.r.toString(16)).slice(-2)+("0"+a.g.toString(16)).slice(-2)+("0"+a.b.toString(16)).slice(-2),16)},b}(Phaser.Graphics);a.SelectionHighlight=b}(PhaserInput||(PhaserInput={}));var PhaserInput;!function(a){var b=function(a){function b(b,c){var d=a.call(this,b,c.padding,c.padding)||this,e=c.height;return c.font&&(e=Math.max(parseInt(c.font.substr(0,c.font.indexOf("px")),10),e)),d.maskWidth=c.width,d.maskHeight=1.3*e,d.drawMask(),d}return __extends(b,a),b.prototype.resize=function(a){this.maskWidth=a,this.drawMask()},b.prototype.drawMask=function(){this.clear().beginFill(0).drawRect(0,0,this.maskWidth,this.maskHeight).endFill()},b}(Phaser.Graphics);a.TextMask=b}(PhaserInput||(PhaserInput={}));var PhaserInput;!function(a){a.Zoomed=!1,a.KeyboardOpen=!1,a.onKeyboardOpen=new Phaser.Signal,a.onKeyboardClose=new Phaser.Signal;var b=function(b){function c(a,c){var d=b.call(this,a,c)||this;return d.addInputFieldFactory(),d}return __extends(c,b),c.prototype.addInputFieldFactory=function(){Phaser.GameObjectFactory.prototype.inputField=function(b,c,d,e){void 0===e&&(e=this.world);var f=new a.InputField(this.game,b,c,d);return e.add(f)},Phaser.GameObjectCreator.prototype.inputField=function(b,c,d){return new a.InputField(this.game,b,c,d)}},c}(Phaser.Plugin);b.Zoomed=!1,b.KeyboardOpen=!1,b.onKeyboardOpen=new Phaser.Signal,b.onKeyboardClose=new Phaser.Signal,a.Plugin=b}(PhaserInput||(PhaserInput={}));