/**
 *
 * Copyright (c) 2024 Analog Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
type SVGProps = {
	readonly width?: string;
	readonly height?: string;
};

function ConflictIcon({width, height}: SVGProps) {
	return (
		<svg
			width={width ?? '16'}
			height={height ?? '16'}
			viewBox='0 0 15 16'
			fill='none'
			xmlns='http://www.w3.org/2000/svg'
		>
			<path
				d='M8.58667 1.01333C9.36889 1.04889 10.1156 1.24444 10.8267 1.6C11.5733 1.95556 12.2311 2.41778 12.8 2.98667C14.1511 4.44444 14.8267 6.15111 14.8267 8.10667C14.8267 9.63556 14.2933 11.0933 13.2267 12.48C12.6933 13.12 12.0889 13.6533 11.4133 14.08C10.7378 14.4711 10.0089 14.7378 9.22667 14.88C7.52 15.2 5.97333 14.9689 4.58667 14.1867C3.87556 13.7956 3.25333 13.2978 2.72 12.6933C2.18667 12.0889 1.77778 11.4133 1.49333 10.6667C1.20889 9.92 1.03111 9.13778 0.96 8.32C0.924444 7.50222 1.03111 6.72 1.28 5.97333C1.81333 4.33778 2.75556 3.07556 4.10667 2.18667C4.74667 1.76 5.44 1.44 6.18667 1.22667C6.96889 1.01333 7.76889 0.942222 8.58667 1.01333ZM9.12 13.92C10.4711 13.6 11.5911 12.8889 12.48 11.7867C13.3689 10.5778 13.7778 9.31556 13.7067 8C13.7067 7.18222 13.5467 6.4 13.2267 5.65333C12.9422 4.90667 12.5333 4.24889 12 3.68C10.9689 2.64889 9.77778 2.08 8.42667 1.97333C7.75111 1.93778 7.07556 2.00889 6.4 2.18667C5.72444 2.32889 5.12 2.59556 4.58667 2.98667C3.44889 3.84 2.66667 4.96 2.24 6.34667C1.84889 7.73333 1.93778 9.06667 2.50667 10.3467C3.11111 11.6267 4.01778 12.6044 5.22667 13.28C5.79556 13.6356 6.41778 13.8667 7.09333 13.9733C7.76889 14.08 8.44444 14.0622 9.12 13.92ZM7.89333 7.52L10.2933 5.01333L10.9867 5.70667L8.58667 8.21333L10.9867 10.72L10.2933 11.4133L7.89333 8.90667L5.49333 11.4133L4.8 10.72L7.2 8.21333L4.8 5.70667L5.49333 5.01333L7.89333 7.52Z'
				fill='#F14C4C'
			/>
		</svg>
	);
}

export default ConflictIcon;
