/**
 *
 * Copyright (c) 2023-2024 Analog Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
import React from "react";

export const LeftArrowIcon = () => {
  return (
    <svg
      width="17"
      height="16"
      viewBox="0 0 17 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6.32629 7.97612L10.6836 12.3334L10.0649 12.9521L5.39821 8.28548V7.66676L10.0649 3.0001L10.6836 3.61881L6.32629 7.97612Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const RightArrowIcon = () => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.0722 8.02388L5.71484 3.66657L6.33356 3.04785L11.0002 7.71452V8.33324L6.33356 12.9999L5.71484 12.3812L10.0722 8.02388Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const HelpIcon = () => {
  return (
    <svg
      width="17"
      height="16"
      viewBox="0 0 17 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.31507 2.58213C6.0693 2.08219 6.9196 1.74524 7.81155 1.59285C8.7035 1.44045 9.61744 1.47597 10.4949 1.69712C11.3723 1.91827 12.1939 2.32019 12.9071 2.87715C13.6202 3.43411 14.2092 4.13383 14.6364 4.93154C15.0636 5.72924 15.3195 6.60734 15.3877 7.50964C15.456 8.41194 15.3351 9.31854 15.0328 10.1714C14.7305 11.0243 14.2535 11.8047 13.6323 12.4626C13.011 13.1205 12.2592 13.6415 11.4251 13.9921C9.93292 14.6194 8.26045 14.6673 6.73483 14.1266C5.20921 13.5858 3.94022 12.4954 3.17612 11.0685C2.41202 9.64156 2.20779 7.98091 2.60338 6.41138C2.99897 4.84186 3.96592 3.4764 5.31507 2.58213ZM5.86507 12.5821C6.50452 12.9869 7.22064 13.2554 7.96861 13.3707C8.71657 13.486 9.48029 13.4458 10.212 13.2524C10.9437 13.059 11.6276 12.7168 12.2209 12.247C12.8143 11.7772 13.3043 11.19 13.6603 10.5221C14.0163 9.85428 14.2306 9.12015 14.2899 8.36567C14.3491 7.61119 14.2521 6.85259 14.0047 6.13735C13.7574 5.42211 13.3651 4.76561 12.8524 4.20893C12.3397 3.65225 11.7176 3.20737 11.0251 2.90213C10.0239 2.48121 8.9188 2.37314 7.85506 2.59213C6.78693 2.80075 5.80531 3.32326 5.03575 4.09282C4.26619 4.86237 3.74369 5.844 3.53507 6.91213C3.32325 7.97724 3.43149 9.08122 3.84613 10.0849C4.26078 11.0886 4.96327 11.9471 5.86507 12.5521V12.5821ZM9.83506 4.48213C9.56535 4.37115 9.27671 4.31342 8.98506 4.31213C8.69296 4.30877 8.4034 4.36668 8.13507 4.48213C7.87509 4.59492 7.63788 4.7542 7.43507 4.95213C7.23821 5.14994 7.08194 5.38434 6.97507 5.64213C6.85616 5.90585 6.79806 6.19293 6.80507 6.48213H7.67507C7.67308 6.22378 7.74812 5.97069 7.89061 5.75518C8.0331 5.53966 8.23658 5.37149 8.47507 5.27213C8.63589 5.20138 8.80938 5.16396 8.98506 5.16213C9.16398 5.16398 9.34073 5.20137 9.50506 5.27213C9.81978 5.4067 10.0705 5.65742 10.2051 5.97213C10.2688 6.13472 10.3027 6.3075 10.3051 6.48213C10.3022 6.66314 10.2577 6.84106 10.1751 7.00213C10.0821 7.15776 9.97135 7.30206 9.84507 7.43213L9.42507 7.80213C9.27489 7.9423 9.13456 8.09266 9.00506 8.25213C8.87159 8.41849 8.76373 8.60387 8.68507 8.80213C8.59167 9.0163 8.54726 9.24861 8.55507 9.48213V9.92213H9.42507V9.48213C9.42313 9.30052 9.4679 9.12146 9.55507 8.96213C9.64725 8.80597 9.75806 8.66158 9.88507 8.53213C10.0178 8.3914 10.158 8.25787 10.3051 8.13213C10.4552 7.99196 10.5956 7.8416 10.7251 7.68213C10.8585 7.51577 10.9664 7.33039 11.0451 7.13213C11.1301 6.92594 11.1743 6.70518 11.1751 6.48213C11.1738 6.19048 11.116 5.90184 11.0051 5.63213C10.7697 5.11801 10.3532 4.70861 9.83506 4.48213ZM9.42507 11.7021V10.8221H8.55507V11.7021H9.42507Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const EngineerZoneIcon = () => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6.7 10.5333V13.9249L9.78328 10.5333H11.0333C12.4693 10.5333 13.6333 9.36927 13.6333 7.93333V4.46667C13.6333 3.03073 12.4693 1.86667 11.0333 1.86667H4.96667C3.53073 1.86667 2.36667 3.03073 2.36667 4.46667V7.93333C2.36667 9.36927 3.53073 10.5333 4.96667 10.5333H6.7ZM10.1667 11.4H11.0333C12.9479 11.4 14.5 9.84792 14.5 7.93333V4.46667C14.5 2.55208 12.9479 1 11.0333 1H4.96667C3.05208 1 1.5 2.55208 1.5 4.46667V7.93333C1.5 9.84792 3.05208 11.4 4.96667 11.4H5.83333V13.9249C5.83333 14.7171 6.80842 15.0941 7.34128 14.5079L10.1667 11.4ZM8.38261 8.8001C8.3595 8.8001 8.3387 8.79317 8.32021 8.7793C8.30634 8.76081 8.29941 8.74001 8.29941 8.7169V7.9681C8.29941 7.93112 8.31096 7.89645 8.33408 7.8641L10.5735 4.8273C10.5828 4.81806 10.5828 4.80881 10.5735 4.79957C10.5689 4.79032 10.5597 4.7857 10.5458 4.7857H8.38261C8.3595 4.7857 8.3387 4.77877 8.32021 4.7649C8.30634 4.74641 8.29941 4.72561 8.29941 4.7025V4.02997C8.29941 4.00686 8.30634 3.98837 8.32021 3.9745C8.3387 3.95601 8.3595 3.94677 8.38261 3.94677H11.5927C11.6159 3.94677 11.6343 3.95601 11.6482 3.9745C11.6667 3.98837 11.6759 4.00686 11.6759 4.02997V4.77877C11.6759 4.81574 11.6644 4.85041 11.6413 4.88277L9.40181 7.91957C9.39719 7.92881 9.39719 7.93806 9.40181 7.9473C9.40643 7.95654 9.41568 7.96117 9.42954 7.96117H11.5927C11.6159 7.96117 11.6343 7.97041 11.6482 7.9889C11.6667 8.00277 11.6759 8.02126 11.6759 8.04437V8.7169C11.6759 8.74001 11.6667 8.76081 11.6482 8.7793C11.6343 8.79317 11.6159 8.8001 11.5927 8.8001H8.38261ZM7.82801 4.76484C7.8465 4.74636 7.85574 4.72556 7.85574 4.70244V4.02991C7.85574 4.0068 7.8465 3.98831 7.82801 3.97444C7.81414 3.95596 7.79565 3.94671 7.77254 3.94671H4.56934C4.54623 3.94671 4.52543 3.95596 4.50694 3.97444C4.49307 3.98831 4.48614 4.0068 4.48614 4.02991V8.71684C4.48614 8.73996 4.49307 8.76076 4.50694 8.77924C4.52543 8.79311 4.54623 8.80004 4.56934 8.80004H7.77254C7.79565 8.80004 7.81414 8.79311 7.82801 8.77924C7.8465 8.76076 7.85574 8.73996 7.85574 8.71684V8.04431C7.85574 8.0212 7.8465 8.00271 7.82801 7.98884C7.81414 7.97036 7.79565 7.96111 7.77254 7.96111H5.49841C5.4753 7.96111 5.46374 7.94955 5.46374 7.92644V6.80324C5.46374 6.78013 5.4753 6.76858 5.49841 6.76858H6.98907C7.01219 6.76858 7.03067 6.76164 7.04454 6.74778C7.06303 6.72929 7.07227 6.70849 7.07227 6.68538V6.01284C7.07227 5.98973 7.06303 5.97124 7.04454 5.95738C7.03067 5.93889 7.01219 5.92964 6.98907 5.92964H5.49841C5.4753 5.92964 5.46374 5.91809 5.46374 5.89498V4.82031C5.46374 4.7972 5.4753 4.78564 5.49841 4.78564H7.77254C7.79565 4.78564 7.81414 4.77871 7.82801 4.76484Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const TechSupportIcon = () => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      xmlns="http://www.w3.org/2000/svg"
      fill="currentColor"
    >
      <path d="M4.5 1L4 1.5V3.02746C4.16417 3.00932 4.331 3 4.5 3C4.669 3 4.83583 3.00932 5 3.02746V2H14V7H12.2929L11 8.29289V7H8.97254C8.99068 7.16417 9 7.331 9 7.5C9 7.669 8.99068 7.83583 8.97254 8H10V9.5L10.8536 9.85355L12.7071 8H14.5L15 7.5V1.5L14.5 1H4.5Z" />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M6.41705 10.4288C7.37039 9.80348 8 8.72527 8 7.5C8 5.567 6.433 4 4.5 4C2.567 4 1 5.567 1 7.5C1 8.72527 1.62961 9.80348 2.58295 10.4288C2.11364 10.6498 1.68557 10.9505 1.31802 11.318C0.900156 11.7359 0.568688 12.232 0.342542 12.7779C0.180451 13.1692 0.0747425 13.5807 0.0278638 14C0.00933826 14.1657 0 14.3326 0 14.5V15H1L0.999398 14.5C0.999398 14.4784 0.999599 14.4567 1 14.4351C1.00811 13.9975 1.09823 13.5651 1.26587 13.1604C1.44179 12.7357 1.69964 12.3498 2.0247 12.0247C2.34976 11.6996 2.73566 11.4418 3.16038 11.2659C3.57088 11.0958 4.00986 11.0056 4.45387 10.9997C4.46922 10.9999 4.4846 11 4.5 11C4.5154 11 4.53078 10.9999 4.54613 10.9997C4.99014 11.0056 5.42912 11.0958 5.83962 11.2659C6.26433 11.4418 6.65024 11.6996 6.9753 12.0247C7.30036 12.3498 7.55821 12.7357 7.73413 13.1604C7.90177 13.5651 7.99189 13.9975 8 14.4351C8.0004 14.4567 8.0006 14.4784 8.0006 14.5L8 15H9V14.5C9 14.3326 8.99066 14.1657 8.97214 14C8.92526 13.5807 8.81955 13.1692 8.65746 12.7779C8.43131 12.232 8.09984 11.7359 7.68198 11.318C7.31443 10.9505 6.88636 10.6498 6.41705 10.4288ZM4.5 10C3.11929 10 2 8.88071 2 7.5C2 6.11929 3.11929 5 4.5 5C5.88071 5 7 6.11929 7 7.5C7 8.88071 5.88071 10 4.5 10Z"
      />
    </svg>
  );
};

export const GitHubIcon = () => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="0 0 16 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_1334_231077)">
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.97553 0C3.57186 0 0 3.57186 0 7.97553C0 11.4985 2.29969 14.4832 5.43119 15.5596C5.82263 15.6086 5.96942 15.3639 5.96942 15.1682C5.96942 14.9725 5.96942 14.4832 5.96942 13.7982C3.76758 14.2875 3.27829 12.7217 3.27829 12.7217C2.93578 11.792 2.39755 11.5474 2.39755 11.5474C1.66361 11.0581 2.44648 11.0581 2.44648 11.0581C3.22936 11.107 3.66972 11.8899 3.66972 11.8899C4.40367 13.1131 5.52905 12.7706 5.96942 12.5749C6.01835 12.0367 6.263 11.6942 6.45872 11.4985C4.69725 11.3028 2.83792 10.6177 2.83792 7.53517C2.83792 6.65443 3.1315 5.96942 3.66972 5.38226C3.6208 5.23547 3.32722 4.40367 3.76758 3.32722C3.76758 3.32722 4.4526 3.1315 5.96942 4.15902C6.6055 3.9633 7.29052 3.91437 7.97553 3.91437C8.66055 3.91437 9.34556 4.01223 9.98165 4.15902C11.4985 3.1315 12.1835 3.32722 12.1835 3.32722C12.6239 4.40367 12.3303 5.23547 12.2813 5.43119C12.7706 5.96942 13.1131 6.70336 13.1131 7.5841C13.1131 10.6667 11.2538 11.3028 9.49235 11.4985C9.78593 11.7431 10.0306 12.2324 10.0306 12.9664C10.0306 14.0428 10.0306 14.8746 10.0306 15.1682C10.0306 15.3639 10.1774 15.6086 10.5688 15.5596C13.7492 14.4832 16 11.4985 16 7.97553C15.9511 3.57186 12.3792 0 7.97553 0Z"
          fill="currentColor"
        />
      </g>
      <defs>
        <clipPath id="clip0_1334_231077">
          <rect width="16" height="16" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
};
