/**
 *
 * Copyright (c) 2024 Analog Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
import React from "react";

export const NewFileIcon = () => {
  return (
    <svg
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M10.4 2.12L14.24 6.02L14.36 6.5V8.72H13.22V7.58H8.72V3.08H3.08V15.5H7.58V16.58H2.54L2 16.04V2.54L2.54 2H10.1L10.4 2.12ZM9.86 3.08V6.5H13.1L9.86 3.08ZM14.36 18.86H13.22V15.5H9.86V14.36H13.22V11H14.36V14.36H17.72V15.5H14.36V18.86Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const OpenFileIcon = () => {
  return (
    <svg
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M5.64 7.52L7.92 5.18V4.4L5.52 2L4.74 2.78L6.18 4.22H2.82C2.02 4.22 1.34 4.5 0.78 5.06C0.26 5.62 0 6.3 0 7.1C0 7.86 0.26 8.52 0.78 9.08C1.34 9.6 2.02 9.86 2.82 9.86H3.36V8.72H2.82C2.34 8.72 1.94 8.56 1.62 8.24C1.3 7.92 1.12 7.52 1.08 7.04C1.08 6.56 1.24 6.16 1.56 5.84C1.92 5.52 2.34 5.36 2.82 5.36H6.18L4.74 6.8L5.52 7.58L5.64 7.52ZM11.22 3.08H8.22L7.08 2H12.36L13.14 2.3L16.56 5.66L16.86 6.5V16.58L15.72 17.72H5.64L4.5 16.58V8.18L5.64 9.14V16.58H15.72V7.58H11.22V3.08ZM12.36 3.08V6.5H15.72L12.36 3.08Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const BrowseExamplesIcon = () => {
  return (
    <svg
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M16.56 12.08V16.04L15.96 16.58H10.92V15.5H15.42V13.22H4.98C4.86 13.22 4.76 13.24 4.68 13.28C4.44 13.4 4.28 13.56 4.2 13.76C4.16 13.88 4.14 13.98 4.14 14.06V14.66C4.14 14.74 4.16 14.84 4.2 14.96C4.28 15.16 4.44 15.32 4.68 15.44C4.76 15.48 4.86 15.5 4.98 15.5H5.28V16.58H4.98C4.74 16.58 4.5 16.54 4.26 16.46C3.74 16.26 3.38 15.9 3.18 15.38C3.06 15.14 3 14.9 3 14.66V3.98C3.04 3.74 3.1 3.5 3.18 3.26C3.38 2.74 3.74 2.36 4.26 2.12C4.5 2.04 4.74 2 4.98 2H15.96L16.56 2.54V12.08ZM5.28 12.08H15.42V3.08H5.28V12.08ZM6.42 4.22V5.36H7.56V4.22H6.42ZM6.42 6.5V7.58H7.56V6.5H6.42ZM7.56 8.72V9.86H6.42V8.72H7.56ZM8.1 16.04L9.48 17.72H9.78V14.36H6.42V17.72H6.72L8.1 16.04Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const ViewDocumentationIcon = () => {
  return (
    <svg
      width="20"
      height="20"
      viewBox="0 0 20 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M13.74 2.12L17.46 5.84L17.64 6.26V17.18L17.04 17.72H13.14V16.58H16.5V7.58H12.54L12 7.04V3.08H5.22V7.58H4.14V2.54L4.68 2H13.38L13.74 2.12ZM13.14 6.5H16.5L13.14 3.08V6.5ZM11.4 8.72H3.54L3 9.32V17.18L3.54 17.72H11.4L12 17.18V9.32L11.4 8.72ZM10.86 16.58H4.14V9.86H10.86V16.58ZM9.72 11.54V14.9H8.64V12.92L5.64 15.86L4.86 15.08L7.8 12.08H5.82V11H9.18L9.72 11.54Z"
        fill="currentColor"
      />
    </svg>
  );
};

export const WalkthroughIcon = () => {
  return (
    <svg
      width="40"
      height="40"
      viewBox="0 0 40 40"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <mask
        id="mask0_8728_219190"
        style={{ maskType: "alpha" }}
        maskUnits="userSpaceOnUse"
        x="0"
        y="0"
        width="40"
        height="40"
      >
        <path
          d="M35.625 0H4.375C1.95875 0 0 1.95875 0 4.375V35.625C0 38.0412 1.95875 40 4.375 40H35.625C38.0412 40 40 38.0412 40 35.625V4.375C40 1.95875 38.0412 0 35.625 0Z"
          fill="#101820"
        />
      </mask>
      <g mask="url(#mask0_8728_219190)">
        <rect width="40" height="40" fill="white" />
        <path
          d="M32.1875 20L7.8125 5.92651V34.0734L32.1875 20Z"
          fill="#A8DEF5"
        />
        <mask
          id="mask1_8728_219190"
          style={{ maskType: "alpha" }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="40"
          height="40"
        >
          <path
            d="M20 32.1875L23.75 28.4375H26.4015L20 34.8391L5.16089 20L20 5.16095L34.839 20L33.514 21.3266L32.0265 22.8125H29.375L32.1875 20L20 7.81251L7.81245 20L20 32.1875Z"
            fill="#101820"
          />
          <path
            d="M17.964 15.3125H15.3124L19.9999 20L15.3124 24.6875H17.964L22.6515 20L17.964 15.3125Z"
            fill="#101820"
          />
          <path
            d="M24.0687 24.6875L20.8218 26.5625H32.1874V24.6875H24.0687Z"
            fill="#101820"
          />
        </mask>
        <g mask="url(#mask1_8728_219190)">
          <rect width="40" height="40" fill="#0067B9" />
        </g>
      </g>
    </svg>
  );
};
