---
description: Features included with CodeFusion Studio
author: Analog Devices
date: 2024-09-24
---

# Features

See all the features CodeFusion Studio has to offer.

## Homepage

Homepage with quick access links for common tasks, links to articles and videos related to your projects, user guides, hardware reference manuals, data sheets, and other useful resources.

![Welcome homepage](./images/welcome-homepage-light.png#only-light)
![Welcome homepage](./images/welcome-homepage-dark.png#only-dark)

## Project wizard

A new [project wizard](../projects/create-new-project.md) for quickly creating projects as well as example applications to jump-start your development.

![Project Wizard](./images/project-wizard-light.png#only-light)
![Project Wizard](./images/project-wizard-dark.png#only-dark)

## Toolchain support

Toolchain support for [building](../projects/tasks.md) applications on Arm and RISC-V processors.

- MSDK projects use the Arm GNU toolchain and the xPack GNU RISK-V embedded GCC toolchain.
- Zephyr projects use the Zephyr SDK's Arm and RISC-V toolchains.

## Configuration tools

[Pin  and clock configuration](../tools/config-tool/index.md) tools for assigning signals to pins, configuring pin values such as input or output mode and power supply, viewing register details and values, and generating source code to be included in your project.

![pinmux](../tools/config-tool/images/pinmux-light.png#only-light)
![pinmux](../tools/config-tool/images/pinmux-dark.png#only-dark)

## ELF file explorer

[ELF File Explorer](../tools/elf-file-explorer.md) provides a graphical interface to help understand and analyze the contents of ELF files.

- Run SQL queries for symbols found in the ELF file:

![symbols](./images/symbols-light.gif#only-light)
![symbols](./images/symbols-dark.gif#only-dark)

- Browse through segments, sections, and symbols with the interactive memory map:

![Memory layout](./images/memorylayout-light.gif#only-light)
![Memory layout](./images/memorylayout-dark.gif#only-dark)

## Debug

[Debugging](../debugging/index.md) features including breakpoints, disassembly, heterogeneous debug, etc.

![Debug session](../debugging/images/launch-debug-session-light.png#only-light)
![Debug session](../debugging/images/launch-debug-session-dark.png#only-dark)
