---
description: Release Notes for CodeFusion Studio 1.0.0
author: Analog Devices
date: 2024-10-01
---

# 1.0.0 Release Notes

<!-- markdownlint-disable MD024 -->

## Source

CodeFusion Studio source can be found on [:octicons-link-external-24: GitHub](https://github.com/analogdevicesinc/codefusion-studio/releases/tag/V1.0.0/) under tag `V1.0.0`{:target="_blank"}

## About this release

CodeFusion Studio 1.0.0 is the first release of CodeFusion Studio. This release includes support for various MAX32xxx and MAX7800x parts using the Micro SDK or Zephyr. Pin and Clock config tools are available, as well as an ELF Explorer utility.

## What's new

### Tools

- [**Pin Config Tool**](../user-guide/tools/config-tool/pin-config.md): Manage pin multiplexing and pin config choices in a graphical environment, before generating code for your SoC.
- [**Clock Config Tool**](../user-guide/tools/config-tool/clock-config.md): Enable or disable the clock to various peripherals, and configure any dividers, muxes, or intermediate steps in the clock tree.
- [**ELF File Explorer**](../user-guide/tools/elf-file-explorer.md): Perform detailed analysis and inspection of ELF file contents. Currently limited to GCC-derived ELF files.
- [**Quick Action Panel**](../user-guide/projects/tasks.md): Access quick links to perform common tasks like **build**, **clean**, **flash**, and **debug**.
- [**CFS Build Task Icons**](../user-guide/projects/tasks.md): Execute selected tasks for the active project with the status bar icons.
- [**CFS Terminal**](../user-guide/projects/cfs-terminal.md): Use a terminal variant to VS Code that is aware of CFS settings and paths. Call `cfsutil`, Zephyr's `west`, and more without any manual configuration.

### SDK and software

- Support for Zephyr 3.7. [:octicons-link-external-24: Get started](https://docs.zephyrproject.org/3.7.0/){:target="_blank"}
- Support for the Micro SDK (MSDK). [:octicons-link-external-24: Get started with MSDK](https://analogdevicesinc.github.io/msdk/USERGUIDE/){:target="_blank"}

### Host architecture support

CodeFusion Studio is supported on the following host operating systems:

- Windows 10 or 11 (64-bit)
- macOS (ARM64)
- Ubuntu 22.04 and later (64-bit)

### Target architecture support

Introduced support for the following processors:

| Processor                                                    | MSDK | Zephyr | Pin Config   | Clock Config |
| ------------------------------------------------------------ | ---- | ------ | ------------ | ------------ |
| [MAX32655](https://www.analog.com/en/products/MAX32655.html) | Yes  | -      | -            | -            |
| [MAX32662](https://www.analog.com/en/products/MAX32662.html) | Yes  | -      | -            | -            |
| [MAX32670](https://www.analog.com/en/products/MAX32670.html) | Yes  | -      | -            | -            |
| [MAX32672](https://www.analog.com/en/products/MAX32672.html) | Yes  | -      | -            | -            |
| [MAX32675](https://www.analog.com/en/products/MAX32675.html) | Yes  | -      | -            | -            |
| [MAX32690](https://www.analog.com/en/products/MAX32690.html) | Yes  | Yes    | Yes          | Yes          |
| [MAX78000](https://www.analog.com/en/products/MAX78000.html) | Yes  | -      | -            | -            |
| [MAX78002](https://www.analog.com/en/products/MAX78002.html) | Yes  | -      | Yes          | -            |

## Known Issues

### Project management issues

- No `launch.json` in imported Zephyr samples.
    - Zephyr samples do not have a `launch.json` generated when imported. When trying to debug, you will be prompted to create a new `launch.json` file which you can modify as required.

### Tools Issues

- Clock speeds displayed in Clock Config tool
    - The clock displayed on the canvas is the input clock to the peripheral and may not take into account any internal clock dividers in the peripheral itself. Such internal clock dividers are generally configured when initializing and configuring the peripheral in your application code.
- Pin Config for MAX78002
    - SWD pin configuration (`MISC.SWDIO` and `MISC.SWCLK`) may not work as expected. Leave `SWDIO`, `SWCLK`, and `GPIO` pins `P0.28` or `P0.29` disabled in the pin config tool.
- Pin Config for MAX32690
    - `P0.18`, `P3.8`, and `P3.9` cannot be assigned or configured on the MAX32690 WLP. They can only be used in the default power on mode (inputs, no pulls, using VDDIO).
- Spurious compilation errors in headers
    - Incomplete IntelliSense Configuration prevents IntelliSense scanning all include paths which may result in false entries in the **Problems** tab. These can be ignored if the application builds successfully.
- GPIO pull strength is inverted under Zephyr.
    - The Zephyr 3.7 version of the `MXC_GPIO_Config()` function sets the pull strength inverted. When using Zephyr, set the **Select Pull-up/Pull-down** field in the **Pin Config** tool to the opposite strength of what you require:

| Required Value   | Select in Config Tool | Value of GPIOn_PS |
| ---------------- | --------------------- | ----------------- |
| Strong Pull-Up   | Weak Pull-Up          | 0                 |
| Weak Pull-Up     | Strong Pull-Up        | 1                 |
| Weak Pull-Down   | Strong Pull-Down      | 1                 |
| Strong Pull-Down | Weak Pull-Down        | 0                 |

!!! note
    For MSDK projects the values are correct and should be used normally within the **Pin Config** tool.
    The value of the GPIO pull select `PS` register should be 0 when strong and 1 when weak.

- ELF File Explorer doesn't refresh automatically.
    - If you modify an ELF file while it is open in the ELF Explorer, you will need to close and reopen the file to see any changes.

### Debug issues

- Segger JLink does not support all parts. See the following table for details.

| Part          | Issue                       | Alternatives                                   |
| ------------- | --------------------------- | ---------------------------------------------- |
| MAX32662      | Not supported               | Use MAXPICO debugger instead                   |
| MAX32670      | Not supported               | Use MAXPICO debugger instead                   |
| MAX32690FTHR  | Serial output not available | Use MAXPICO debugger if you need serial output |
| APARD32690    | Serial output not available | Use MAXPICO debugger if you need serial output |
| MAX78000FTHR  | Not supported               | Use MAXPICO debugger instead                   |
| MAX78002      | Not supported               | Use MAXPICO debugger or MAX78000 instead       |

!!! note
    When selecting a JLink session for the MAX78002, CodeFusion Studio will use a MAX78000 session implicitly so no manual intervention is required.

- M4 core breakpoints are also set on RISC-V core.
    - If debugging a dual core application and setting a breakpoint on the M4 that could also apply to the RISC-V core such as a file and line combination or a symbol that is present in both images, then that breakpoint will also be applied to the RISC-V core errorenously.
      This can be avoided by either using a unique file or symbol name on each core or setting the breakpoints directly from the disassembly view.
    - Another side effect of this is that the RISC-V appears to have 2 breakpoints set on `main`, so you may need to run or step twice to run beyond the first line in your `main` function.
