"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.expect = exports.FancyTypes = exports.Config = exports.command = exports.test = void 0;
const fancy_test_1 = require("fancy-test");
const node_path_1 = require("node:path");
const command_1 = require("./command");
const exit_1 = __importDefault(require("./exit"));
const hook_1 = __importDefault(require("./hook"));
const load_config_1 = require("./load-config");
function traverseFilePathUntil(filename, predicate) {
    let current = filename;
    while (!predicate(current)) {
        current = (0, node_path_1.dirname)(current);
    }
    return current;
}
// Update to path.dirname(url.fileURLToPath(import.meta.url)) whenever we update tsconfig target to ES2020
// eslint-disable-next-line unicorn/prefer-module
load_config_1.loadConfig.root = traverseFilePathUntil(require.main?.path ?? module.path, (p) => !p.includes('node_modules'));
exports.test = fancy_test_1.fancy
    .register('loadConfig', load_config_1.loadConfig)
    .register('command', command_1.command)
    .register('exit', exit_1.default)
    .register('hook', hook_1.default)
    .env({ NODE_ENV: 'test' });
exports.default = exports.test;
var command_2 = require("./command");
Object.defineProperty(exports, "command", { enumerable: true, get: function () { return command_2.command; } });
var core_1 = require("@oclif/core");
Object.defineProperty(exports, "Config", { enumerable: true, get: function () { return core_1.Config; } });
var fancy_test_2 = require("fancy-test");
Object.defineProperty(exports, "FancyTypes", { enumerable: true, get: function () { return fancy_test_2.FancyTypes; } });
Object.defineProperty(exports, "expect", { enumerable: true, get: function () { return fancy_test_2.expect; } });
