/// <reference types="sinon" />
import { loadConfig } from './load-config';
export declare const test: import("fancy-test/lib/types").Base<import("fancy-test/lib/types").Context, {
    skip: {
        output: unknown;
        args: [];
    };
} & {
    only: {
        output: unknown;
        args: [];
    };
} & {
    retries: {
        output: unknown;
        args: any[];
    };
} & {
    catch: {
        output: {
            error: Error;
        };
        args: [arg: string | RegExp | ((err: Error) => any), opts?: {
            raiseIfNotThrown?: boolean | undefined;
        } | undefined];
    };
} & {
    env: {
        output: unknown;
        args: [env: {
            [k: string]: string | null | undefined;
        }, opts?: import("fancy-test/lib/types").EnvOptions | undefined];
    };
} & {
    stub: {
        output: {
            sandbox: import("sinon").SinonSandbox;
        };
        args: [object: any, path: any, fn: (stub: import("sinon").SinonStub<any[], any>) => import("sinon").SinonStub<any[], any>];
    };
} & {
    stdin: {
        output: unknown;
        args: [input: string, delay?: number | undefined];
    };
} & {
    stderr: {
        output: {
            readonly stderr: string;
        };
        args: [opts?: {
            print?: boolean | undefined;
            stripColor?: boolean | undefined;
        } | undefined];
    };
} & {
    stdout: {
        output: {
            readonly stdout: string;
        };
        args: [opts?: {
            print?: boolean | undefined;
            stripColor?: boolean | undefined;
        } | undefined];
    };
} & {
    nock: {
        output: {
            nock: number;
        };
        args: [host: string, options: import("fancy-test/lib/types").NockOptions | import("fancy-test/lib/types").NockCallback, cb?: import("fancy-test/lib/types").NockCallback | undefined];
    };
} & {
    timeout: {
        output: {
            timeout: number;
        };
        args: [timeout?: number | undefined];
    };
} & {
    loadConfig: {
        output: {
            config: import("@oclif/core/lib/interfaces").Config;
        };
        args: [opts?: loadConfig.Options | undefined];
    };
} & {
    command: {
        output: {
            config: import("@oclif/core/lib/interfaces").Config;
            expectation: string;
            returned: unknown;
        };
        args: [args: string | string[], opts?: loadConfig.Options | undefined];
    };
} & {
    exit: {
        output: {
            error: import("@oclif/core/lib/errors").CLIError;
        };
        args: [code?: number | undefined];
    };
} & {
    hook: {
        output: {
            config: import("@oclif/core/lib/interfaces").Config;
            expectation: string;
            returned: unknown;
        };
        args: [event: string, hookOpts?: Record<string, unknown> | undefined, options?: loadConfig.Options | undefined];
    };
}>;
export default test;
export { command } from './command';
export { Config } from '@oclif/core';
export { FancyTypes, expect } from 'fancy-test';
