"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stdin = exports.stderr = exports.stdout = void 0;
/* eslint-disable import/namespace */
const mock = require("stdout-stderr");
const create = (std) => (opts = {}) => ({
    run(ctx) {
        mock[std].start();
        mock[std].print = opts.print || process.env.TEST_OUTPUT === '1';
        mock[std].stripColor = opts.stripColor !== false;
        if (ctx[std] !== undefined)
            return;
        Object.defineProperty(ctx, std, {
            get: () => mock[std].output,
        });
    },
    finally() {
        mock[std].stop();
    },
});
exports.stdout = create('stdout');
exports.stderr = create('stderr');
const stdin = (input, delay = 0) => {
    let stdin;
    return {
        run() {
            stdin = require('mock-stdin').stdin();
            setTimeout(() => stdin.send(input), delay);
        },
        finally() {
            stdin.restore();
        },
    };
};
exports.stdin = stdin;
