/// <reference types="sinon" />
export declare const fancy: import("./types").Base<import("./types").Context, {
    skip: {
        output: unknown;
        args: [];
    };
} & {
    only: {
        output: unknown;
        args: [];
    };
} & {
    retries: {
        output: unknown;
        args: any[];
    };
} & {
    catch: {
        output: {
            error: Error;
        };
        args: [arg: string | RegExp | ((err: Error) => any), opts?: {
            raiseIfNotThrown?: boolean | undefined;
        } | undefined];
    };
} & {
    env: {
        output: unknown;
        args: [env: {
            [k: string]: string | null | undefined;
        }, opts?: import("./types").EnvOptions | undefined];
    };
} & {
    stub: {
        output: {
            sandbox: import("sinon").SinonSandbox;
        };
        args: [object: any, path: any, fn: (stub: import("sinon").SinonStub<any[], any>) => import("sinon").SinonStub<any[], any>];
    };
} & {
    stdin: {
        output: unknown;
        args: [input: string, delay?: number | undefined];
    };
} & {
    stderr: {
        output: {
            readonly stderr: string;
        };
        args: [opts?: {
            print?: boolean | undefined;
            stripColor?: boolean | undefined;
        } | undefined];
    };
} & {
    stdout: {
        output: {
            readonly stdout: string;
        };
        args: [opts?: {
            print?: boolean | undefined;
            stripColor?: boolean | undefined;
        } | undefined];
    };
} & {
    nock: {
        output: {
            nock: number;
        };
        args: [host: string, options: import("./types").NockOptions | import("./types").NockCallback, cb?: import("./types").NockCallback | undefined];
    };
} & {
    timeout: {
        output: {
            timeout: number;
        };
        args: [timeout?: number | undefined];
    };
}>;
export type Fancy = typeof fancy;
export default fancy;
export { expect } from './chai';
export * as FancyTypes from './types';
