"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
exports.default = (env, opts = {}) => {
    const envs = [];
    return {
        run() {
            // normalize to undefined
            const normalizedEnv = (0, lodash_1.mapValues)(env, v => v === null ? undefined : v);
            // store previous env for finally
            envs.push(process.env);
            if (opts.clear) {
                process.env = { ...normalizedEnv };
            }
            else {
                process.env = { ...process.env, ...normalizedEnv };
                Object.entries(normalizedEnv)
                    .filter(([, v]) => v === undefined)
                    .forEach(([k]) => {
                    delete process.env[k];
                });
            }
        },
        finally() {
            const env = envs.pop();
            if (env)
                process.env = env;
        },
    };
};
