"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.closest = void 0;
const chalk = require("chalk");
const core_1 = require("@oclif/core");
const Levenshtein = require("fast-levenshtein");
const closest = (target, possibilities) => { var _a, _b; return (_b = (_a = possibilities.map(id => ({ id, distance: Levenshtein.get(target, id, { useCollator: true }) })).sort((a, b) => a.distance - b.distance)[0]) === null || _a === void 0 ? void 0 : _a.id) !== null && _b !== void 0 ? _b : ''; };
exports.closest = closest;
const hook = async function (opts) {
    var _a;
    const hiddenCommandIds = new Set(opts.config.commands.filter(c => c.hidden).map(c => c.id));
    const commandIDs = [
        ...opts.config.commandIDs,
        ...opts.config.commands.flatMap(c => c.aliases),
    ].filter(c => !hiddenCommandIds.has(c));
    if (commandIDs.length === 0)
        return;
    let binHelp = `${opts.config.bin} help`;
    const idSplit = opts.id.split(':');
    if (opts.config.findTopic(idSplit[0])) {
        // if valid topic, update binHelp with topic
        binHelp = `${binHelp} ${idSplit[0]}`;
    }
    // alter the suggestion in the help scenario so that help is the first command
    // otherwise the user will be presented 'did you mean 'help'?' instead of 'did you mean "help <command>"?'
    let suggestion = /:?help:?/.test(opts.id) ? ['help', ...opts.id.split(':').filter(cmd => cmd !== 'help')].join(':') : (0, exports.closest)(opts.id, commandIDs);
    const readableSuggestion = (0, core_1.toConfiguredId)(suggestion, this.config);
    const originalCmd = (0, core_1.toConfiguredId)(opts.id, this.config);
    this.warn(`${chalk.yellow(originalCmd)} is not a ${opts.config.bin} command.`);
    let response = '';
    try {
        response = await core_1.ux.prompt(`Did you mean ${chalk.blueBright(readableSuggestion)}? [y/n]`, { timeout: 10000 });
    }
    catch (error) {
        this.log('');
        this.debug(error);
    }
    if (response === 'y') {
        // this will split the original command from the suggested replacement, and gather the remaining args as varargs to help with situations like:
        // confit set foo-bar -> confit:set:foo-bar -> config:set:foo-bar -> config:set foo-bar
        let argv = ((_a = opts.argv) === null || _a === void 0 ? void 0 : _a.length) ? opts.argv : opts.id.split(':').slice(suggestion.split(':').length);
        if (suggestion.startsWith('help:')) {
            // the args are the command/partial command you need help for (package:version)
            // we created the suggestion variable to start with "help" so slice the first entry
            argv = suggestion.split(':').slice(1);
            // the command is just the word "help"
            suggestion = 'help';
        }
        return this.config.runCommand(suggestion, argv);
    }
    this.error(`Run ${chalk.bold.cyan(binHelp)} for a list of available commands.`, { exit: 127 });
};
exports.default = hook;
