"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = require("fs/promises");
const http_call_1 = require("http-call");
const path_1 = require("path");
// eslint-disable-next-line max-params
async function run(name, file, version, registry, authorization) {
    const url = [
        registry.replace(/\/+$/, ''),
        name.replace('/', '%2f'), // scoped packages need escaped separator
    ].join('/');
    const headers = authorization ? { authorization } : {};
    await (0, promises_1.mkdir)((0, path_1.dirname)(file), { recursive: true });
    await (0, promises_1.writeFile)(file, JSON.stringify({ current: version, headers })); // touch file with current version to prevent multiple updates
    const { body } = await http_call_1.default.get(url, { headers, timeout: 5000 });
    await (0, promises_1.writeFile)(file, JSON.stringify(Object.assign(Object.assign({}, body['dist-tags']), { current: version, authorization })));
    process.exit(0); // eslint-disable-line unicorn/no-process-exit, no-process-exit
}
run(process.argv[2], process.argv[3], process.argv[4], process.argv[5], process.argv[6])
    .catch(require('@oclif/core/handle'));
