# Installation
> `npm install --save @types/path-browserify`

# Summary
This package contains type definitions for path-browserify (https://github.com/browserify/path-browserify).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/path-browserify.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/path-browserify/index.d.ts)
````ts
declare namespace path {
    interface PathObject {
        root: string;
        dir: string;
        base: string;
        ext: string;
        name: string;
    }

    interface Path {
        resolve(...pathSegments: string[]): string;
        normalize(path: string): string;
        isAbsolute(path: string): boolean;
        join(...paths: string[]): string;
        relative(from: string, to: string): string;
        dirname(path: string): string;
        basename(path: string, ext?: string): string;
        extname(path: string): string;
        format(pathObject: Partial<PathObject>): string;
        parse(path: string): PathObject;

        readonly sep: string;
        readonly delimiter: string;
        readonly win32: null;
        readonly posix: Path;
    }
}

declare const path: path.Path;
export = path;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: none

# Credits
These definitions were written by [Nathan Bierema](https://github.com/Methuselah96).
