import { MsgSender, MsgReceiver, CecConfig, CallHandler } from 'cec-core';
export { CallHandler, CecConfig, MsgHandler, MsgReceiver, MsgSender } from 'cec-core';

type SubscribleCancel = () => void;
type MsgObserver = (value: any) => void;
declare class CecClient {
    private msgSender;
    private msgReceiver;
    private config?;
    private crossEndCall;
    private observerMap;
    constructor(msgSender: MsgSender, msgReceiver: MsgReceiver, config?: CecConfig | undefined);
    call<ReplyVal = any>(name: string, ...args: any[]): Promise<ReplyVal>;
    subscrible(name: string, observer: MsgObserver): SubscribleCancel;
}

type OnCallCancel = () => void;
type OnSubscribeCancel = () => void;
type SubscribleHandler = (next: (value: any) => void) => OnSubscribeCancel;
declare class CecServer {
    private msgSender;
    private msgReceiver;
    private crossEndCall;
    constructor(msgSender: MsgSender, msgReceiver: MsgReceiver);
    onCall(name: string, callHandler: CallHandler): OnCallCancel;
    onSubscribe(name: string, subscribleHandler: SubscribleHandler): OnSubscribeCancel;
}

export { CecClient, CecServer, type MsgObserver, type OnCallCancel, type OnSubscribeCancel, type SubscribleCancel, type SubscribleHandler };
