import { ProgressReporter } from './progress';
interface IFetchStableOptions {
    timeout: number;
    cachePath: string;
    platform: string;
}
interface IFetchInferredOptions extends IFetchStableOptions {
    extensionsDevelopmentPath?: string | string[];
}
export declare const fetchStableVersions: (timeout: number) => Promise<string[]>;
export declare const fetchInsiderVersions: (timeout: number) => Promise<string[]>;
export declare function fetchTargetInferredVersion(options: IFetchInferredOptions): Promise<string>;
/**
 * Adapted from https://github.com/microsoft/TypeScript/issues/29729
 * Since `string | 'foo'` doesn't offer auto completion
 */
declare type StringLiteralUnion<T extends string> = T | (string & {});
export declare type DownloadVersion = StringLiteralUnion<'insiders' | 'stable'>;
export declare type DownloadPlatform = StringLiteralUnion<'darwin' | 'darwin-arm64' | 'win32-x64-archive' | 'win32-arm64-archive' | 'linux-x64' | 'linux-arm64' | 'linux-armhf'>;
export interface DownloadOptions {
    readonly cachePath: string;
    readonly version: DownloadVersion;
    readonly platform: DownloadPlatform;
    readonly extensionDevelopmentPath?: string | string[];
    readonly reporter?: ProgressReporter;
    readonly extractSync?: boolean;
    readonly timeout?: number;
}
export declare const defaultCachePath: string;
/**
 * Download and unzip a copy of VS Code.
 * @returns Promise of `vscodeExecutablePath`.
 */
export declare function download(options?: Partial<DownloadOptions>): Promise<string>;
/**
 * Download and unzip a copy of VS Code in `.vscode-test`. The paths are:
 * - `.vscode-test/vscode-<PLATFORM>-<VERSION>`. For example, `./vscode-test/vscode-win32-1.32.0`
 * - `.vscode-test/vscode-win32-insiders`.
 *
 * *If a local copy exists at `.vscode-test/vscode-<PLATFORM>-<VERSION>`, skip download.*
 *
 * @param version The version of VS Code to download such as `1.32.0`. You can also use
 * `'stable'` for downloading latest stable release.
 * `'insiders'` for downloading latest Insiders.
 * When unspecified, download latest stable version.
 *
 * @returns Promise of `vscodeExecutablePath`.
 */
export declare function downloadAndUnzipVSCode(options: Partial<DownloadOptions>): Promise<string>;
export declare function downloadAndUnzipVSCode(version?: DownloadVersion, platform?: DownloadPlatform, reporter?: ProgressReporter, extractSync?: boolean): Promise<string>;
export {};
