"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_path_1 = require("node:path");
const performance_1 = require("../performance");
const fs_1 = require("../util/fs");
const util_1 = require("../util/util");
const Plugin = __importStar(require("./plugin"));
const util_2 = require("./util");
// eslint-disable-next-line new-cap
const debug = (0, util_2.Debug)();
class PluginLoader {
    options;
    errors = [];
    plugins = new Map();
    pluginsProvided = false;
    constructor(options) {
        this.options = options;
        if (options.plugins) {
            this.pluginsProvided = true;
            this.plugins = Array.isArray(options.plugins) ? new Map(options.plugins.map((p) => [p.name, p])) : options.plugins;
        }
    }
    async loadChildren(opts) {
        if (!this.pluginsProvided || opts.force) {
            await this.loadUserPlugins(opts);
            await this.loadDevPlugins(opts);
            await this.loadCorePlugins(opts);
        }
        return { errors: this.errors, plugins: this.plugins };
    }
    async loadRoot() {
        let rootPlugin;
        if (this.pluginsProvided) {
            const plugins = [...this.plugins.values()];
            rootPlugin = plugins.find((p) => p.root === this.options.root) ?? plugins[0];
        }
        else {
            const marker = performance_1.Performance.mark(performance_1.OCLIF_MARKER_OWNER, 'plugin.load#root');
            rootPlugin = new Plugin.Plugin({ isRoot: true, root: this.options.root });
            await rootPlugin.load();
            marker?.addDetails({
                commandCount: rootPlugin.commands.length,
                hasManifest: rootPlugin.hasManifest ?? false,
                name: rootPlugin.name,
                topicCount: rootPlugin.topics.length,
                type: rootPlugin.type,
                usesMain: Boolean(rootPlugin.pjson.main),
            });
            marker?.stop();
        }
        this.plugins.set(rootPlugin.name, rootPlugin);
        return rootPlugin;
    }
    async loadCorePlugins(opts) {
        if (opts.rootPlugin.pjson.oclif.plugins) {
            await this.loadPlugins(opts.rootPlugin.root, 'core', opts.rootPlugin.pjson.oclif.plugins);
        }
    }
    async loadDevPlugins(opts) {
        if (opts.devPlugins !== false) {
            // do not load oclif.devPlugins in production
            if ((0, util_1.isProd)())
                return;
            try {
                const { devPlugins } = opts.rootPlugin.pjson.oclif;
                if (devPlugins)
                    await this.loadPlugins(opts.rootPlugin.root, 'dev', devPlugins);
            }
            catch (error) {
                process.emitWarning(error);
            }
        }
    }
    async loadPlugins(root, type, plugins, parent) {
        if (!plugins || plugins.length === 0)
            return;
        const mark = performance_1.Performance.mark(performance_1.OCLIF_MARKER_OWNER, `config.loadPlugins#${type}`);
        debug('loading plugins', plugins);
        await Promise.all((plugins || []).map(async (plugin) => {
            try {
                const name = typeof plugin === 'string' ? plugin : plugin.name;
                const opts = {
                    name,
                    root,
                    type,
                };
                if (typeof plugin !== 'string') {
                    opts.tag = plugin.tag || opts.tag;
                    opts.root = plugin.root || opts.root;
                    opts.url = plugin.url;
                }
                if (parent) {
                    opts.parent = parent;
                }
                if (this.plugins.has(name))
                    return;
                const pluginMarker = performance_1.Performance.mark(performance_1.OCLIF_MARKER_OWNER, `plugin.load#${name}`);
                const instance = new Plugin.Plugin(opts);
                await instance.load();
                pluginMarker?.addDetails({
                    commandCount: instance.commands.length,
                    hasManifest: instance.hasManifest,
                    name: instance.name,
                    topicCount: instance.topics.length,
                    type: instance.type,
                    usesMain: Boolean(instance.pjson.main),
                });
                pluginMarker?.stop();
                this.plugins.set(instance.name, instance);
                if (parent) {
                    instance.parent = parent;
                    if (!parent.children)
                        parent.children = [];
                    parent.children.push(instance);
                }
                await this.loadPlugins(instance.root, type, instance.pjson.oclif.plugins || [], instance);
            }
            catch (error) {
                this.errors.push(error);
            }
        }));
        mark?.addDetails({ pluginCount: plugins.length });
        mark?.stop();
    }
    async loadUserPlugins(opts) {
        if (opts.userPlugins !== false) {
            try {
                const userPJSONPath = (0, node_path_1.join)(opts.dataDir, 'package.json');
                debug('reading user plugins pjson %s', userPJSONPath);
                const pjson = await (0, fs_1.readJson)(userPJSONPath);
                if (!pjson.oclif)
                    pjson.oclif = { schema: 1 };
                if (!pjson.oclif.plugins)
                    pjson.oclif.plugins = [];
                await this.loadPlugins(userPJSONPath, 'user', pjson.oclif.plugins.filter((p) => p.type === 'user'));
                await this.loadPlugins(userPJSONPath, 'link', pjson.oclif.plugins.filter((p) => p.type === 'link'));
            }
            catch (error) {
                if (error.code !== 'ENOENT')
                    process.emitWarning(error);
            }
        }
    }
}
exports.default = PluginLoader;
