"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const eslint_compat_utils_1 = require("eslint-compat-utils");
const utils_1 = require("../utils");
const get_auto_jsonc_rules_config_1 = require("../utils/get-auto-jsonc-rules-config");
exports.default = (0, utils_1.createRule)("auto", {
    meta: {
        docs: {
            description: "apply jsonc rules similar to your configured ESLint core rules",
            recommended: null,
            extensionRule: false,
            layout: false,
        },
        fixable: "code",
        schema: [],
        messages: {},
        type: "suggestion",
    },
    create(context, params) {
        const sourceCode = (0, eslint_compat_utils_1.getSourceCode)(context);
        if (!sourceCode.parserServices.isJSON) {
            return {};
        }
        const autoConfig = (0, get_auto_jsonc_rules_config_1.getAutoConfig)((0, eslint_compat_utils_1.getFilename)(context));
        const visitor = {};
        for (const ruleId of Object.keys(autoConfig)) {
            const rule = require(`./${ruleId.replace(/^jsonc\//u, "")}`).default;
            const subContext = {
                __proto__: context,
                options: getRuleOptions(autoConfig[ruleId]),
                report(options) {
                    if (options.messageId) {
                        options.message = `[${ruleId}] ${rule.meta.messages[options.messageId]}`;
                        delete options.messageId;
                    }
                    else {
                        options.message = `[${ruleId}] ${options.message}`;
                    }
                    context.report(options);
                },
            };
            const ruleVisitor = rule.jsoncDefineRule.create(subContext, params);
            for (const key of Object.keys(ruleVisitor)) {
                const newVisit = ruleVisitor[key];
                const oldVisit = visitor[key];
                if (!newVisit) {
                    continue;
                }
                if (!oldVisit) {
                    visitor[key] = ruleVisitor[key];
                }
                else {
                    visitor[key] = (...args) => {
                        oldVisit(...args);
                        newVisit(...args);
                    };
                }
            }
        }
        return visitor;
    },
});
function getRuleOptions(options) {
    if (!Array.isArray(options)) {
        return [];
    }
    return options.slice(1);
}
