"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash");
const fs = require("fs");
const core_1 = require("@oclif/core");
const aws_1 = require("../../aws");
const log_1 = require("../../log");
const Tarballs = require("../../tarballs");
const upload_util_1 = require("../../upload-util");
class UploadMacos extends core_1.Command {
    async run() {
        var _a;
        const { flags } = await this.parse(UploadMacos);
        const buildConfig = await Tarballs.buildConfig(flags.root, { targets: (_a = flags === null || flags === void 0 ? void 0 : flags.targets) === null || _a === void 0 ? void 0 : _a.split(',') });
        const { s3Config, config, dist } = buildConfig;
        const S3Options = {
            Bucket: s3Config.bucket,
            ACL: s3Config.acl || 'public-read',
        };
        const cloudKeyBase = (0, upload_util_1.commitAWSDir)(config.version, buildConfig.gitSha, s3Config);
        const upload = async (arch) => {
            const templateKey = (0, upload_util_1.templateShortKey)('macos', { bin: config.bin, version: config.version, sha: buildConfig.gitSha, arch });
            const cloudKey = `${cloudKeyBase}/${templateKey}`;
            const localPkg = dist(`macos/${templateKey}`);
            if (fs.existsSync(localPkg))
                await aws_1.default.s3.uploadFile(localPkg, Object.assign(Object.assign({}, S3Options), { CacheControl: 'max-age=86400', Key: cloudKey }));
            else
                this.error('Cannot find macOS pkg', {
                    suggestions: ['Run "oclif pack macos" before uploading'],
                });
        };
        const arches = _.uniq(buildConfig.targets
            .filter(t => t.platform === 'darwin')
            .map(t => t.arch));
        await Promise.all(arches.map(a => upload(a)));
        (0, log_1.log)(`done uploading macos pkgs for v${config.version}-${buildConfig.gitSha}`);
    }
}
exports.default = UploadMacos;
UploadMacos.description = 'upload macos installers built with pack:macos';
UploadMacos.flags = {
    root: core_1.Flags.string({ char: 'r', description: 'path to oclif CLI root', default: '.', required: true }),
    targets: core_1.Flags.string({ char: 't', description: 'comma-separated targets to upload (e.g.: darwin-x64,darwin-arm64)' }),
};
