import { Command, Interfaces } from '@oclif/core';
export default class Readme extends Command {
    static description: string;
    static flags: {
        dir: Interfaces.OptionFlag<string, import("@oclif/core/lib/interfaces/parser").CustomOptions>;
        multi: Interfaces.BooleanFlag<boolean>;
        aliases: Interfaces.BooleanFlag<boolean>;
        'repository-prefix': Interfaces.OptionFlag<string | undefined, import("@oclif/core/lib/interfaces/parser").CustomOptions>;
        version: Interfaces.OptionFlag<string | undefined, import("@oclif/core/lib/interfaces/parser").CustomOptions>;
    };
    private HelpClass;
    private flags;
    run(): Promise<void>;
    replaceTag(readme: string, tag: string, body: string): string;
    toc(__: Interfaces.Config, readme: string): string;
    usage(config: Interfaces.Config): string;
    multiCommands(config: Interfaces.Config, commands: Command.Cached[], dir: string): string;
    createTopicFile(file: string, config: Interfaces.Config, topic: Interfaces.Topic, commands: Command.Cached[]): void;
    commands(config: Interfaces.Config, commands: Command.Cached[]): string;
    renderCommand(config: Interfaces.Config, c: Command.Cached): string;
    commandCode(config: Interfaces.Config, c: Command.Cached): string | undefined;
    private repo;
    /**
     * fetches the path to a command
     */
    private commandPath;
    private commandUsage;
}
