"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const Tarballs = require("../../tarballs");
class PackTarballs extends core_1.Command {
    async run() {
        var _a;
        if (process.platform === 'win32')
            throw new Error('pack does not function on windows');
        const { flags } = await this.parse(PackTarballs);
        const buildConfig = await Tarballs.buildConfig(flags.root, { xz: flags.xz, targets: (_a = flags === null || flags === void 0 ? void 0 : flags.targets) === null || _a === void 0 ? void 0 : _a.split(',') });
        if (buildConfig.targets.length === 0) {
            throw new Error('Please specify one or more valid targets.');
        }
        await Tarballs.build(buildConfig, {
            tarball: flags.tarball,
            parallel: flags.parallel,
        });
    }
}
exports.default = PackTarballs;
PackTarballs.description = `packages oclif CLI into tarballs

This can be used to create oclif CLIs that use the system node or that come preloaded with a node binary.
`;
PackTarballs.flags = {
    root: core_1.Flags.string({ char: 'r', description: 'path to oclif CLI root', default: '.', required: true }),
    targets: core_1.Flags.string({ char: 't', description: 'comma-separated targets to pack (e.g.: linux-arm,win32-x64)' }),
    xz: core_1.Flags.boolean({ description: 'also build xz', allowNo: true }),
    parallel: core_1.Flags.boolean({ description: 'build tarballs in parallel' }),
    tarball: core_1.Flags.string({ char: 'l', description: 'optionally specify a path to a tarball already generated by NPM', required: false }),
};
